/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.mmr;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.scpi.Scpi;

public class Mmr {
    public static final int FLD_A = 0;
    public static final int FLD_T0 = 1;
    public static final int FLD_T1 = 2;
    public static final int FLD_P0 = 3;
    public static final int FLD_P1 = 4;
    public static final int FLD_D0 = 5;
    public static final int FLD_D1 = 6;
    public static final int FLD_I = 7;
    public static final int N_FIELDS = 8;
    private static final int BAUD_RATE = 9600;
    private static final double READ_TIMEOUT = 2.0;
    private static final int[] UNITS_LENGTH;
    private Reader reader;
    private Scpi scpi = new Scpi();
    private boolean open;
    private boolean powered;
    private Listener listener;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 2;
        nArray[7] = 3;
        UNITS_LENGTH = nArray;
    }

    public void open(int type, String ident) throws DriverException {
        if (type == 0) {
            throw new DriverException("Invalid connection type");
        }
        this.scpi.open(type, ident, 9600);
        this.scpi.setTimeout(2.0);
        this.open = true;
        this.reader = new Reader();
        this.reader.setDaemon(true);
        this.reader.start();
    }

    public void close() throws DriverException {
        if (!this.open) {
            throw new DriverException("Device not open");
        }
        this.open = false;
        this.powered = false;
        this.scpi.close();
    }

    public void addListener(Listener listener) {
        this.listener = listener;
    }

    public void removeListener() {
        this.listener = null;
    }

    private void sendListener(String reply) {
        if (this.listener == null) {
            return;
        }
        String[] fields = reply.split(",");
        double[] values = new double[8];
        int j = 0;
        while (j < 8) {
            String[] items = fields[j].split("=");
            int leng = items[1].length() - UNITS_LENGTH[j];
            values[j] = Double.valueOf(items[1].substring(0, leng));
            ++j;
        }
        this.listener.processData(values);
    }

    public static interface Listener {
        public void processData(double[] var1);

        public void setPowered(boolean var1);

        public void setClosed(Exception var1);
    }

    private class Reader
    extends Thread {
        private Exception excp;

        private Reader() {
        }

        @Override
        public void run() {
            while (Mmr.this.open) {
                try {
                    String data = Mmr.this.scpi.read();
                    if (!Mmr.this.powered) {
                        Mmr.this.powered = true;
                        if (Mmr.this.listener != null) {
                            Mmr.this.listener.setPowered(Mmr.this.powered);
                        }
                    }
                    Mmr.this.sendListener(data);
                }
                catch (DriverTimeoutException driverTimeoutException) {
                    if (!Mmr.this.powered) continue;
                    Mmr.this.powered = false;
                    if (Mmr.this.listener == null) continue;
                    Mmr.this.listener.setPowered(Mmr.this.powered);
                }
                catch (Exception e) {
                    this.excp = e;
                    break;
                }
            }
            if (!Mmr.this.open) {
                return;
            }
            try {
                Mmr.this.close();
            }
            catch (DriverException driverException) {}
            if (Mmr.this.listener != null) {
                Mmr.this.listener.setClosed(this.excp);
            }
        }
    }
}

