/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.mks;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.ascii.Multidrop;
import org.lsst.ccs.drivers.commons.DriverException;

public class Model9XX
extends Multidrop {
    public static final int DEFAULT_BAUDRATE = 9600;
    public static final int DEFAULT_ADDRESS = 253;
    public static final int RELAY_MIN = 1;
    public static final int RELAY_MAX = 3;
    public static final int OUTPUT_MIN = 1;
    public static final int OUTPUT_MAX = 2;
    private static final int LEVEL_925 = 0;
    private static final int LEVEL_972 = 1;
    private static final int LEVEL_974 = 2;
    private static final int LEVEL_UNKNOWN = 3;
    private static final Map<String, Unit> unitRespMap = new HashMap<String, Unit>();
    private static final Map<String, Direction> dirRespMap;
    private static final Map<String, Enable> enabRespMap;
    private static final Map<String, Gas> gasRespMap;
    private static final Map<String, Boolean> setRespMap;
    private static final Map<String, Boolean> activeRespMap;
    private static final Map<String, Integer> delayRespMap;
    private static final Map<String, Integer> levelMap;
    private static final byte RESP_INTR = 64;
    private static final byte[] RESP_TERM;
    private static final String CMND_SFX = ";FF";
    private String addrStr;
    private String cmndPfx;
    private final byte[] readBuff = new byte[256];
    private String model = "";
    private int cmndLevel = 3;
    private Object cmndSync = this;

    public Model9XX() {
        this.setDefaultBaud(9600);
        this.setDefaultAddress(253);
    }

    @Override
    public void open(Multidrop.ConnType connType, String ident, int baudRate, int dataChar, int addr) throws DriverException {
        super.open(connType, ident, baudRate, 0, addr);
        this.setAddress(this.address);
        this.cmndSync = this.getSyncObject();
        try {
            this.model = this.getModel();
            this.cmndLevel = 3;
            if (this.model.length() >= 3) {
                this.cmndLevel = levelMap.get(this.model.substring(0, 3));
            }
            if (this.cmndLevel == 3) {
                throw new DriverException("Unrecognized gauge model: " + this.model);
            }
        }
        catch (DriverException e) {
            this.close();
            throw e;
        }
    }

    public String getDeviceType() throws DriverException {
        return this.readString("DT?");
    }

    public String getFirmwareVersion() throws DriverException {
        return this.readString("FV?");
    }

    public String getHardwareVersion() throws DriverException {
        return this.readString("HV?");
    }

    public String getManufacturer() throws DriverException {
        return this.readString("MF?");
    }

    public String getModel() throws DriverException {
        return this.readString("MD?");
    }

    public String getPartNumber() throws DriverException {
        return this.readString("PN?");
    }

    public String getSerialNumber() throws DriverException {
        return this.readString("SN?");
    }

    public int getTimeOn() throws DriverException {
        return this.readInt("TIM?");
    }

    public int getSensorTimeOn() throws DriverException {
        this.checkLevel(1);
        return this.readInt("TIM2?");
    }

    public double getSensorDose() throws DriverException {
        this.checkLevel(1);
        return this.readDouble("TIM3?");
    }

    public char getStatus() throws DriverException {
        String status = this.readString("T?");
        if (status.length() != 1) {
            this.throwBadResponse("status", status);
        }
        return status.charAt(0);
    }

    public void setPressureUnit(Unit unit) throws DriverException {
        this.writeCmnd("U!" + unit.name());
    }

    public Unit getPressureUnit() throws DriverException {
        String resp = this.readString("U?");
        Unit unit = unitRespMap.get(resp);
        if (unit == null) {
            this.throwBadResponse("unit", resp);
        }
        return unit;
    }

    public double readPressure(Sensor sensor) throws DriverException {
        if (this.cmndLevel == 0 && sensor != Sensor.MP && sensor != Sensor.COMB4) {
            throw new DriverException("Invalid sendor (" + (Object)((Object)sensor) + ") for model " + this.model);
        }
        return this.readDouble("PR" + sensor.getValue() + "?");
    }

    public double readPressure() throws DriverException {
        return this.readPressure(this.cmndLevel == 0 ? Sensor.MP : Sensor.COMB);
    }

    public double readTemperature() throws DriverException {
        return this.readDouble("TEM?");
    }

    public void setLock(boolean on) throws DriverException {
        this.writeCmnd(on ? "FD!LOCK" : "FD!UNLOCK");
    }

    public void setBaudRate(int baud) throws DriverException {
        this.writeCmnd("BR!" + baud);
    }

    public int getBaudRate() throws DriverException {
        return this.readInt("BR?");
    }

    public void changeAddress(int addr) throws DriverException {
        if (addr < 1 || addr > 253) {
            throw new DriverException("Invalid device address: " + addr);
        }
        this.writeCmnd("AD!" + String.format("%03d", addr));
        this.setAddress(addr);
    }

    public void setUserTag(String tag) throws DriverException {
        this.writeCmnd("UT!" + tag);
    }

    public String getUserTag() throws DriverException {
        return this.readString("UT?");
    }

    public void setSwitchEnable(boolean on) throws DriverException {
        this.writeCmnd("SW!" + (on ? "ON" : "OFF"));
    }

    public boolean isSwitchEnabled() throws DriverException {
        String resp = this.readString("SW?");
        Boolean on = setRespMap.get(resp);
        if (on == null) {
            this.throwBadResponse("switch enabled", resp);
        }
        return on;
    }

    public void setDelayedResponse(boolean on) throws DriverException {
        this.writeCmnd("RSD!" + (on ? "ON" : "OFF"));
    }

    public boolean isResponseDelayed() throws DriverException {
        String resp = this.readString("RSD?");
        Boolean on = setRespMap.get(resp);
        if (on == null) {
            this.throwBadResponse("delayed response", resp);
        }
        return on;
    }

    public void setRelayDelayed(boolean on) throws DriverException {
        this.writeCmnd("SPD!" + (on ? "ON" : "OFF"));
    }

    public boolean isRelayDelayed() throws DriverException {
        String resp = this.readString("SPD?");
        Boolean on = setRespMap.get(resp);
        if (on == null) {
            this.throwBadResponse("relay trip delayed", resp);
        }
        return on;
    }

    public void setIdentify(boolean on) throws DriverException {
        this.writeCmnd("TST!" + (on ? "ON" : "OFF"));
    }

    public boolean isIdentifying() throws DriverException {
        String resp = this.readString("TST?");
        Boolean on = setRespMap.get(resp);
        if (on == null) {
            this.throwBadResponse("identify", resp);
        }
        return on;
    }

    public void setCalibrationGas(Gas gas) throws DriverException {
        this.writeCmnd("GT!" + (Object)((Object)gas));
    }

    public Gas getCalibrationGas() throws DriverException {
        String resp = this.readString("GT?");
        Gas gas = gasRespMap.get(resp);
        if (gas == null) {
            this.throwBadResponse("calibration gas", resp);
        }
        return gas;
    }

    public void calibrateAtmospheric(double press) throws DriverException {
        this.writeCmnd("ATM!" + press);
    }

    public double getAtmospheric() throws DriverException {
        return this.readDouble("ATM?");
    }

    public void calibrateVacuumMP() throws DriverException {
        this.writeCmnd("VAC!");
    }

    public void setAutoZeroLimit(double press) throws DriverException {
        this.checkLevel(1);
        this.writeCmnd("MZL!" + press);
    }

    public double getAutoZeroLimit() throws DriverException {
        this.checkLevel(1);
        return this.readDouble("MZL?");
    }

    public void calibrateFullScale(double press) throws DriverException {
        this.checkLevel(1);
        this.writeCmnd("CFS!" + press);
    }

    public double getFullScale() throws DriverException {
        this.checkLevel(1);
        return this.readDouble("CFS?");
    }

    public void calibrateVacuumCC() throws DriverException {
        this.checkLevel(1);
        this.writeCmnd("VAC3!");
    }

    public void setOnPressureCC(double press) throws DriverException {
        this.checkLevel(1);
        this.writeCmnd("SLC!" + press);
    }

    public double getOnPressureCC() throws DriverException {
        this.checkLevel(1);
        return this.readDouble("SLC?");
    }

    public void setOffPressureCC(double press) throws DriverException {
        this.checkLevel(1);
        this.writeCmnd("SHC!" + press);
    }

    public double getOffPressureCC() throws DriverException {
        this.checkLevel(1);
        return this.readDouble("SHC?");
    }

    public void setLowIntPressure(double press) throws DriverException {
        this.checkLevel(1);
        this.writeCmnd("SLP!" + press);
    }

    public double getLowIntPressure() throws DriverException {
        this.checkLevel(1);
        return this.readDouble("SLP?");
    }

    public void setHighIntPressure(double press) throws DriverException {
        this.checkLevel(1);
        this.writeCmnd("SHP!" + press);
    }

    public double getHighIntPressure() throws DriverException {
        this.checkLevel(1);
        return this.readDouble("SHP?");
    }

    public void setCCAutoPower(boolean on) throws DriverException {
        this.checkLevel(1);
        this.writeCmnd("ENC!" + (on ? "ON" : "OFF"));
    }

    public boolean isCCAutoPowerOn() throws DriverException {
        this.checkLevel(1);
        String resp = this.readString("ENC?");
        Boolean on = setRespMap.get(resp);
        if (on == null) {
            this.throwBadResponse("cold cathode auto power", resp);
        }
        return on;
    }

    public void setCCPower(boolean on) throws DriverException {
        this.checkLevel(1);
        this.writeCmnd("FP!" + (on ? "ON" : "OFF"));
    }

    public boolean isCCPowerOn() throws DriverException {
        this.checkLevel(1);
        String resp = this.readString("FP?");
        Boolean on = setRespMap.get(resp);
        if (on == null) {
            this.throwBadResponse("cold cathode power", resp);
        }
        return on;
    }

    public void setCCProtDelay(int delay) throws DriverException {
        this.checkLevel(1);
        this.writeCmnd("PRO!" + delay);
    }

    public void setCCProtection(boolean on) throws DriverException {
        this.checkLevel(1);
        this.writeCmnd("PRO!" + (on ? "ON" : "OFF"));
    }

    public int getCCProtDelay() throws DriverException {
        this.checkLevel(1);
        String resp = this.readString("PRO?");
        Integer delay = delayRespMap.get(resp);
        if (delay == null) {
            try {
                delay = Integer.valueOf(resp);
            }
            catch (NumberFormatException e) {
                this.throwBadResponse("cold cathode protection", resp);
            }
        }
        return delay;
    }

    public void setSensorDoseLimit(double dose) throws DriverException {
        this.checkLevel(1);
        this.writeCmnd("PD!" + dose);
    }

    public double getSensorDoseLimit() throws DriverException {
        this.checkLevel(1);
        return this.readDouble("PD?");
    }

    public void setRelayTrip(int relay, double value) throws DriverException {
        this.checkRelayNumber(relay);
        this.writeCmnd("SP" + relay + "!" + value);
    }

    public double getRelayTrip(int relay) throws DriverException {
        this.checkRelayNumber(relay);
        return this.readDouble("SP" + relay + "?");
    }

    public void setRelayHyst(int relay, double value) throws DriverException {
        this.checkRelayNumber(relay);
        this.writeCmnd("SH" + relay + "!" + value);
    }

    public double getRelayHyst(int relay) throws DriverException {
        this.checkRelayNumber(relay);
        return this.readDouble("SH" + relay + "?");
    }

    public void setRelayDirection(int relay, Direction dirn) throws DriverException {
        this.checkRelayNumber(relay);
        this.writeCmnd("SD" + relay + "!" + (Object)((Object)dirn));
    }

    public Direction getRelayDirection(int relay) throws DriverException {
        this.checkRelayNumber(relay);
        String resp = this.readString("SD" + relay + "?");
        Direction dirn = dirRespMap.get(resp);
        if (dirn == null) {
            this.throwBadResponse("relay direction", resp);
        }
        return dirn;
    }

    public void setRelayEnable(int relay, Enable enable) throws DriverException {
        this.checkRelayNumber(relay);
        this.writeCmnd("EN" + relay + "!" + (Object)((Object)enable));
    }

    public Enable getRelayEnable(int relay) throws DriverException {
        this.checkRelayNumber(relay);
        String resp = this.readString("EN" + relay + "?");
        Enable enab = enabRespMap.get(resp);
        if (enab == null) {
            this.throwBadResponse("relay enable", resp);
        }
        return enab;
    }

    public boolean isRelayActive(int relay) throws DriverException {
        this.checkRelayNumber(relay);
        String resp = this.readString("SS" + relay + "?");
        Boolean active = activeRespMap.get(resp);
        if (active == null) {
            this.throwBadResponse("relay active", resp);
        }
        return active;
    }

    public void setAnalogOut(int chan, Sensor sensor, int curve) throws DriverException {
        this.checkOutputChannel(chan);
        if (this.cmndLevel == 0 && sensor != Sensor.MP) {
            throw new DriverException("Invalid sensor (" + (Object)((Object)sensor) + ") for model " + this.model);
        }
        this.writeCmnd("AO" + chan + "!" + sensor.getValue() + curve);
    }

    public String getAnalogOut(int chan) throws DriverException {
        this.checkOutputChannel(chan);
        return this.readString("AO" + chan + "?");
    }

    public void setDefaults() throws DriverException {
        this.writeCmnd("FD!");
    }

    public void setDefaults(Default item) throws DriverException {
        if (this.cmndLevel == 0 && item != Default.ALL && item != Default.ATM && item != Default.VAC) {
            throw new DriverException("Invalid default item (" + (Object)((Object)item) + ") for model " + this.model);
        }
        this.writeCmnd("FD!" + (Object)((Object)item));
    }

    private void setAddress(int addr) {
        this.addrStr = String.format("%03d", addr);
        this.cmndPfx = "@" + this.addrStr;
    }

    void writeCmnd(String cmnd) throws DriverException {
        this.readString(cmnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readString(String cmnd) throws DriverException {
        int inPosn = 0;
        int respEnd = -1;
        int respStart = -1;
        Object object = this.cmndSync;
        synchronized (object) {
            this.writeBytes((this.cmndPfx + cmnd + CMND_SFX).getBytes());
            int termIx = 0;
            block31: while (respEnd < 0) {
                int endPosn = this.readBytes(this.readBuff, inPosn) + inPosn;
                if (respStart < 0) {
                    while (inPosn < endPosn) {
                        if (this.readBuff[inPosn] == 64) {
                            respStart = ++inPosn;
                            break;
                        }
                        ++inPosn;
                    }
                }
                if (respStart < 0) continue;
                while (inPosn < endPosn) {
                    if (this.readBuff[inPosn] == RESP_TERM[termIx]) {
                        if (++termIx == RESP_TERM.length) {
                            respEnd = inPosn + 1 - RESP_TERM.length;
                            continue block31;
                        }
                    } else {
                        termIx = 0;
                    }
                    ++inPosn;
                }
            }
        }
        String reply = new String(this.readBuff, respStart, respEnd - respStart);
        if (reply.length() < 6) {
            throw new DriverException("Reply (" + reply + ") is too short");
        }
        String rAddr = reply.substring(0, 3);
        if (!rAddr.equals(this.addrStr)) {
            throw new DriverException("Invalid reply address: " + rAddr);
        }
        String acknak = reply.substring(3, 6);
        String resp = reply.substring(6);
        switch (acknak) {
            case "ACK": {
                return resp;
            }
            case "NAK": {
                switch (resp) {
                    case "8": {
                        throw new DriverException("Zero adjustment at too high pressure");
                    }
                    case "9": {
                        throw new DriverException("Atmospheric adjustment at too low pressure");
                    }
                    case "160": {
                        throw new DriverException("Unrecognized command");
                    }
                    case "169": {
                        throw new DriverException("Invalid argument");
                    }
                    case "172": {
                        throw new DriverException("Value out of range");
                    }
                    case "175": {
                        throw new DriverException("Invalid command character");
                    }
                    case "180": {
                        throw new DriverException("Protected setting");
                    }
                    case "195": {
                        throw new DriverException("Control setpoint enabled");
                    }
                }
                throw new DriverException("Unrecognized error: " + resp);
            }
        }
        throw new DriverException("Unrecognized reply: " + reply);
    }

    private int readInt(String cmnd) throws DriverException {
        String resp = this.readString(cmnd);
        try {
            return Integer.valueOf(resp);
        }
        catch (NumberFormatException e) {
            throw new DriverException("Invalid integer value: " + resp);
        }
    }

    private double readDouble(String cmnd) throws DriverException {
        String resp = this.readString(cmnd);
        try {
            return Double.valueOf(resp);
        }
        catch (NumberFormatException e) {
            throw new DriverException("Invalid double value: " + resp);
        }
    }

    private void throwBadResponse(String cmnd, String resp) throws DriverException {
        throw new DriverException("Unrecognized " + cmnd + " response: " + resp);
    }

    private void checkLevel(int level) throws DriverException {
        if (this.cmndLevel < level) {
            throw new DriverException("Operation not available on a model " + this.model);
        }
    }

    private void checkRelayNumber(int relay) throws DriverException {
        if (relay < 1 || relay > 3) {
            throw new DriverException("Invalid relay number: " + relay);
        }
    }

    private void checkOutputChannel(int chan) throws DriverException {
        if (chan < 1 || chan > 2) {
            throw new DriverException("Invalid output channel number: " + chan);
        }
    }

    static {
        for (Unit unit : Unit.values()) {
            unitRespMap.put(unit.name(), unit);
        }
        dirRespMap = new HashMap<String, Direction>();
        for (Enum enum_ : Direction.values()) {
            dirRespMap.put(enum_.name(), (Direction)enum_);
        }
        enabRespMap = new HashMap<String, Enable>();
        for (Enum enum_ : Enable.values()) {
            enabRespMap.put(enum_.name(), (Enable)enum_);
        }
        gasRespMap = new HashMap<String, Gas>();
        for (Enum enum_ : Gas.values()) {
            gasRespMap.put(enum_.name(), (Gas)enum_);
        }
        setRespMap = new HashMap<String, Boolean>();
        setRespMap.put("ON", true);
        setRespMap.put("OFF", false);
        activeRespMap = new HashMap<String, Boolean>();
        activeRespMap.put("SET", true);
        activeRespMap.put("CLEAR", false);
        delayRespMap = new HashMap<String, Integer>();
        delayRespMap.put("ON", 120);
        delayRespMap.put("OFF", -1);
        levelMap = new HashMap<String, Integer>();
        levelMap.put("925", 0);
        levelMap.put("972", 1);
        levelMap.put("974", 2);
        RESP_TERM = new byte[]{59, 70, 70};
    }

    public static enum Default {
        ALL,
        VAC,
        VAC3,
        ATM,
        CFS,
        MZL;

    }

    public static enum Gas {
        NITROGEN,
        AIR,
        ARGON,
        HELIUM,
        HYDROGEN,
        H2O,
        NEON,
        CO2,
        XENON;

    }

    public static enum Enable {
        CC,
        PIR,
        CMB,
        ON,
        OFF;

    }

    public static enum Direction {
        ABOVE,
        BELOW;

    }

    public static enum Unit {
        TORR,
        MBAR,
        PASCAL;

    }

    public static enum Sensor {
        COMB(3),
        COMB4(4),
        MP(1),
        CC(5),
        PZ(2);

        private final int value;

        private Sensor(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }
}

