/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.mks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;

public class GP390 {
    public static final int UNIT_TORR = 0;
    public static final int UNIT_MBAR = 1;
    public static final int UNIT_PA = 2;
    public static final int DISP_ABS = 0;
    public static final int DISP_DIFF = 1;
    public static final int DISP_BOTH = 2;
    public static final int FMODE_MAN = 0;
    public static final int FMODE_ALT = 1;
    public static final int FMODE_AUTO = 2;
    public static final int GMODE_OFF = 0;
    public static final int GMODE_DEGAS = 1;
    public static final int GMODE_HIGH = 2;
    public static final int GMODE_LOW = 3;
    private static final Map<String, Integer> ruRespMap = new HashMap<String, Integer>();
    private static final Map<String, Boolean> tlRespMap;
    private static final Map<String, Integer> rfRespMap;
    private static final Map<String, Boolean> igRespMap;
    private static final Map<String, Boolean> igmRespMap;
    private static final Map<String, Boolean> iodRespMap;
    private static final Map<String, Boolean> dgRespMap;
    private static final Map<String, Integer> reRespMap;
    private static final Map<Integer, String> unitMap;
    private static final Map<Integer, String> dispMap;
    private static final Map<Integer, String> fmodeMap;
    private static final Map<String, OpenDesc> openMap;
    private OpenDesc desc;
    private String addr;
    private String cmndPfx;

    public void open(ConnType connType, String ident, int param, int address) throws DriverException {
        if (this.desc != null) {
            throw new DriverException("Connection already open");
        }
        this.desc = GP390.getOpen(connType, ident, param);
        this.addr = String.format("%02d", address);
        this.cmndPfx = "#" + this.addr;
    }

    public void close() throws DriverException {
        this.checkOpen();
        GP390.dropOpen(this.desc);
        this.desc = null;
    }

    public void setTimeout(double timeout) throws DriverException {
        this.checkOpen();
        this.desc.asc.setTimeout(timeout);
    }

    public void setPressureUnit(int unit) throws DriverException {
        this.checkOpen();
        String cmnd = unitMap.get(unit);
        if (cmnd == null) {
            throw new DriverException("Invalid pressure unit: " + unit);
        }
        this.write(cmnd);
    }

    public int getPressureUnit() throws DriverException {
        this.checkOpen();
        String resp = this.read("RU").trim();
        Integer unit = ruRespMap.get(resp);
        if (unit == null) {
            this.throwBadResponse(resp);
        }
        return unit;
    }

    public void setPressureDisp(int disp) throws DriverException {
        this.checkOpen();
        String cmnd = dispMap.get(disp);
        if (cmnd == null) {
            throw new DriverException("Invalid pressure display type: " + disp);
        }
        this.write(cmnd);
    }

    public double readPressure() throws DriverException {
        this.checkOpen();
        return this.readDouble("RD");
    }

    public double readDiffPressure() throws DriverException {
        this.checkOpen();
        return this.readDouble("RDD");
    }

    public boolean toggleLock() throws DriverException {
        this.checkOpen();
        String resp = this.read("TLU").trim();
        Boolean locked = tlRespMap.get(resp);
        if (locked == null) {
            this.throwBadResponse(resp);
        }
        return locked;
    }

    public void setLock(boolean on) throws DriverException {
        if (this.toggleLock() != on) {
            this.toggleLock();
        }
    }

    public void unlock() throws DriverException {
        this.checkOpen();
        this.write("UNL");
    }

    public void setAddressOffset(int offset) throws DriverException {
        this.checkOpen();
        this.write("SA" + offset + "0");
    }

    public void setBaudRate(int baud) throws DriverException {
        this.checkOpen();
        this.write("SB" + baud);
    }

    public void setFilamentMode(int mode) throws DriverException {
        this.checkOpen();
        String cmnd = fmodeMap.get(mode);
        if (cmnd == null) {
            throw new DriverException("Invalid filament mode: " + mode);
        }
        this.write(cmnd);
    }

    public int getFilamentStatus() throws DriverException {
        this.checkOpen();
        String resp = this.read("RF").trim();
        Integer status = rfRespMap.get(resp);
        if (status == null) {
            this.throwBadResponse(resp);
        }
        return status;
    }

    public void setMiGaugeOn(boolean on) throws DriverException {
        this.checkOpen();
        this.write("IG" + (on ? "1" : "0"));
    }

    public boolean isMiGaugeOn() throws DriverException {
        this.checkOpen();
        String resp = this.read("IGS").trim();
        Boolean on = igRespMap.get(resp);
        if (on == null) {
            this.throwBadResponse(resp);
        }
        return on;
    }

    public void setPressureIndOn(boolean on) throws DriverException {
        this.checkOpen();
        this.write("IGM" + (on ? "1" : "0"));
    }

    public boolean isPressureIndOn() throws DriverException {
        this.checkOpen();
        String resp = this.read("IGMS").trim();
        Boolean on = igmRespMap.get(resp);
        if (on == null) {
            this.throwBadResponse(resp);
        }
        return on;
    }

    public void setMiDelayOn(boolean on) throws DriverException {
        this.checkOpen();
        this.write("IOD" + (on ? "1" : "0"));
    }

    public boolean isMiDelayOn() throws DriverException {
        this.checkOpen();
        String resp = this.read("IOD").trim();
        Boolean on = iodRespMap.get(resp);
        if (on == null) {
            this.throwBadResponse(resp);
        }
        return on;
    }

    public void setMiDelayTime(int time) throws DriverException {
        this.checkOpen();
        this.write("IDT" + time);
    }

    public int getMiDelayTime() throws DriverException {
        this.checkOpen();
        Integer value = null;
        String resp = this.read("IDT");
        if (resp.substring(4).equals("  IDT")) {
            try {
                value = Integer.valueOf(resp.substring(0, 4).trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (value == null) {
            this.throwBadResponse(resp);
        }
        return value;
    }

    public void setMiDegasOn(boolean on) throws DriverException {
        this.checkOpen();
        this.write("DG" + (on ? "1" : "0"));
    }

    public boolean isMiDegasOn() throws DriverException {
        this.checkOpen();
        String resp = this.read("DGS").trim();
        Boolean on = dgRespMap.get(resp);
        if (on == null) {
            this.throwBadResponse(resp);
        }
        return on;
    }

    public void setMiDegasTime(int time) throws DriverException {
        this.checkOpen();
        this.write("DGT" + time);
    }

    public int getMiDegasTime() throws DriverException {
        this.checkOpen();
        Integer value = null;
        String resp = this.read("DGT");
        if (resp.substring(4).equals("  DGT")) {
            try {
                value = Integer.valueOf(resp.substring(0, 4).trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (value == null) {
            this.throwBadResponse(resp);
        }
        return value;
    }

    public void setMiSwitchPressure(double press) throws DriverException {
        this.checkOpen();
        this.write(String.format("SER %.2E", press));
    }

    public double getMiSwitchPressure() throws DriverException {
        this.checkOpen();
        return this.readDouble("SER");
    }

    public double getMiGaugeCurrent() throws DriverException {
        this.checkOpen();
        Double value = null;
        String resp = this.read("RE");
        if (resp.substring(4).equals("MA EM")) {
            try {
                value = Double.valueOf(resp.substring(0, 4).trim());
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (resp.equals(" 0 IG OFF")) {
            value = 0.0;
        }
        if (value == null) {
            this.throwBadResponse(resp);
        }
        return value;
    }

    public int getMiGaugeMode() throws DriverException {
        this.checkOpen();
        String resp = this.read("RE").trim();
        Integer value = reRespMap.get(resp);
        if (value == null) {
            this.throwBadResponse(resp);
        }
        return value;
    }

    public void calibrateAtmospheric() throws DriverException {
        this.checkOpen();
        this.write("TS");
    }

    public void calibrateVacuum() throws DriverException {
        this.checkOpen();
        this.write("TZ");
    }

    public void setAtmospheric(double press) throws DriverException {
        this.checkOpen();
        this.write("ATM " + (press < 0.0 ? "ACTUAL" : Double.valueOf(press)));
    }

    public double getAtmospheric() throws DriverException {
        this.checkOpen();
        String resp = this.read("ATMS").trim();
        Double value = null;
        if (resp.equals("ACTUAL")) {
            value = -1.0;
        } else {
            try {
                value = Double.valueOf(resp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (value == null) {
            this.throwBadResponse(resp);
        }
        return value;
    }

    public String[] getStatusStrings() throws DriverException {
        this.checkOpen();
        ArrayList<String> list = new ArrayList<String>();
        String first = null;
        while (true) {
            String resp;
            String code;
            if ((code = (resp = this.read("RS").trim()).substring(0, 2)).equals("08")) {
                continue;
            }
            if (first == null) {
                first = resp;
            } else if (resp.equals(first)) break;
            if (code.equals("00")) continue;
            list.add(resp);
        }
        return list.toArray(new String[list.size()]);
    }

    public int getStatusWord() throws DriverException {
        this.checkOpen();
        String resp = this.read("RSX").trim();
        Integer value = null;
        try {
            value = Integer.parseInt(resp, 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (value == null) {
            this.throwBadResponse(resp);
        }
        return value;
    }

    public String getFwVersion() throws DriverException {
        this.checkOpen();
        return this.read("VER").trim();
    }

    public void reset() throws DriverException {
        this.checkOpen();
        this.desc.asc.write("RST");
    }

    public void setCommDefaults() throws DriverException {
        this.checkOpen();
        this.desc.asc.write("yuiop");
    }

    public void setDefaults() throws DriverException {
        this.checkOpen();
        this.write("FAC");
    }

    private void write(String cmnd) throws DriverException {
        String resp = this.read(cmnd);
        if (!resp.equals(" PROGM OK")) {
            this.throwBadResponse(resp);
        }
    }

    private String read(String cmnd) throws DriverException {
        String reply = this.desc.asc.read(this.cmndPfx + cmnd);
        String rStart = reply.substring(0, 1);
        if (!rStart.equals("*") && !rStart.equals("?")) {
            throw new DriverException("Invalid reply start: " + rStart);
        }
        String rAddr = reply.substring(1, 3);
        if (!rAddr.equals(this.addr)) {
            throw new DriverException("Invalid reply address: " + rAddr);
        }
        String resp = reply.substring(3);
        if (rStart.equals("*")) {
            return resp;
        }
        switch (resp.trim()) {
            case "RANGE ER": {
                throw new DriverException("Range error");
            }
            case "SYNTX ER": {
                throw new DriverException("Syntax error");
            }
            case "LOCKED": {
                throw new DriverException("Function locked");
            }
            case "INVALID": {
                throw new DriverException("Invalid command");
            }
        }
        throw new DriverException("Unrecognized error: " + resp);
    }

    private double readDouble(String cmnd) throws DriverException {
        String resp = this.read(cmnd);
        try {
            return Double.valueOf(resp.trim());
        }
        catch (NumberFormatException e) {
            throw new DriverException("Invalid double value: " + resp);
        }
    }

    void throwBadResponse(String resp) throws DriverException {
        throw new DriverException("Unrecognized response: " + resp);
    }

    private static synchronized OpenDesc getOpen(ConnType connType, String ident, int param) throws DriverException {
        String key = (Object)((Object)connType) + ":" + ident;
        OpenDesc desc = openMap.get(key);
        if (desc == null) {
            desc = new OpenDesc();
            desc.asc = new Ascii(Ascii.Option.NO_NET);
            openMap.put(key, desc);
        }
        if (desc.refCount <= 0) {
            Ascii.ConnType cType = connType == ConnType.FTDI ? Ascii.ConnType.FTDI : Ascii.ConnType.SERIAL;
            desc.asc.open(cType, ident, param);
            desc.asc.setTerminator("\r");
        }
        ++desc.refCount;
        return desc;
    }

    private static synchronized void dropOpen(OpenDesc desc) throws DriverException {
        if (--desc.refCount <= 0) {
            desc.asc.close();
        }
    }

    private void checkOpen() throws DriverException {
        if (this.desc == null) {
            throw new DriverException("Connection not open");
        }
    }

    static {
        ruRespMap.put("TORR", 0);
        ruRespMap.put("MBAR", 1);
        ruRespMap.put("PASCAL", 2);
        tlRespMap = new HashMap<String, Boolean>();
        tlRespMap.put("0 UL OFF", false);
        tlRespMap.put("1 UL  ON", true);
        rfRespMap = new HashMap<String, Integer>();
        rfRespMap.put("FIL  SF1", 1);
        rfRespMap.put("FIL  SF2", 2);
        rfRespMap.put("FIL  SFB", 3);
        igRespMap = new HashMap<String, Boolean>();
        igRespMap.put("0 IG OFF", false);
        igRespMap.put("1 IG  ON", true);
        igmRespMap = new HashMap<String, Boolean>();
        igmRespMap.put("0    ALL", false);
        igmRespMap.put("1     IG", true);
        iodRespMap = new HashMap<String, Boolean>();
        iodRespMap.put("0   OFF", false);
        iodRespMap.put("1   ON", true);
        dgRespMap = new HashMap<String, Boolean>();
        dgRespMap.put("0 DG OFF", false);
        dgRespMap.put("1 DG  ON", true);
        reRespMap = new HashMap<String, Integer>();
        reRespMap.put("0 IG OFF", 0);
        reRespMap.put("15MA EM", 1);
        reRespMap.put("4.0MA EM", 2);
        reRespMap.put(".02MA EM", 3);
        unitMap = new HashMap<Integer, String>();
        unitMap.put(0, "SUT");
        unitMap.put(1, "SUM");
        unitMap.put(2, "SUP");
        dispMap = new HashMap<Integer, String>();
        dispMap.put(0, "SDA");
        dispMap.put(1, "SDD");
        dispMap.put(2, "SDB");
        fmodeMap = new HashMap<Integer, String>();
        fmodeMap.put(0, "SFMAN");
        fmodeMap.put(1, "SFALT");
        fmodeMap.put(2, "SFAUTO");
        openMap = new HashMap<String, OpenDesc>();
    }

    public static enum ConnType {
        FTDI,
        SERIAL;

    }

    static class OpenDesc {
        Ascii asc;
        int refCount = 0;

        OpenDesc() {
        }
    }
}

