package org.lsst.ccs.drivers.microion;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

/**
 *************************************************************************** 
 ** 
 ** Program to test the MicroIon device driver
 ** 
 ** @author Homer
 ** 
 *************************************************************************** 
 */
public class MicroIonTest extends MicroIon {

    private MicroIon mydev;       

    @Command(name = "open", description = "Open a device for use")
	public void open(
            @Argument(name = "devId", description = "The device ID of the device to open") String MyDevId,
            @Argument(name = "baud", description = "baud rate") Integer baud,
            @Argument(name = "addr", description = "SA - address offset") Integer addr
                ) throws DriverException {
		
    	    mydev = new MicroIon();
	    mydev.open(MyDevId,baud,addr);
    }

        /*
    @Command(name = "close", description = "Close the device")
	public void close() throws Exception {
    	mydev.close();
	}
*/

        @Command(name = "readpressure", description = "Read pressure ")
	public double readpressure(
                ) throws Exception {
    	return mydev.getPressure();
	}

    @Command(name = "getstate", description = "Get state of the vacuum gauge")
	public onOff getstate(
                ) throws Exception {
    	return mydev.getState();
	}

}