/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ascii;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.lsst.ccs.drivers.ascii.AsciiIO;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class AsciiIONet
implements AsciiIO {
    private Socket sock;
    private InputStream in;
    private OutputStream out;

    @Override
    public void open(String host, int port, int dummy) throws DriverException {
        try {
            this.sock = new Socket(host, port);
            this.in = this.sock.getInputStream();
            this.out = this.sock.getOutputStream();
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    @Override
    public void close() throws DriverException {
        try {
            this.sock.close();
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    @Override
    public void write(byte[] command) throws DriverException {
        try {
            this.out.write(command);
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    @Override
    public int read(byte[] buff, int offset) throws DriverException {
        try {
            int leng = 0;
            int count = this.in.available();
            if (count == 0) {
                leng = this.in.read(buff, offset, 1);
                if (leng <= 0) {
                    throw new DriverException("Connection closed");
                }
                ++offset;
                count = this.in.available();
            }
            if (offset + count > buff.length) {
                count = buff.length - offset;
            }
            if (count > 0) {
                leng += this.in.read(buff, offset, count);
            }
            return leng;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new DriverTimeoutException("Read timed out");
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    @Override
    public void flush() throws DriverException {
        try {
            int count = this.in.available();
            if (count > 0) {
                byte[] buff = new byte[count];
                this.in.read(buff, 0, count);
            }
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    @Override
    public void setTimeout(int timeout) throws DriverException {
        try {
            this.sock.setSoTimeout(timeout);
        }
        catch (SocketException e) {
            throw new DriverException((Throwable)e);
        }
    }
}

