package org.lsst.ccs.drivers.microion;

import java.util.Random;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
//import org.lsst.ccs.drivers.serial.SerialPort;
import org.lsst.ccs.drivers.ascii.Ascii;

/**
 **************************************************************************
 **
 ** General access routines for the MicroIon device * * @author Homer Neal *
 * **************************************************************************
 */
public class MicroIon extends Ascii {

    /**
     **************************************************************************
     **
     ** Public constants *
     * **************************************************************************
     */

    public enum onOff {

        OFF, ON;
    }

    /**
     **************************************************************************
     **
     ** Private constants *
     * **************************************************************************
     */
    private final static byte CR = 0x0d, LF = 0x0a;
    private String terminator = "\n";
    private int timeout = 1000;
//    private byte[] buff = new byte[1024];
//    private int buffIn, buffOut;

//    private SerialPort port = new SerialPort();
    private String saddr = "2";
    
    /**
     **************************************************************************
     **
     ** Constructor * *
     * **************************************************************************
     */
    public MicroIon() {
    }


    /**
     **************************************************************************
     **
     ** Opens a connection. * * @param device The device name of the serial
     * port
     * @param serialname
     * @param port
     * @param addr
     * @throws DriverException *
     * **************************************************************************
     */
    public void open(String serialname, int port, int addr) throws DriverException
    {
        open(Ascii.CONN_TYPE_SERIAL, serialname, port);
        Integer iaddr = addr;
        saddr = iaddr.toString();
        init();
//        setTimeout(timeout); // set SCPI timeout    
    }

      /**
    ***************************************************************************
    **
    **  Opens an FTDI connection.
    **
    ***************************************************************************
     * @param serialname
     * @param port
     * @param addr
     * @throws org.lsst.ccs.drivers.commons.DriverException
    */
    public void openftdi(String serialname, int port, int addr) throws DriverException
    {
        System.out.println("opening connection to the MicroIon Vacuum Gauge");
        open(Ascii.CONN_TYPE_FTDI, serialname, port);
        Integer iaddr = addr;
        saddr = iaddr.toString();
        init();
//        setTimeout(timeout); // set SCPI timeout
    }
    
    public void init() throws DriverException
    {
//        System.out.println("MicroIon Device response to baud setting is:"+readMicroIon("#0"+saddr+"SB19200")); // set device baud to 19200
        System.out.println("MicroIon Device response to 8,1,N setting is:"+readMicroIon("#0"+saddr+"SPN")); // set 8 bits, no parity
        System.out.println("MicroIon Device response to address setting is:"+readMicroIon("#0"+saddr+"SA00")); // set address offset (SA)                
    }
    


    /**
     ***************************************************************************
     **
     ** Gets the MicroIon power state. *
     * @return 
     * @throws org.lsst.ccs.drivers.commons.DriverException
     * **************************************************************************
     */
    public onOff getState() throws DriverException {
        String srm = readMicroIon("#0"+saddr+"IGS");
//        System.out.println("response = "+srm);
        String[] response = srm.split(" ");
        return response[3]=="ON" ? onOff.ON : onOff.OFF;
    }

    
    /**
     ***************************************************************************
     **
     ** Sets the MicroIon on or off
     * @return 
     * @throws org.lsst.ccs.drivers.commons.DriverException
     * **************************************************************************
     */
    public void setState(int state) throws DriverException {
        writeMicroIon("#0"+saddr+"IG"+state);
    }

    /**
     ***************************************************************************
     **
     ** Gets the MicroIon pressure reading *
     * **************************************************************************
     */
    public double getPressure() throws DriverException {
        String srm = readMicroIon("#0"+saddr+"RD");
//        System.out.println("response = "+srm);
        String[] response = srm.split(" ");
//        System.out.println("number string = "+response[1]);
        return Double.valueOf(response[1]);
    }


    /**
     **************************************************************************
     **
     ** Sets the receive timeout. * * @param timeout The receive timeout (ms).
     * 0 means no timeout. * * @throws DriverException *
     * *************************************************************************
     */
    public void setTimeout(int timeout) throws DriverException {
        this.timeout = timeout;
    }

    /**
     **************************************************************************
     **
     ** Writes a command. * * @param command The command to write, excluding
     * terminator * * @throws DriverException *
     * *************************************************************************
     */
    public synchronized void writeMicroIon(String command) throws DriverException {
//        checkOpen();
        write(command + terminator);
    }

    /**
     **************************************************************************
     **
     ** Reads a response. * * @return The command response string * * @throws
     * DriverException
     ** @throws DriverTimeoutException *
     * *************************************************************************
     */
    public synchronized String readMicroIon() throws DriverException {
//        checkOpen();
        return(read());
    }

    /**
     **************************************************************************
     **
     ** Reads a response after writing a command. * * @param command The
     * command to write, excluding terminator * * @return The command response
     * string * * @throws DriverException
     ** @throws DriverTimeoutException *
     * *************************************************************************
     */
    public synchronized String readMicroIon(String command) throws DriverException {
//        flush();

        writeMicroIon(command);
        return readMicroIon();
    }

}
