/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.microion;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.Scpi;

public class MicroIon
extends Scpi {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private String terminator = "\n";
    private int timeout = 1000;
    private String saddr = "2";

    public void open(String serialname, int port, int addr) throws DriverException {
        this.open(2, serialname, port);
        Integer iaddr = addr;
        this.saddr = iaddr.toString();
        this.init();
    }

    public void openftdi(String serialname, int port, int addr) throws DriverException {
        System.out.println("opening connection to the MicroIon Vacuum Gauge");
        this.open(1, serialname, port);
        Integer iaddr = addr;
        this.saddr = iaddr.toString();
        this.init();
    }

    public void init() throws DriverException {
        System.out.println("Device response to baud setting is:" + this.readMicroIon("#0" + this.saddr + "SB19200"));
        System.out.println("Device response to 8,1,N setting is:" + this.readMicroIon("#0" + this.saddr + "SPN"));
        System.out.println("Device response to address setting is:" + this.readMicroIon("#0" + this.saddr + "SA0"));
    }

    public String printdevid() throws DriverException {
        String[] id = this.getIdentification();
        return "Successfully connected to:\nManufacturer:   " + id[0] + "\nModel name:     " + id[1] + "\nSerial number:  " + id[2] + "\nF/W version:    " + id[3];
    }

    public onOff getState() throws DriverException {
        String srm = this.readMicroIon("#0" + this.saddr + "IGS");
        System.out.println("response = " + srm);
        String[] response = srm.split(" ");
        return response[3] == "ON" ? onOff.ON : onOff.OFF;
    }

    public double getPressure() throws DriverException {
        String srm = this.readMicroIon("#0" + this.saddr + "RD");
        System.out.println("response = " + srm);
        String[] response = srm.split(" ");
        return Double.valueOf(response[1]);
    }

    public void setTimeout(int timeout) throws DriverException {
        this.timeout = timeout;
    }

    public synchronized void writeMicroIon(String command) throws DriverException {
        this.write(String.valueOf(command) + this.terminator);
    }

    public synchronized String readMicroIon() throws DriverException {
        return this.read();
    }

    public synchronized String readMicroIon(String command) throws DriverException {
        this.writeMicroIon(command);
        return this.readMicroIon();
    }

    public static enum onOff {
        OFF,
        ON;

    }
}

