package org.lsst.ccs.drivers.mcc;

import org.lsst.ccs.drivers.commons.DriverException;

/**
 *  Access a Measurement Computing USB-TC-AI device
 */
public class MccTc extends MccUsb {

    /**
     *  Opens device connection
     *
     *  @param  serial  The serial number of the device, or null if the first
     *                  found device of this type is to be used.
     *  @param  force   If true, claiming the device is forced, allowing it
     *                  to be opened even if another driver has claimed it.
     *  @throws  DriverException if device is already open or the device
     *                           cannot be found.
     */
    public void open(String serial, boolean force) throws DriverException
    {
        open(USB_TC_DID, serial, force);
    }

}
