/*
 * Decompiled with CFR 0.152.
 */
package javax.usb.examples;

import java.util.ArrayList;
import java.util.List;
import javax.usb.UsbDevice;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.examples.ShowTopology;
import javax.usb.util.UsbUtil;

public class FindUsbInterface {
    private static byte staticInterfaceClass = (byte)9;
    private static final String INTERFACE_CLASS_KEY = "bInterfaceClass";
    private static final String KEYS = "\tbInterfaceClass";
    private static final String USAGE = "Usage : java FindUsbInterface <key=value>\n\n\tvalid keys are:\n\tbInterfaceClass";

    public static void main(String[] argv) {
        FindUsbInterface.parseArgv(argv);
        UsbHub virtualRootUsbHub = ShowTopology.getVirtualRootUsbHub();
        List usbInterfaces = null;
        usbInterfaces = FindUsbInterface.getUsbInterfacesWithInterfaceClass(virtualRootUsbHub, FindUsbInterface.getInterfaceClass());
        System.out.print("Found " + usbInterfaces.size() + " interfaces with");
        System.out.print(" interface class 0x" + UsbUtil.toHexString(FindUsbInterface.getInterfaceClass()));
        System.out.println("");
    }

    public static List getUsbInterfacesWithInterfaceClass(UsbDevice usbDevice, byte interfaceClass) {
        int i;
        ArrayList<UsbInterface> list = new ArrayList<UsbInterface>();
        if (usbDevice.isConfigured()) {
            List ifaces = usbDevice.getActiveUsbConfiguration().getUsbInterfaces();
            i = 0;
            while (i < ifaces.size()) {
                UsbInterface usbInterface = (UsbInterface)ifaces.get(i);
                if (interfaceClass == usbInterface.getUsbInterfaceDescriptor().bInterfaceClass()) {
                    list.add(usbInterface);
                }
                ++i;
            }
        }
        if (usbDevice.isUsbHub()) {
            List devices = ((UsbHub)usbDevice).getAttachedUsbDevices();
            i = 0;
            while (i < devices.size()) {
                list.addAll(FindUsbInterface.getUsbInterfacesWithInterfaceClass((UsbDevice)devices.get(i), interfaceClass));
                ++i;
            }
        }
        return list;
    }

    public static byte getInterfaceClass() {
        return staticInterfaceClass;
    }

    public static void parseArgv(String[] argv) {
        int i = 0;
        while (i < argv.length) {
            int equalsIndex = argv[i].indexOf(61);
            try {
                String key = argv[i].substring(0, equalsIndex);
                String value = argv[i].substring(equalsIndex + 1);
                if (key.equals(INTERFACE_CLASS_KEY)) {
                    staticInterfaceClass = (byte)Integer.decode(value).intValue();
                } else {
                    System.err.println("Unrecognized key \"" + key + "\"\n" + USAGE);
                    System.exit(1);
                }
            }
            catch (Exception exception) {
                System.err.println("Invalid key-value pair \"" + argv[i] + "\"\n" + USAGE);
                System.exit(1);
            }
            ++i;
        }
    }
}

