/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.mcc;

import javax.usb.UsbException;
import jline.console.ConsoleReader;
import org.lsst.ccs.drivers.mcc.MccUsb;
import org.lsst.ccs.utilities.sa.CmndProcess;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestMccUsb
implements CmndProcess.Dispatch {
    private static final int CMD_OPEN = 0;
    private static final int CMD_CLOSE = 1;
    private static final int CMD_DIOCFG = 2;
    private static final int CMD_DIOCFGBIT = 3;
    private static final int CMD_DIOIN = 4;
    private static final int CMD_DIOINBIT = 5;
    private static final int CMD_DIOOUT = 6;
    private static final int CMD_DIOOUTBIT = 7;
    private static final int CMD_ADIN = 8;
    private static final int CMD_ADSCAN = 9;
    private static final int CMD_CNTRINIT = 10;
    private static final int CMD_CNTRREAD = 11;
    private static final int CMD_BLINK = 12;
    private static final int CMD_RESET = 13;
    private static final int CMD_STATUS = 14;
    private static final int CMD_ITEMSET = 15;
    private static final int CMD_ITEMGET = 16;
    private static final int CMD_ALARMSET = 17;
    private static final int CMD_ALARMGET = 18;
    private static final int CMD_SHOWCHAN = 19;
    private static final int CMD_SHOWBURN = 20;
    private static final int CMD_SHOWCAL = 21;
    private static final int CMD_CALCFG = 22;
    private static final int CMD_CALIBRATE = 23;
    private static final int CMD_SHOWDEV = 24;
    private static final int NUM_CMDS = 25;
    private static final String[] helpOpen = new String[]{"Open device connection", "open [<device>] [<force>] [<serial>]", "device  The name of the MCC device to connect to", "force   If present and non-zero, force the interface claim", "serial  The serial number of the MCC device (default any)"};
    private static final String[] helpClose = new String[]{"Close device connection", "close"};
    private static final String[] helpDiocfg = new String[]{"Configure the DIO port", "diocfg <value>", "value  The mask of lines to set as input"};
    private static final String[] helpDiocfgbit = new String[]{"Configure a DIO line", "diocfgbit <line> <value>", "line   The line to configure", "value  The value to set (0 = out, 1 = in)"};
    private static final String[] helpDioin = new String[]{"Read the DIO port and display the value", "dioin"};
    private static final String[] helpDioinbit = new String[]{"Read a DIO line and display its value", "dioinbit <line>", "line  The line to read"};
    private static final String[] helpDioout = new String[]{"Write to the DIO port", "dioout <value>", "value  The value to write"};
    private static final String[] helpDiooutbit = new String[]{"Write to a DIO line", "diooutbit <line> <value>", "line   The line to write to", "value  The value to write"};
    private static final String[] helpAdin = new String[]{"Read an ADC channel and display its value", "adin <chan> <units>", "chan   The ADC channel to read", "units  The units to use (0 = temperature, 1 = voltage"};
    private static final String[] helpAdscan = new String[]{"Scan ADC channels and display their values", "adscan <first> <last> <units>", "first  The first ADC channel to read", "last   The last ADC channel to read", "units  The units to use (0 = temperature, 1 = voltage"};
    private static final String[] helpCntrinit = new String[]{"Initialize the counter", "cntrinit"};
    private static final String[] helpCntrread = new String[]{"Read and display the counter value", "cntrread"};
    private static final String[] helpBlink = new String[]{"Blink the LED", "blink"};
    private static final String[] helpReset = new String[]{"Reset the device", "reset"};
    private static final String[] helpStatus = new String[]{"Read and display the status byte", "status"};
    private static final String[] helpItemset = new String[]{"Set a configuration item", "itemset <item> <subitem> <value>", "item     The name or number of the item to be configured", "subitem  The name or number of the subitem", "value    The value to set"};
    private static final String[] helpItemget = new String[]{"Get and display a configuration item", "itemget <item> <subitem>", "item     The name or number of the configured item", "subitem  The name or number of the subitem"};
    private static final String[] helpAlarmset = new String[]{"Set the configuration for an alarm", "alarmset <alarm> <ioptns> <ooptns> <value1> <value2>", "alarm   The alarm number", "ioptns  The input options", "ooptns  The output options", "value1  The first alarm value", "value2  The second alarm value"};
    private static final String[] helpAlarmget = new String[]{"Get and display an alarm configuration", "alarmget <alarm>", "alarm  The alarm number"};
    private static final String[] helpShowchan = new String[]{"Get and display channel configuration", "showchan [<chan>] [<all>]", "chan  The channel number (0 - 7), or * for all channels", "all   If present and non-zero, display all configuration data"};
    private static final String[] helpShowdev = new String[]{"Display open device name", "showdev"};
    private static final String[] helpShowburn = new String[]{"Get, display and reset the burnout status", "showburn <mask>", "mask  The mask of channels to not reset (default 0x0f)"};
    private static final String[] helpShowcal = new String[]{"Get and display the number of calibration steps", "showcal"};
    private static final String[] helpCalcfg = new String[]{"Configure a calibration", "calcfg <gain> <polar> <path>", "gain   The gain selector", "polar  The polarity:  0 = positive, 1 = negative", "path   The path to use:  0 = channel high, 1 = channel low"};
    private static final String[] helpCalibrate = new String[]{"Perform a calibration", "calibrate <type>", "type  The type of calibration:  0 = temp, 1 = voltage, 2 = abort"};
    private static final CmndProcess.Lookup devNames = new CmndProcess.Lookup(3);
    private static final CmndProcess.Lookup itemNames;
    private static final CmndProcess.Lookup subiNames;
    private static final CmndProcess.Lookup stypNames;
    private static final CmndProcess.Lookup stypsNames;
    private static final CmndProcess.Lookup frateNames;
    private static final CmndProcess.Lookup tctypNames;
    private static final CmndProcess.Lookup gainNames;
    private static final CmndProcess.Lookup rangeNames;
    private static final CmndProcess.Lookup vconnNames;
    private static final CmndProcess.Lookup vconsNames;
    private static final CmndProcess.Lookup excitNames;
    private static final CmndProcess.Lookup tconnNames;
    private static final CmndProcess.Lookup tconsNames;
    private static final CmndProcess.Command cmnd;
    private final Output out = new ConsOut();
    private final CmndProcess proc = new CmndProcess();
    private MccUsb mcc;
    private static final String[] caption;
    private static final boolean[] isValue;
    private static final boolean[] isExtra;
    private static final int[] loSubitem;
    private static final int[] hiSubitem;

    static {
        devNames.add("tc-ai", 0);
        devNames.add("tc", 1);
        devNames.add("temp", 2);
        itemNames = new CmndProcess.Lookup(4);
        itemNames.add("adc0", 0);
        itemNames.add("adc1", 1);
        itemNames.add("adc2", 2);
        itemNames.add("adc3", 3);
        subiNames = new CmndProcess.Lookup(25);
        subiNames.add("senstype", 0);
        subiNames.add("conntype", 1);
        subiNames.add("filtrate", 2);
        subiNames.add("excitation", 3);
        subiNames.add("vref", 4);
        subiNames.add("ival0", 5);
        subiNames.add("ival1", 6);
        subiNames.add("ival2", 7);
        subiNames.add("vval0", 8);
        subiNames.add("vval1", 9);
        subiNames.add("vval2", 10);
        subiNames.add("tc0", 16);
        subiNames.add("tc1", 17);
        subiNames.add("gain0", 18);
        subiNames.add("gain1", 19);
        subiNames.add("coef00", 20);
        subiNames.add("coef01", 21);
        subiNames.add("coef10", 22);
        subiNames.add("coef11", 23);
        subiNames.add("coef20", 24);
        subiNames.add("coef21", 25);
        subiNames.add("coef30", 26);
        subiNames.add("coef31", 27);
        subiNames.add("vconn0", 28);
        subiNames.add("vconn1", 29);
        stypNames = new CmndProcess.Lookup(6);
        stypNames.add("rtd", 0);
        stypNames.add("thermistor", 1);
        stypNames.add("thermocouple", 2);
        stypNames.add("semiconductor", 3);
        stypNames.add("disabled", 4);
        stypNames.add("voltage", 5);
        stypsNames = new CmndProcess.Lookup(6);
        stypsNames.add("rtd", 0);
        stypsNames.add("thermis", 1);
        stypsNames.add("thermoc", 2);
        stypsNames.add("semicon", 3);
        stypsNames.add("disabld", 4);
        stypsNames.add("voltage", 5);
        frateNames = new CmndProcess.Lookup(14);
        frateNames.add("500 Hz", 1);
        frateNames.add("250 Hz", 2);
        frateNames.add("125 Hz", 3);
        frateNames.add("62.5 Hz", 4);
        frateNames.add("50 Hz", 5);
        frateNames.add("39.2 Hz", 6);
        frateNames.add("33.3 Hz", 7);
        frateNames.add("19.6 Hz", 8);
        frateNames.add("16.7 Hz", 9);
        frateNames.add("12.5 Hz", 11);
        frateNames.add("10 Hz", 12);
        frateNames.add("8.33 Hz", 13);
        frateNames.add("6.25 Hz", 14);
        frateNames.add("4.17 Hz", 15);
        tctypNames = new CmndProcess.Lookup(8);
        tctypNames.add("J", 0);
        tctypNames.add("K", 1);
        tctypNames.add("T", 2);
        tctypNames.add("E", 3);
        tctypNames.add("R", 4);
        tctypNames.add("S", 5);
        tctypNames.add("B", 6);
        tctypNames.add("N", 7);
        gainNames = new CmndProcess.Lookup(8);
        gainNames.add("1X", 0);
        gainNames.add("2X", 1);
        gainNames.add("4X", 2);
        gainNames.add("8X", 3);
        gainNames.add("16X", 4);
        gainNames.add("32X", 5);
        gainNames.add("64X", 6);
        gainNames.add("128X", 7);
        rangeNames = new CmndProcess.Lookup(4);
        rangeNames.add("10V", 2);
        rangeNames.add("5V", 3);
        rangeNames.add("2.5V", 4);
        rangeNames.add("1.25V", 5);
        vconnNames = new CmndProcess.Lookup(4);
        vconnNames.add("differential", 0);
        vconnNames.add("single-ended", 1);
        vconnNames.add("grounded", 2);
        vconnNames.add("calibration", 3);
        vconsNames = new CmndProcess.Lookup(4);
        vconsNames.add("differ", 0);
        vconsNames.add("snglend", 1);
        vconsNames.add("ground", 2);
        vconsNames.add("calib", 3);
        excitNames = new CmndProcess.Lookup(3);
        excitNames.add("off", 0);
        excitNames.add("10 uA", 1);
        excitNames.add("210 uA", 2);
        tconnNames = new CmndProcess.Lookup(4);
        tconnNames.add("2-wire, 1-sensor", 0);
        tconnNames.add("2-wire, 2-sensor", 1);
        tconnNames.add("3-wire", 2);
        tconnNames.add("4-wire", 3);
        tconsNames = new CmndProcess.Lookup(4);
        tconsNames.add("2-wire1", 0);
        tconsNames.add("2-wire2", 1);
        tconsNames.add("3-wire", 2);
        tconsNames.add("4-wire", 3);
        cmnd = new CmndProcess.Command(25);
        cmnd.add("open", 0, helpOpen, "kis", new CmndProcess.Lookup[]{devNames});
        cmnd.add("close", 1, helpClose, "", new CmndProcess.Lookup[0]);
        cmnd.add("diocfg", 2, helpDiocfg, "I", new CmndProcess.Lookup[0]);
        cmnd.add("diocfgbit", 3, helpDiocfgbit, "II", new CmndProcess.Lookup[0]);
        cmnd.add("dioin", 4, helpDioin, "", new CmndProcess.Lookup[0]);
        cmnd.add("dioinbit", 5, helpDioinbit, "I", new CmndProcess.Lookup[0]);
        cmnd.add("dioout", 6, helpDioout, "I", new CmndProcess.Lookup[0]);
        cmnd.add("diooutbit", 7, helpDiooutbit, "II", new CmndProcess.Lookup[0]);
        cmnd.add("adin", 8, helpAdin, "Ii", new CmndProcess.Lookup[0]);
        cmnd.add("adscan", 9, helpAdscan, "IIi", new CmndProcess.Lookup[0]);
        cmnd.add("cntrinit", 10, helpCntrinit, "", new CmndProcess.Lookup[0]);
        cmnd.add("cntrread", 11, helpCntrread, "", new CmndProcess.Lookup[0]);
        cmnd.add("blink", 12, helpBlink, "", new CmndProcess.Lookup[0]);
        cmnd.add("reset", 13, helpReset, "", new CmndProcess.Lookup[0]);
        cmnd.add("itemset", 15, helpItemset, "jjs", new CmndProcess.Lookup[]{itemNames, subiNames});
        cmnd.add("itemget", 16, helpItemget, "jj", new CmndProcess.Lookup[]{itemNames, subiNames});
        cmnd.add("status", 14, helpStatus, "", new CmndProcess.Lookup[0]);
        cmnd.add("alarmset", 17, helpAlarmset, "IIIFF", new CmndProcess.Lookup[0]);
        cmnd.add("alarmget", 18, helpAlarmget, "I", new CmndProcess.Lookup[0]);
        cmnd.add("showdev", 24, helpShowdev, "", new CmndProcess.Lookup[0]);
        cmnd.add("showchan", 19, helpShowchan, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("showburn", 20, helpShowburn, "i", new CmndProcess.Lookup[0]);
        cmnd.add("showcal", 21, helpShowcal, "", new CmndProcess.Lookup[0]);
        cmnd.add("calcfg", 22, helpCalcfg, "III", new CmndProcess.Lookup[0]);
        cmnd.add("calibrate", 23, helpCalibrate, "I", new CmndProcess.Lookup[0]);
        caption = new String[]{"Sensor type", "Therm conn", "Excitation", "Filter rate", "TC type", "Gain", "Voltage conn", "Refc voltage", "I value 0", "I value 1", "I value 2", "V value 0", "V value 1", "V value 2", "Coeff 0", "Coeff 1", "Coeff 2", "Coeff 3"};
        boolean[] blArray = new boolean[18];
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        blArray[12] = true;
        blArray[13] = true;
        blArray[14] = true;
        blArray[15] = true;
        blArray[16] = true;
        blArray[17] = true;
        isValue = blArray;
        boolean[] blArray2 = new boolean[18];
        blArray2[1] = true;
        blArray2[2] = true;
        blArray2[8] = true;
        blArray2[9] = true;
        blArray2[10] = true;
        blArray2[11] = true;
        blArray2[12] = true;
        blArray2[13] = true;
        blArray2[14] = true;
        blArray2[15] = true;
        blArray2[16] = true;
        blArray2[17] = true;
        isExtra = blArray2;
        int[] nArray = new int[18];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 2;
        nArray[4] = 16;
        nArray[5] = 18;
        nArray[6] = 28;
        nArray[7] = 4;
        nArray[8] = 5;
        nArray[9] = 6;
        nArray[10] = 7;
        nArray[11] = 8;
        nArray[12] = 9;
        nArray[13] = 10;
        nArray[14] = 20;
        nArray[15] = 22;
        nArray[16] = 24;
        nArray[17] = 26;
        loSubitem = nArray;
        int[] nArray2 = new int[18];
        nArray2[1] = 1;
        nArray2[2] = 3;
        nArray2[3] = 2;
        nArray2[4] = 17;
        nArray2[5] = 19;
        nArray2[6] = 29;
        nArray2[7] = 4;
        nArray2[8] = 5;
        nArray2[9] = 6;
        nArray2[10] = 7;
        nArray2[11] = 8;
        nArray2[12] = 9;
        nArray2[13] = 10;
        nArray2[14] = 21;
        nArray2[15] = 23;
        nArray2[16] = 25;
        nArray2[17] = 27;
        hiSubitem = nArray2;
    }

    public static void main(String[] args) {
        new TestMccUsb().run();
        System.exit(0);
    }

    public void run() {
        this.proc.add((CmndProcess.Dispatch)this, cmnd);
        try {
            String line;
            this.mcc = new MccUsb();
            ConsoleReader reader = new ConsoleReader();
            while ((line = reader.readLine(">> ")) != null && this.proc.process(line)) {
            }
        }
        catch (Exception e) {
            this.out.println((Object)e);
        }
    }

    public boolean dispatch(int code, int found, Object[] args) {
        try {
            switch (code) {
                case 0: {
                    this.procOpen(found, args);
                    break;
                }
                case 1: {
                    this.procClose(found, args);
                    break;
                }
                case 2: {
                    this.procDiocfg(found, args);
                    break;
                }
                case 3: {
                    this.procDiocfgbit(found, args);
                    break;
                }
                case 4: {
                    this.procDioin(found, args);
                    break;
                }
                case 5: {
                    this.procDioinbit(found, args);
                    break;
                }
                case 6: {
                    this.procDioout(found, args);
                    break;
                }
                case 7: {
                    this.procDiooutbit(found, args);
                    break;
                }
                case 8: {
                    this.procAdin(found, args);
                    break;
                }
                case 9: {
                    this.procAdscan(found, args);
                    break;
                }
                case 10: {
                    this.procCntrinit(found, args);
                    break;
                }
                case 11: {
                    this.procCntrread(found, args);
                    break;
                }
                case 12: {
                    this.procBlink(found, args);
                    break;
                }
                case 13: {
                    this.procReset(found, args);
                    break;
                }
                case 14: {
                    this.procStatus(found, args);
                    break;
                }
                case 15: {
                    this.procItemset(found, args);
                    break;
                }
                case 16: {
                    this.procItemget(found, args);
                    break;
                }
                case 17: {
                    this.procAlarmset(found, args);
                    break;
                }
                case 18: {
                    this.procAlarmget(found, args);
                    break;
                }
                case 24: {
                    this.procShowdev(found, args);
                    break;
                }
                case 19: {
                    this.procShowchan(found, args);
                    break;
                }
                case 20: {
                    this.procShowburn(found, args);
                    break;
                }
                case 21: {
                    this.procShowcal(found, args);
                    break;
                }
                case 22: {
                    this.procCalcfg(found, args);
                    break;
                }
                case 23: {
                    this.procCalibrate(found, args);
                    break;
                }
                default: {
                    this.out.println((Object)"Command not fully implemented");
                    break;
                }
            }
        }
        catch (UsbException e) {
            this.out.println((Object)e);
        }
        return true;
    }

    private void procOpen(int found, Object[] args) throws UsbException {
        if ((found & 1) == 0) {
            this.showNamesOnly("device", devNames);
            return;
        }
        this.mcc.open((Integer)args[0], (found & 4) != 0 ? (String)args[2] : null, ((found & 2) != 0 ? (Integer)args[1] : 0) != 0);
    }

    private void procClose(int found, Object[] args) throws UsbException {
        this.mcc.close();
    }

    private void procDiocfg(int found, Object[] args) throws UsbException {
        this.mcc.dioConfig((Integer)args[0]);
    }

    private void procDiocfgbit(int found, Object[] args) throws UsbException {
        this.mcc.dioConfigBit((Integer)args[0], (Integer)args[1]);
    }

    private void procDioin(int found, Object[] args) throws UsbException {
        this.out.format("Value = 0x%02x\n", new Object[]{this.mcc.dioIn()});
    }

    private void procDioinbit(int found, Object[] args) throws UsbException {
        this.out.println((Object)("Value = " + this.mcc.dioInBit((Integer)args[0])));
    }

    private void procDioout(int found, Object[] args) throws UsbException {
        this.mcc.dioOut((Integer)args[0]);
    }

    private void procDiooutbit(int found, Object[] args) throws UsbException {
        this.mcc.dioOutBit((Integer)args[0], (Integer)args[1]);
    }

    private void procAdin(int found, Object[] args) throws UsbException {
        int chan = (Integer)args[0];
        int units = (found & 2) != 0 ? (Integer)args[1] : 0;
        this.out.println((Object)("Value = " + this.mcc.adcIn(chan, units)));
    }

    private void procAdscan(int found, Object[] args) throws UsbException {
        float[] value = new float[8];
        int units = (found & 4) != 0 ? (Integer)args[2] : 0;
        int fChan = (Integer)args[0];
        int count = this.mcc.adcScan(fChan, (Integer)args[1], units, value);
        if (count <= 0) {
            return;
        }
        this.out.print((Object)"Values =");
        int posn = 8;
        int j = 0;
        while (j < count) {
            String sValue = " " + value[j];
            if ((posn += sValue.length()) > 80) {
                this.out.print((Object)"\n        ");
                posn = 8;
            }
            this.out.print((Object)sValue);
            ++j;
        }
        this.out.println();
    }

    private void procCntrinit(int found, Object[] args) throws UsbException {
        this.mcc.cntrInit();
    }

    private void procCntrread(int found, Object[] args) throws UsbException {
        this.out.println((Object)("Value = " + this.mcc.cntrRead()));
    }

    private void procBlink(int found, Object[] args) throws UsbException {
        this.mcc.blink();
    }

    private void procReset(int found, Object[] args) throws UsbException {
        this.mcc.reset();
    }

    private void procStatus(int found, Object[] args) throws UsbException {
        this.out.format("Value = 0x%02x\n", new Object[]{this.mcc.getStatus()});
    }

    private void procItemset(int found, Object[] args) throws UsbException {
        if ((found & 1) == 0) {
            this.showNames("item", itemNames);
            return;
        }
        if ((found & 2) == 0) {
            this.showNames("subitem", subiNames);
            return;
        }
        int item = (Integer)args[0];
        int subItem = (Integer)args[1];
        if ((found & 4) == 0) {
            if (subItem == 0) {
                this.showNames("sensor type", stypNames);
            } else if (subItem == 1) {
                this.showNames("thermal connection type", tconsNames);
            } else if (subItem == 2) {
                this.showNames("filter rate", frateNames);
            } else if (subItem == 3) {
                this.showNames("excitation", excitNames);
            } else if (subItem == 16 || subItem == 17) {
                this.showNames("thermocouple type", tctypNames);
            } else if (subItem == 18 || subItem == 19) {
                this.showNames("gain", gainNames);
            } else if (subItem == 28 || subItem == 29) {
                this.showNames("voltage connection type", vconnNames);
            } else {
                this.out.println((Object)"Missing value argument");
            }
            return;
        }
        String sValue = (String)args[2];
        if (subItem >= 4 && subItem <= 10 || subItem >= 20 && subItem <= 27) {
            try {
                this.mcc.setItem(item, subItem, Float.valueOf(sValue).floatValue());
            }
            catch (NumberFormatException numberFormatException) {
                this.out.println((Object)"Invalid floating point number");
            }
        } else {
            try {
                int iValue = subItem == 0 ? this.encode(stypNames, sValue) : (subItem == 1 ? this.encode(tconsNames, sValue) : (subItem == 2 ? this.encode(frateNames, sValue) : (subItem == 3 ? this.encode(excitNames, sValue) : (subItem == 16 || subItem == 17 ? this.encode(tctypNames, sValue) : (subItem == 18 || subItem == 19 ? this.encode(gainNames, sValue) : (subItem == 28 || subItem == 29 ? this.encode(vconnNames, sValue) : Integer.decode(sValue).intValue()))))));
                this.mcc.setItem(item, subItem, iValue);
            }
            catch (NumberFormatException numberFormatException) {
                this.out.println((Object)"Invalid keyword or integer");
            }
        }
    }

    private void procItemget(int found, Object[] args) throws UsbException {
        if ((found & 1) == 0) {
            this.showNames("item", itemNames);
            return;
        }
        if ((found & 2) == 0) {
            this.showNames("subitem", subiNames);
            return;
        }
        int item = (Integer)args[0];
        int subItem = (Integer)args[1];
        float value = this.mcc.getItem(item, subItem);
        if (subItem >= 4 && subItem <= 10 || subItem >= 20 && subItem <= 27) {
            this.out.println((Object)("Value = " + value));
        } else {
            int iValue = (int)value;
            if (subItem == 0) {
                this.out.format("Value = %s (%s)\n", new Object[]{iValue, stypNames.decode(iValue)});
            } else if (subItem == 1) {
                this.out.format("Value = %s (%s)\n", new Object[]{iValue, tconnNames.decode(iValue)});
            } else if (subItem == 2) {
                this.out.format("Value = %s (%s)\n", new Object[]{iValue, frateNames.decode(iValue)});
            } else if (subItem == 3) {
                this.out.format("Value = %s (%s)\n", new Object[]{iValue, excitNames.decode(iValue)});
            } else if (subItem == 16 || subItem == 17) {
                this.out.format("Value = %s (%s)\n", new Object[]{iValue, tctypNames.decode(iValue)});
            } else if (subItem == 18 || subItem == 19) {
                this.out.format("Value = %s (%s)\n", new Object[]{iValue, gainNames.decode(iValue)});
            } else if (subItem == 28 || subItem == 29) {
                this.out.format("Value = %s (%s)\n", new Object[]{iValue, vconnNames.decode(iValue)});
            } else {
                this.out.println((Object)("Value = " + iValue));
            }
        }
    }

    private void procAlarmset(int found, Object[] args) throws UsbException {
        this.mcc.configAlarm((Integer)args[0], (Integer)args[1], (Integer)args[2], ((Float)args[3]).floatValue(), ((Float)args[4]).floatValue());
    }

    private void procAlarmget(int found, Object[] args) throws UsbException {
        int[] optns = new int[2];
        float[] values = new float[]{0.0f, 0.0f};
        this.mcc.getAlarmConfig((Integer)args[0], optns, values);
        this.out.format("InOptns = 0x%02x, OutOptns = 0x%02x, Value1 = %s, Value2 = %s\n", new Object[]{optns[0], optns[1], Float.valueOf(values[0]), Float.valueOf(values[1])});
    }

    private void procShowdev(int found, Object[] args) throws UsbException {
        int devId = this.mcc.getDevId();
        if (devId < 0) {
            this.out.println((Object)"No device open");
        } else {
            this.out.format("Device = %s\n", new Object[]{devNames.decode(devId)});
        }
    }

    private void procShowchan(int found, Object[] args) throws UsbException {
        this.showChannel((found & 1) != 0 ? (Integer)args[0] : -1, (found & 2) != 0 && (Integer)args[1] != 0);
    }

    private void procShowburn(int found, Object[] args) throws UsbException {
        int mask = (found & 1) != 0 ? (Integer)args[0] : 255;
        this.out.format("Value = 0x%02x\n", new Object[]{this.mcc.getBurnout(mask)});
    }

    private void procShowcal(int found, Object[] args) throws UsbException {
        int[] steps = new int[2];
        this.mcc.calSteps(steps);
        this.out.format("Calibration steps: temp = %s, voltage = %s\n", new Object[]{steps[0], steps[1]});
    }

    private void procCalcfg(int found, Object[] args) throws UsbException {
        this.mcc.calConfig((Integer)args[0], (Integer)args[1], (Integer)args[2]);
    }

    private void procCalibrate(int found, Object[] args) throws UsbException {
        this.mcc.calibrate((Integer)args[0]);
    }

    private void showChannel(int chan, boolean all) throws UsbException {
        int first = chan < 0 ? 0 : chan & 7;
        int last = chan < 0 ? 7 : chan & 7;
        this.out.print((Object)"              ");
        int j = first;
        while (j <= last) {
            this.out.format("   Ch %s ", new Object[]{j});
            ++j;
        }
        this.out.println();
        this.out.print((Object)"              ");
        j = first;
        while (j <= last) {
            this.out.print((Object)" -------");
            ++j;
        }
        this.out.println();
        int k = 0;
        while (k < caption.length) {
            if (!isExtra[k] || all) {
                this.out.format("%-12s: ", new Object[]{caption[k]});
                int highSub = hiSubitem[k];
                int lowSub = loSubitem[k];
                boolean isVal = isValue[k];
                int j2 = first;
                while (j2 <= last) {
                    float value = this.mcc.getItem(j2 >> 1, (j2 & 1) != 0 ? highSub : lowSub);
                    if (isVal) {
                        this.out.format(" %7.7s", new Object[]{Float.valueOf(value)});
                    } else {
                        String desc = "huh?";
                        if (lowSub == 0) {
                            desc = stypsNames.decode((int)value);
                        } else if (lowSub == 1) {
                            desc = tconsNames.decode((int)value);
                        } else if (lowSub == 3) {
                            desc = excitNames.decode((int)value);
                        } else if (lowSub == 2) {
                            desc = frateNames.decode((int)value);
                        } else if (lowSub == 16) {
                            desc = tctypNames.decode((int)value);
                        } else if (lowSub == 18) {
                            desc = gainNames.decode((int)value);
                        } else if (lowSub == 28) {
                            desc = vconsNames.decode((int)value);
                        }
                        this.out.format(" %7s", new Object[]{desc});
                    }
                    ++j2;
                }
                this.out.println();
            }
            ++k;
        }
    }

    private void showNamesOnly(String desc, CmndProcess.Lookup lookup) {
        this.out.println((Object)("Possible " + desc + " names:"));
        int j = 0;
        while (j < lookup.count()) {
            this.out.format("  %s\n", new Object[]{lookup.name(j)});
            ++j;
        }
    }

    private void showNames(String desc, CmndProcess.Lookup lookup) {
        this.out.println((Object)("Possible " + desc + " names (values):"));
        int j = 0;
        while (j < lookup.count()) {
            this.out.format("  %s (%s)\n", new Object[]{lookup.name(j), lookup.code(j)});
            ++j;
        }
    }

    private int encode(CmndProcess.Lookup lookup, String token) throws NumberFormatException {
        int value;
        block2: {
            try {
                value = Integer.valueOf(token);
            }
            catch (NumberFormatException e) {
                value = lookup.encode(token, false);
                if (value >= 0) break block2;
                throw e;
            }
        }
        return value;
    }
}

