package org.lsst.ccs.drivers.mcc;

import javax.usb.UsbException;

/**
 ***************************************************************************
 **
 **  Access a Measurement Computing USB-TC-AI device
 **
 ***************************************************************************
 */
public class MccTemp extends MccUsb {


   /**
    ***************************************************************************
    **
    **  Constructor
    **
    ***************************************************************************
    */
    public MccTemp() throws UsbException
    {
    }


   /**
    ***************************************************************************
    **
    **  Opens device connection
    **
    **  @param  serial  The serial number of the device, or null if the first
    **                  found device of this type is to be used.
    **
    **  @param  force   If true, claiming the device is forced, allowing it
    **                  to be opened even if another driver has claimed it.
    **
    **  @throws  MccUsbException if device is already open or the device
    **                           cannot be found.
    **
    **  @throws  UsbClaimException if the device interface cannot be claimed.
    **
    ***************************************************************************
    */
    public void open(String serial, boolean force)
        throws MccUsbException, UsbException
    {
        open(USB_TEMP_DID, serial, force);
    }

}
