/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lighthouse;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.lsst.ccs.drivers.lighthouse.ChannelDatum;
import org.lsst.ccs.drivers.lighthouse.RecordFlag;

public final class DataRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    final Instant startTime;
    final Duration duration;
    final String location;
    final Set<RecordFlag> flags;
    final List<ChannelDatum> channels;

    public DataRecord(Instant startTime, Duration duration, String location, Set<RecordFlag> flags, List<ChannelDatum> channels) {
        this.startTime = startTime;
        this.duration = duration;
        this.location = location;
        this.flags = flags;
        this.channels = channels;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public String getLocation() {
        return this.location;
    }

    public Set<RecordFlag> getFlags() {
        return Collections.unmodifiableSet(this.flags);
    }

    public Stream<ChannelDatum> getChannels() {
        return this.channels.stream();
    }

    public String toString() {
        Formatter fmt = new Formatter();
        fmt.format("begin record%n", new Object[0]);
        fmt.format("    start %s%n", this.getStartTime().toString());
        fmt.format("    duration %d seconds%n", this.getDuration().getSeconds());
        fmt.format("    location %s%n", this.getLocation());
        fmt.format("    status", new Object[0]);
        this.getFlags().stream().forEach(flag -> fmt.format(" %s", flag));
        fmt.format("%n", new Object[0]);
        this.getChannels().forEachOrdered(datum -> fmt.format("    %s%n", datum));
        fmt.format("end record", new Object[0]);
        return fmt.toString();
    }
}

