package org.lsst.ccs.drivers.lighthouse;

import org.lsst.ccs.drivers.ascii.Ascii;

import org.lsst.ccs.drivers.commons.DriverException;

import java.time.Duration;

/**
 * Sends to and receives from a TCP server that owns the device.
 * @author tether
 */
public class NetTransport implements Transport {

    private final Ascii port;

    /**
     * Opens the network socket.
     * @param hostname The server's host name or IP address.
     * @param portNo The server's port number.
     * @throws DriverException if the open fails.
     */
    public NetTransport(String hostname, int portNo) throws DriverException {
        Ascii newPort = null;
        try {
        newPort = new Ascii();
        newPort.open(
            Ascii.ConnType.NET,
            hostname,
            portNo);
        newPort.setTerminator(MODBUS_FRAME_TERMINATOR);
        port = newPort;
        }
        catch (Exception exc) {
            if (newPort != null) {
                newPort.closeSilent(); // Release the socket.
            }
            throw exc;
        }
    }

    /** {@inheritDoc } */
    @Override
    public void send(String command) throws DriverException {
        port.write(command);
    }

    /** {@inheritDoc } */
    @Override
    public String receive(Duration timeout) throws DriverException {
        port.setTimeout(timeout.getSeconds());
        return port.read();
    }

    /** {@inheritDoc } */
    @Override
    public void close() {port.closeSilent();}
}
