/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lighthouse;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.lighthouse.ASCIIModbus;
import org.lsst.ccs.drivers.lighthouse.DataChannel;
import org.lsst.ccs.drivers.lighthouse.DataRecord;
import org.lsst.ccs.drivers.lighthouse.DeviceCommand;
import org.lsst.ccs.drivers.lighthouse.DeviceFlag;
import org.lsst.ccs.drivers.lighthouse.FTDITransport;
import org.lsst.ccs.drivers.lighthouse.Hardware;
import org.lsst.ccs.drivers.lighthouse.NetTransport;
import org.lsst.ccs.drivers.lighthouse.SerialTransport;

public class LighthouseClient {
    private final Hardware hw;
    private final String model;
    private final int registerMapVersion;

    public static LighthouseClient serialOpen(String portName, Duration timeout, boolean debug) throws DriverException {
        return new LighthouseClient(new ASCIIModbus(new SerialTransport(portName), timeout, debug));
    }

    public static LighthouseClient ftdiOpen(String ident, Duration timeout, boolean debug) throws DriverException {
        return new LighthouseClient(new ASCIIModbus(new FTDITransport(ident), timeout, debug));
    }

    public static LighthouseClient netOpen(String hostname, int portNo, Duration timeout, boolean debug) throws DriverException {
        return new LighthouseClient(new ASCIIModbus(new NetTransport(hostname, portNo), timeout, debug));
    }

    public LighthouseClient(Hardware hw) throws DriverException {
        this.hw = hw;
        this.model = hw.readDeviceModel();
        this.registerMapVersion = hw.readDeviceMapVersion();
        for (DataChannel chan : DataChannel.values()) {
            hw.readChannelType(chan);
            hw.readChannelUnits(chan);
            if (hw.channelIsEnabled(chan)) continue;
            throw new DriverException("Channel " + chan.getName() + " is not enabled");
        }
    }

    public void close() throws DriverException {
        this.hw.close();
    }

    public String getModel() {
        return this.model;
    }

    public int getRegisterMapVersion() {
        return this.registerMapVersion;
    }

    public void stopRecording() throws DriverException {
        this.hw.writeDeviceCommand(DeviceCommand.INSTRUMENT_STOP);
    }

    public void startRecording() throws DriverException {
        this.hw.writeDeviceCommand(DeviceCommand.INSTRUMENT_START);
    }

    public List<DataRecord> getRecordsByIndex(int start, int limit) throws DriverException {
        if (this.hw.readDeviceFlags().contains((Object)DeviceFlag.RUNNING)) {
            throw new DriverException("Can't read records when the device is running.");
        }
        int nrec = this.hw.readRecordCount();
        int first = start >= 0 ? start : Math.max(0, nrec + start);
        int last = limit <= 0 ? nrec - 1 : Math.min(nrec - 1, first + limit - 1);
        ArrayList<DataRecord> records = new ArrayList<DataRecord>();
        for (int i = first; i <= last; ++i) {
            records.add(this.fetchRecord(i));
        }
        return Collections.unmodifiableList(records);
    }

    public List<DataRecord> getRecentRecords(Instant threshold) throws DriverException {
        DataRecord nextrec;
        if (this.hw.readDeviceFlags().contains((Object)DeviceFlag.RUNNING)) {
            throw new DriverException("Can't read records when the device is running.");
        }
        int nrec = this.hw.readRecordCount();
        ArrayList<DataRecord> records = new ArrayList<DataRecord>();
        for (int i = nrec - 1; i >= 0 && (nextrec = this.fetchRecord(i)).getStartTime().isAfter(threshold); --i) {
            records.add(nextrec);
        }
        return Collections.unmodifiableList(records);
    }

    public void clearAllRecords() throws DriverException {
        if (this.hw.readDeviceFlags().contains((Object)DeviceFlag.RUNNING)) {
            throw new DriverException("Can't clear records when the device is running.");
        }
        this.hw.writeDeviceCommand(DeviceCommand.CLEAR_DATA_BUFFER);
    }

    public void setAlarmThreshold(DataChannel chan, long threshold) throws DriverException {
        this.hw.setAlarmThreshold(chan, threshold);
    }

    public long getAlarmThreshold(DataChannel chan) throws DriverException {
        return this.hw.getAlarmThreshold(chan);
    }

    public void setAlarmEnable(DataChannel chan, boolean on) throws DriverException {
        this.hw.setAlarmEnable(chan, on);
    }

    public boolean alarmIsEnabled(DataChannel chan) throws DriverException {
        return this.hw.alarmIsEnabled(chan);
    }

    public void setClock(Duration tolerance) throws DriverException {
        this.hw.setClock(Instant.now().getEpochSecond());
        Instant deviceNow = this.getClock();
        Instant sysLow = Instant.now().minus(tolerance);
        Instant sysHigh = sysLow.plus(tolerance.multipliedBy(2L));
        if (deviceNow.isBefore(sysLow) | deviceNow.isAfter(sysHigh)) {
            throw new DriverException("Can't get device clock within " + tolerance + " of system time.");
        }
    }

    public Instant getClock() throws DriverException {
        return Instant.ofEpochSecond(this.hw.getClock());
    }

    public void setLocationIndex(int index) throws DriverException {
        this.hw.setDeviceLocationIndex(index);
    }

    public String getLocationName() throws DriverException {
        return this.hw.getDeviceLocationName();
    }

    private DataRecord fetchRecord(int irec) throws DriverException {
        this.hw.writeRecordIndex(irec);
        return this.hw.readRecord();
    }

    private static class WrapperException
    extends RuntimeException {
        WrapperException(DriverException exc) {
            super((Throwable)exc);
        }
    }
}

