/**
 * Contains code to run the 2016, 3016 and 5016 family of airborne particle counters from Lighthouse Worldwide
 * Solutions. Developed and tested using the Handheld 3016-IAQ.
 * <p>
 * The device measures the density of airborne particles of various sizes. The models purchased for the LSST
 * I&T clean room have attachments for the measurement of temperature and relative humidity as well.
 * <p>
 * The class {@code LighthouseDriver} can be run using the bootstrap application {@code RunLighthouseDriver}.
 * The class {@code LighthouseClient} exports the highest-level operations, such as fetching records. The
 * {@code Hardware} interface represents data items which map directly to one or more registers in the device.
 * It's implemented by {@code ASCIIModbus} which generates command frames and interprets response frames
 * according to the ASCII Modbus protocol. The {@code Transport} interface represents the means by which
 * frames are transmitted to and from the device. There are three implementations of {@code Transport} which
 * use the package {@link org.lsst.ccs.drivers.ascii}:
 * {@code SerialTransport}, {@code FTDITransport} and {@code NetTransport}.
 * <p>
 * The device comes with a USB-to-serial conversion cable from FTDI that's USB-A on one end and RJ-45 on the
 * other. Most modern Linux installations have the kernel modules {@code ftdi_sio} and {@code usbserial}
 * enabled, so that when the device cable is plugged in to a USB port the modules are loaded if needed and the
 * device is treated as a serial TTY with a name such as {@code /dev/ttyUSB0}. You'll need to check the output
 * of the {@code dmesg} command after you plug in the cable to see exactly what name has been assigned. The
 * {@code SerialTransport} class and the driver's {@code openSerial} command are used to communicate with a
 * Lighthouse device installed in this way. The comm parameters for the serial port are fixed: raw tty mode,
 * 19200 bps, eight data bits, no parity, one stop bit. This is the factory setting for the device.
 * <p>
 * It's also possible to communicate with the FTDI chip directly. For this you have to make sure that
 * {@code ftdi_sio} and {@code usbserial} are never loaded on your Linux system. Each FTDI chip has a unique
 * serial number which you can use to identify the device you want, removing the need to discover dynamic
 * device name assignments. The <a href="https://confluence.slac.stanford.edu/x/kQqsC">FTDI driver page</a>
 * tells how to set this up on a RedHat-like Linux system. There's a server program
 * {@link org.lsst.ccs.drivers.ftdi.FtdiServer} allowing remote access to a host's locally installed FTDI
 * devices; it listens on TCP port 9001. In this case the remote user must precede the FTDI serial number with
 * the server's host name (or IP address) followed by a colon. The Lighthouse driver {@code FTDITransport}
 * class and the ftdiOpen command implement the raw-FTDI mode of operation.
 * <p>
 * Lastly, the {@code NetTransport} class and the driver's {@code netOpen} command allow you to forward the
 * ASCII Modbus frames to an arbitrary TCP server at a specified host and port, and to collect responses from
 * that server. The server presumably communicates with the actual Lighthouse device somehow and acts as a
 * relay.
 * <p>
 * Whatever transport variant is used, each device is assumed to be attached to its host using its own cable
 * and to have a Modbus slave ID of 1 (the factory setting).
 * <p>
 * Despite the settings of the built-in display, the particle counts read from the device are always raw,
 * cumulative counts. For example, a value of 2259 for the 1.0-micron counter channel indicates that during
 * the sample period the device counted 2259 particles of size 1.0 microns or larger.
 * <p>
 * Although the display may show temperature in degrees Celsius or Fahrenheit, temperatures read from the
 * device are always in degrees Fahrenheit.
 * <p>
 * Although you can set an alarm threshold for each particle channel and set alarm mode, no bell
 * ever sounds, although the red highlighting on the display works. Also, the alarm status bits
 * described in the Modbus register map always read as zeros. This may be because my test device has
 * map version 1.44 whereas the manual describes version 1.48. The data record device flags do however
 * properly show when some channel is above threshold.
 */
package org.lsst.ccs.drivers.lighthouse;
