package org.lsst.ccs.drivers.lighthouse;

import java.util.Formatter;

/**
 * Represents a single channel datum from a Lighthouse counter.
 * @author tether
 */
public final class ChannelDatum implements java.io.Serializable {

    private static final long serialVersionUID = 1L;

    private final DataChannel channel;
    private final double value;

    /**
     * Constructs an instance from the field values.
     * @param channel See {@link #getChannel() }.
     * @param value See {@link #getValue() }.
     */
    public ChannelDatum(DataChannel channel, double value) {
        this.channel = channel;
        this.value = value;
    }

    /**
     * Gets which channel the data value came from.
     * @return The channel.
     */
    public DataChannel getChannel() {return channel;}

    /**
     * Gets the value of the channel.
     * @return The value.
     */
    public double getValue() {return value;}

    /**
     * Returns a string representation of the channel datum.
     * @return The string.
     * @see DataRecord#toString()
     */
    @Override
    public String toString() {
        final Formatter fmt = new Formatter();
        final DataChannel chan = getChannel();
        fmt.format("channel");
        fmt.format(" %s", chan.getName());
        fmt.format(" %s", chan.getType());
        if (chan.isAnalog()) {
            fmt.format(" %5.2f", getValue());
        }
        else {
            fmt.format(" %d", (long)getValue());
        }
        fmt.format(" %s", chan.getUnits());
        return fmt.toString();
    }

}
