/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lighthouse;

import java.time.Duration;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.lighthouse.Transport;

public class SerialTransport
implements Transport {
    private final Ascii port = new Ascii();

    public SerialTransport(String portName) throws DriverException {
        this.port.open(Ascii.ConnType.SERIAL, portName, 19200, SERIAL_CHARACTERISTICS);
        this.port.setTerminator("\r\n");
        this.port.flush();
    }

    @Override
    public void send(String command) throws DriverException {
        this.port.write(command);
    }

    @Override
    public String receive(Duration timeout) throws DriverException {
        this.port.setTimeout((double)timeout.getSeconds());
        return this.port.read();
    }

    @Override
    public void close() {
        this.port.closeSilent();
    }
}

