/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lighthouse;

import java.util.EnumSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.drivers.lighthouse.DeviceFlag;

public class DeviceFlagTest {
    @Test
    public void testToString() {
        System.out.println("toString");
        String expected = "running!sampling!data!error!";
        String all = Stream.of(DeviceFlag.values()).map(DeviceFlag::toString).collect(Collectors.joining());
        Assert.assertEquals((Object)"running!sampling!data!error!", (Object)all);
    }

    @Test
    public void testGetMask() {
        System.out.println("getMask");
        Stream.of(DeviceFlag.values()).forEach(x -> Assert.assertEquals((String)("Mask for " + x + " is not single-bit"), (long)1L, (long)Integer.bitCount(x.getMask())));
        int[] ored = new int[]{0};
        Stream.of(DeviceFlag.values()).forEach(x -> {
            int a = ored[0];
            ored[0] = ored[0] | x.getMask();
            Assert.assertNotEquals((String)("Mask for " + x + " is not unique"), (long)a, (long)ored[0]);
        });
    }

    @Test
    public void testFlagsFromMask() {
        System.out.println("flagsFromMask");
        Assert.assertEquals((String)"Zero mask yields non-empty result", EnumSet.noneOf(DeviceFlag.class), (Object)DeviceFlag.flagsFromMask((int)0));
        int allMask = Stream.of(DeviceFlag.values()).mapToInt(DeviceFlag::getMask).reduce(0, (x, y) -> x | y);
        Assert.assertEquals((String)"Complete mask yields incomplete result", EnumSet.allOf(DeviceFlag.class), (Object)DeviceFlag.flagsFromMask((int)allMask));
        Stream.of(DeviceFlag.values()).forEach(x -> Assert.assertEquals((String)("Wrong result for " + x), EnumSet.of(x), (Object)DeviceFlag.flagsFromMask((int)x.getMask())));
    }
}

