package org.lsst.ccs.drivers.lighthouse;

import org.lsst.ccs.drivers.ascii.Ascii;

import org.lsst.ccs.drivers.commons.DriverException;

import java.time.Duration;

/**
 * Sends and receives bytes using a serial port on the local host.
 * @author tether
 */
public class NetTransport implements Transport {
    
    private final Ascii port;
    
    /**
     * Opens the serial port.
     * @param hostname The remote host name or IP address.
     * @param portNo The remote port number.
     * @throws DriverException if the open fails.
     */
    public NetTransport(String hostname, int portNo) throws DriverException {
        port = new Ascii();
        port.open(
            Ascii.ConnType.NET,
            hostname,
            portNo);
        port.setTerminator(MODBUS_FRAME_TERMINATOR);
    }
    
    /** {@inheritDoc } */
    @Override
    public void send(String command) throws DriverException {
        port.write(command);
    }
    
    /** {@inheritDoc } */
    @Override
    public String receive(Duration timeout) throws DriverException {
        port.setTimeout(timeout.getSeconds());
        return port.read();
    }
    
    /** {@inheritDoc } */
    @Override
    public void close() {port.closeSilent();}
}
