package org.lsst.ccs.drivers.lighthouse;

/**
 * Represents a single channel datum from a Lighthouse counter.
 * @author tether
 */
public final class ChannelDatum implements java.io.Serializable {
    
    private static final long serialVersionUID = 1L;
    
    private final DataChannel channel;
    private final double value;
    
    /**
     * Constructs an instance from the field values.
     * @param channel See {@link #getChannel() }.
     * @param value See {@link #getValue() }.
     */
    public ChannelDatum(DataChannel channel, double value) {
        this.channel = channel;
        this.value = value;
    }
    
    /**
     * Gets which channel the data value came from.
     * @return The channel.
     */
    public DataChannel getChannel() {return channel;}
  
    /**
     * Gets the value of the channel.
     * @return The value.
     */
    public double getValue() {return value;}
    
}
