/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lighthouse;

import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.lighthouse.ChannelType;
import org.lsst.ccs.drivers.lighthouse.ChannelUnits;
import org.lsst.ccs.drivers.lighthouse.DataChannel;
import org.lsst.ccs.drivers.lighthouse.DataRecord;
import org.lsst.ccs.drivers.lighthouse.DeviceCommand;
import org.lsst.ccs.drivers.lighthouse.DeviceFlag;
import org.lsst.ccs.drivers.lighthouse.RecordFlag;

public interface Hardware {
    public String readDeviceModel() throws DriverException;

    public int readDeviceMapVersion() throws DriverException;

    public Set<DeviceFlag> readDeviceFlags() throws DriverException;

    public void writeDeviceCommand(DeviceCommand var1) throws DriverException;

    public int readRecordCount() throws DriverException;

    public void writeRecordIndex(int var1) throws DriverException;

    public Instant readRecordStartTime() throws DriverException;

    public Duration readRecordDuration() throws DriverException;

    public String readRecordLocation() throws DriverException;

    public Set<RecordFlag> readRecordFlags() throws DriverException;

    public ChannelType readChannelType(DataChannel var1) throws DriverException;

    public ChannelUnits readChannelUnits(DataChannel var1) throws DriverException;

    public double readChannelValue(DataChannel var1) throws DriverException;

    public boolean channelIsEnabled(DataChannel var1) throws DriverException;

    public DataRecord readRecord() throws DriverException;

    public void setAlarmThreshold(DataChannel var1, long var2) throws DriverException;

    public long getAlarmThreshold(DataChannel var1) throws DriverException;

    public void setAlarmEnable(DataChannel var1, boolean var2) throws DriverException;

    public boolean alarmIsEnabled(DataChannel var1) throws DriverException;

    public void setClock(long var1) throws DriverException;

    public long getClock() throws DriverException;
}

