/**
 * Contains code to run the 2016, 3016 and 5016 family of airborne particle counters
 * from Lighthouse Worldwide Solutions. Developed and tested using the Handheld 3016-IAQ.
 * <p>
 * The device measures the density of airborne particles of various sizes. The models
 * purchased for the LSST I&T clean room have attachments for the measurement
 * of temperature and relative humidity as well.
 * <p>
 * The class LighthouseDriver can be run as a CCS command-line
 * application using the script {@code run-counter.sh}. The class Client
 * exports the highest-level operations, such as fetching records. The Hardware interface represents
 * data items which map directly to one or more registers in the device. It's implemented by ASCIIModbus
 * which generates command frames and interprets response frames according to the ASCII Modbus protocol.
 * The Transport interface represents the means by which frames are transmitted to and from the device.
 * There are three implementations of Transport which use the package {@link org.lsst.ccs.drivers.ascii}:
 * SerialTransport, FTDITransport and NetTransport.
 * <p>
 * The device comes with an FTDI USB-to-serial conversion
 * cable that's USB-A on one end and RJ-45 on the other. Most modern Linux installations have
 * the ftdi_sio and usbserial kernel modules enabled, so that when the device cable is plugged
 * in to a USB port the modules are loaded if needed and the device is treated as a serial
 * TTY with a name such as {@code /dev/ttyUSB0}. You'll need to check the output of the dmesg command
 * after you plug in the cable to see exactly what name has been assigned. The SerialTransport
 * class and the driver's openSerial command are used to communicate with a Lighthouse device installed
 * in this way. The comm parameters for the serial port are fixed: raw tty mode, 19200 bps, eight
 * data bits, no parity, one stop bit. This is the factory setting for the device.
 * <p>
 * It's also possible to communicate with the FTDI chip directly. For this you have
 * to make sure that ftdi_sio and usbserial are never loaded on your Linux system. Each FTDI chip has a
 * unique serial number which you can use to identify the device you
 * want, removing the need to discover dynamic device name
 * assignments. The <a href="https://confluence.slac.stanford.edu/x/kQqsC">FTDI driver page</a>
 * tells how to set this up
 * on a RedHat-like Linux system. There's a server program {@link org.lsst.ccs.drivers.ftdi.FtdiServer}
 * allowing remote access to a host's locally installed FTDI devices; it listens on TCP port 9001. In
 * this case the remote user must precede the FTDI serial number with the server's host name (or IP
 * address) followed by a colon. The Lighthouse driver FTDITransport class and the ftdiOpen command
 * implement the raw-FTDI mode of operation.
 * <p>
 * Lastly, the NetTransport class and the driver's netOpen command allow you to forward the ASCII Modbus
 * frames to an arbitrary TCP server at a specified host and port, and to collect responses from that server.
 * The server presumably communicates with the actual Lighthouse device somehow and acts as a relay.
 * <p>
 * Whatever transport variant is used, each device is assumed to be attached to its host using
 * its own cable and to have a Modbus slave ID of 1 (the factory setting).
 * <p>
 * Despite the settings of the built-in display, the particle counts read from the device are always raw,
 * cumulative counts. For example, a value of 2259 for the 1.0-micron counter channel indicates
 * that during the sample period the device counted 2259 particles of size 1.0 microns or larger.
 * <p>
 * Although the display may show temperature in degrees Celsius or Fahrenheit, temperatures
 * read from the device are always in degrees Fahrenheit.
 */
package org.lsst.ccs.drivers.lighthouse;
