package org.lsst.ccs.drivers.lighthouse;

import org.lsst.ccs.drivers.ascii.Ascii;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

import java.time.Duration;

/**
 * Sends and receives bytes using a serial port on the local host.
 * @author tether
 */
public class SerialTransport implements Transport {
    
    private final Ascii port;
    
    /**
     * Opens the serial port.
     * @param portName The name of the port, for example /dev/ttyUSB0.
     * @throws DriverException if the open fails.
     */
    public SerialTransport(String portName) throws DriverException {
        port = new Ascii();
        port.open(
            Ascii.ConnType.SERIAL,
            portName,
            SERIAL_BAUD,
            SERIAL_CHARACTERISTICS
        );
        port.setTerminator(MODBUS_FRAME_TERMINATOR);
    }
    
    /** {@inheritDoc } */
    @Override
    public void send(String command) throws DriverException {
        port.write(command);
    }
    
    /** {@inheritDoc } */
    @Override
    public String receive(Duration timeout) throws DriverException {
        port.setTimeout(timeout.getSeconds());
        return port.read();
    }
    
    /** {@inheritDoc } */
    @Override
    public void close() {port.closeSilent();}
}
