/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lighthouse;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.lighthouse.ChannelDatum;
import org.lsst.ccs.drivers.lighthouse.DataChannel;
import org.lsst.ccs.drivers.lighthouse.DataRecord;
import org.lsst.ccs.drivers.lighthouse.DeviceCommand;
import org.lsst.ccs.drivers.lighthouse.DeviceFlag;
import org.lsst.ccs.drivers.lighthouse.Hardware;
import org.lsst.ccs.drivers.lighthouse.RecordFlag;

public class Client {
    private final Hardware hw;
    private final String model;
    private final int registerMapVersion;

    public Client(Hardware hw) throws DriverException {
        this.hw = hw;
        this.model = hw.readDeviceModel();
        this.registerMapVersion = hw.readDeviceMapVersion();
    }

    public String getModel() {
        return this.model;
    }

    public int getRegisterMapVersion() {
        return this.registerMapVersion;
    }

    public void stopRecording() throws DriverException {
        this.hw.writeDeviceCommand(DeviceCommand.INSTRUMENT_STOP);
    }

    public void startRecording() throws DriverException {
        this.hw.writeDeviceCommand(DeviceCommand.INSTRUMENT_START);
    }

    public Stream<DataRecord> getRecords() throws DriverException {
        if (this.hw.readDeviceFlags().contains((Object)DeviceFlag.RUNNING)) {
            throw new DriverException("Can't read records when the device is running.");
        }
        int nrec = this.hw.readRecordCount();
        try {
            return IntStream.range(0, nrec).mapToObj(this::fetchRecord);
        }
        catch (WrapperException exc) {
            throw (DriverException)exc.getCause();
        }
    }

    private DataRecord fetchRecord(int irec) {
        try {
            this.hw.writeRecordIndex(irec);
            Instant startTime = this.hw.readRecordStartTime();
            Duration duration = this.hw.readRecordDuration();
            String location = this.hw.readRecordLocation();
            Set<RecordFlag> flags = this.hw.readRecordFlags();
            List<ChannelDatum> channels = Stream.of(DataChannel.values()).map(this::fetchChannel).collect(Collectors.toList());
            return new DataRecord(startTime, duration, location, flags, channels);
        }
        catch (DriverException exc) {
            throw new WrapperException(exc);
        }
    }

    private ChannelDatum fetchChannel(DataChannel chan) {
        try {
            this.hw.readChannelType(chan);
            this.hw.readChannelUnits(chan);
            return new ChannelDatum(chan, this.hw.readChannelValue(chan));
        }
        catch (DriverException exc) {
            throw new WrapperException(exc);
        }
    }

    public void clearRecords() throws DriverException {
        if (this.hw.readDeviceFlags().contains((Object)DeviceFlag.RUNNING)) {
            throw new DriverException("Can't clear records when the device is running.");
        }
        this.hw.writeDeviceCommand(DeviceCommand.CLEAR_DATA_BUFFER);
    }

    private static class WrapperException
    extends RuntimeException {
        WrapperException(DriverException exc) {
            super(exc);
        }
    }
}

