/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lighthouse;

import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.lighthouse.ChannelType;
import org.lsst.ccs.drivers.lighthouse.ChannelUnits;
import org.lsst.ccs.drivers.lighthouse.DataChannel;
import org.lsst.ccs.drivers.lighthouse.DeviceCommand;
import org.lsst.ccs.drivers.lighthouse.DeviceFlag;
import org.lsst.ccs.drivers.lighthouse.Hardware;
import org.lsst.ccs.drivers.lighthouse.RecordFlag;
import org.lsst.ccs.drivers.lighthouse.Transport;
import org.lsst.ccs.utilities.logging.Logger;

public class ASCIIModbus
implements Hardware {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.drivers.lighthouse");
    private final Transport transport;
    private final Duration timeout;
    private final boolean debug;
    private static final int MODBUS_SLAVENO = 1;
    private static final int MODBUS_READ_HOLDING = 3;
    private static final int MODBUS_READ_INPUT = 4;
    private static final int MODBUS_WRITE_HOLDING = 6;
    private static final Pattern frameRegex = Pattern.compile(":(?:\\p{XDigit}{2}){4,}");

    public ASCIIModbus(Transport transport, Duration timeout, boolean debug) {
        this.transport = transport;
        this.timeout = timeout;
        this.debug = debug;
    }

    @Override
    public String readDeviceModel() throws DriverException {
        if (this.debug) {
            log.debug((Object)"Reading model.");
        }
        return this.getString(this.readRegisters(1, 3, 14, 8));
    }

    @Override
    public int readDeviceMapVersion() throws DriverException {
        if (this.debug) {
            log.debug((Object)"Reading map version.");
        }
        return this.getShorts(this.readRegisters(1, 3, 0, 1))[0];
    }

    @Override
    public Set<DeviceFlag> readDeviceFlags() throws DriverException {
        if (this.debug) {
            log.debug((Object)"Reading device flags.");
        }
        return DeviceFlag.flagsFromMask(this.getShorts(this.readRegisters(1, 3, 2, 1))[0]);
    }

    @Override
    public void writeDeviceCommand(DeviceCommand cmd) throws DriverException {
        if (this.debug) {
            log.debug((Object)("Writing command " + (Object)((Object)cmd)));
        }
        this.writeRegister(1, 6, 1, cmd.getCommandNum());
    }

    @Override
    public int readRecordCount() throws DriverException {
        if (this.debug) {
            log.debug((Object)"Reading record count.");
        }
        return this.getShorts(this.readRegisters(1, 3, 23, 1))[0];
    }

    @Override
    public void writeRecordIndex(int index) throws DriverException {
        if (this.debug) {
            log.debug((Object)("Writing " + index + " to record index."));
        }
        this.writeRegister(1, 6, 24, index);
    }

    @Override
    public Instant readRecordStartTime() throws DriverException {
        if (this.debug) {
            log.debug((Object)"Reading record start time.");
        }
        return Instant.ofEpochSecond(this.getInts(this.readRegisters(1, 4, 0, 2))[0]);
    }

    @Override
    public Duration readRecordDuration() throws DriverException {
        if (this.debug) {
            log.debug((Object)"Reading record duration.");
        }
        return Duration.ofSeconds(this.getInts(this.readRegisters(1, 4, 2, 2))[0]);
    }

    @Override
    public String readRecordLocation() throws DriverException {
        if (this.debug) {
            log.debug((Object)"Reading record location.");
        }
        int locno = (int)this.getInts(this.readRegisters(1, 4, 4, 2))[0];
        return this.getString(this.readRegisters(1, 3, 199 + 4 * (locno - 1), 4));
    }

    @Override
    public Set<RecordFlag> readRecordFlags() throws DriverException {
        if (this.debug) {
            log.debug((Object)"Reading record flags.");
        }
        return RecordFlag.flagsFromMask((int)this.getInts(this.readRegisters(1, 4, 6, 2))[0]);
    }

    @Override
    public ChannelType readChannelType(DataChannel chan) throws DriverException {
        int addr;
        String devType;
        ChannelType ctype;
        if (this.debug) {
            log.debug((Object)String.format("Reading type for channel '%s'.", chan.getName()));
        }
        if ((ctype = ChannelType.fromTypeLabel(devType = this.getString(this.readRegisters(1, 3, addr = this.channelTypeAddress(chan.getIndex()), 2)))) == null) {
            throw new DriverException("Unknown channel data type: " + devType);
        }
        if (!ctype.equals((Object)chan.getType())) {
            throw new DriverException(String.format("Wrong data type of '%s' (%s) for channel '%s' which should be a %s channel", new Object[]{devType, ctype, chan.getName(), chan.getType()}));
        }
        return ctype;
    }

    @Override
    public ChannelUnits readChannelUnits(DataChannel chan) throws DriverException {
        int addr;
        String devUnits;
        ChannelUnits cunits;
        if (this.debug) {
            log.debug((Object)String.format("Reading units for channel '%s'.", chan.getName()));
        }
        if ((cunits = ChannelUnits.fromUnitsLabel(devUnits = this.getString(this.readRegisters(1, 3, addr = this.channelUnitsAddress(chan.getIndex()), 2)))) == null) {
            throw new DriverException("Unknown channel data units: " + devUnits);
        }
        if (!cunits.equals((Object)chan.getUnits())) {
            throw new DriverException(String.format("Read units of '%s' (%s) for channel '%s' instead of '%s' (%s)", new Object[]{devUnits, cunits, chan.getName(), chan.getUnits().getDeviceText(), chan.getUnits()}));
        }
        return cunits;
    }

    @Override
    public double readChannelValue(DataChannel chan) throws DriverException {
        if (this.debug) {
            log.debug((Object)String.format("Reading value for channel '%s'.", chan.getName()));
        }
        if (!this.channelIsEnabled(chan)) {
            throw new DriverException(String.format("Channel '%s' is disabled.", chan.getName()));
        }
        int addr = this.channelValueAddress(chan.getIndex());
        int[] response = this.readRegisters(1, 4, addr, 2);
        return chan.isAnalog() ? this.getFloats(response)[0] : (double)this.getInts(response)[0];
    }

    private int channelTypeAddress(int index) {
        return 1008 + 2 * index;
    }

    private int channelUnitsAddress(int index) {
        return 2008 + 2 * index;
    }

    private int channelEnablesAddress(int index) {
        return 3008 + 2 * index;
    }

    private int channelValueAddress(int index) {
        return 8 + 2 * index;
    }

    private boolean channelIsEnabled(DataChannel chan) throws DriverException {
        int addr = this.channelEnablesAddress(chan.getIndex());
        long enables = this.getInts(this.readRegisters(1, 3, addr, 2))[0];
        return (enables & 1L) != 0L;
    }

    private int[] readRegisters(int slaveno, int function, int address, int nreg) throws DriverException {
        this.transport.send(this.encodeFrame(ASCIIModbus.makeReadCommand(slaveno, function, address, nreg)));
        return this.checkResponse(slaveno, function);
    }

    private void writeRegister(int slaveno, int function, int address, int value) throws DriverException {
        this.transport.send(this.encodeFrame(ASCIIModbus.makeWriteCommand(slaveno, function, address, value)));
        this.checkResponse(slaveno, function);
    }

    private int[] checkResponse(int slaveno, int function) throws DriverException {
        int[] response = this.decodeFrame(this.transport.receive(this.timeout));
        if (response[0] != slaveno) {
            throw new DriverException("Wrong slave no. in Modbus response");
        }
        if ((response[1] & 0x7F) != function) {
            throw new DriverException("Wrong function code in Modbus response");
        }
        if (ASCIIModbus.isException(response)) {
            throw new DriverException("Modbus exception " + ASCIIModbus.getExceptionCode(response));
        }
        return response;
    }

    private static int[] makeReadCommand(int slaveno, int function, int address, int nreg) {
        return new int[]{slaveno & 0xFF, function & 0xFF, address >> 8 & 0xFF, address & 0xFF, nreg >> 8 & 0xFF, nreg & 0xFF, 0};
    }

    private static int[] makeWriteCommand(int slaveno, int function, int address, int value) {
        return new int[]{slaveno & 0xFF, function & 0xFF, address >> 8 & 0xFF, address & 0xFF, value >> 8 & 0xFF, value & 0xFF, 0};
    }

    private String encodeFrame(int[] command) {
        int sum = IntStream.of(command).limit(command.length - 1).sum();
        command[command.length - 1] = -sum & 0xFF;
        String frame = Stream.concat(Stream.of(":"), IntStream.of(command).mapToObj(v -> String.format("%02X", v))).collect(Collectors.joining());
        if (this.debug) {
            log.debug((Object)("Sending " + frame));
        }
        return frame;
    }

    private int[] decodeFrame(String frame) throws DriverException {
        Matcher mat;
        if (this.debug) {
            log.debug((Object)("Received " + frame));
        }
        if (!(mat = frameRegex.matcher(frame)).matches()) {
            throw new DriverException("Malformed Modbus response frame");
        }
        int[] result = IntStream.iterate(1, i -> i + 2).limit((frame.length() - 1) / 2).map(i -> Integer.parseInt(frame.substring(i, i + 2), 16)).toArray();
        int sum = IntStream.of(result).sum() & 0xFF;
        if (sum != 0) {
            throw new DriverException("Modbus LRC is incorrect");
        }
        return result;
    }

    private static boolean isException(int[] response) {
        return (response[1] & 0x80) != 0;
    }

    private static int getExceptionCode(int[] response) {
        return response[2];
    }

    private int[] getShorts(int[] response) {
        int nreg = response[2] / 2;
        int[] shorts = new int[nreg];
        for (int i2 = 0; i2 < nreg; ++i2) {
            shorts[i2] = response[3 + 2 * i2] << 8 | response[4 + 2 * i2];
        }
        if (this.debug) {
            log.debug((Object)IntStream.of(shorts).mapToObj(i -> String.format("%04x", i)).collect(Collectors.joining(" ", "Shorts (hex): ", "")));
        }
        return shorts;
    }

    private long[] getInts(int[] response) {
        int[] shorts = this.getShorts(response);
        long[] ints = new long[shorts.length / 2];
        for (int i2 = 0; i2 < ints.length; ++i2) {
            ints[i2] = (long)shorts[2 * i2] << 16 | (long)shorts[2 * i2 + 1];
        }
        if (this.debug) {
            log.debug((Object)LongStream.of(ints).mapToObj(i -> String.format("%08x", i)).collect(Collectors.joining(" ", "Ints (hex): ", "")));
        }
        return ints;
    }

    private double[] getFloats(int[] response) {
        double[] floats = LongStream.of(this.getInts(response)).map(l -> (l & 0xFFFFL) << 16 | l >> 16 & 0xFFFFL).mapToDouble(l -> Float.intBitsToFloat((int)l)).toArray();
        if (this.debug) {
            log.debug((Object)DoubleStream.of(floats).mapToObj(i -> String.format("%e", i)).collect(Collectors.joining(" ", "Floats: ", "")));
        }
        return floats;
    }

    private String getString(int[] response) {
        String s = IntStream.of(response).skip(3L).limit(response[2]).filter(i -> i != 0).mapToObj(i -> String.valueOf((char)i)).collect(Collectors.joining());
        if (this.debug) {
            log.debug((Object)("String: " + s));
        }
        return s;
    }
}

