/**
 * Contains code to run the 2016, 3016 and 5016 family of airborne particle counters
 * from Lighthouse Worldwide Solutions. Developed and tested using the Handheld 3016-IAQ.
 * <p>
 * The device measures the density of airborne particles of various sizes. The models
 * purchased for the LSST I&T clean room have attachments for the measurement
 * of temperature and relative humidity as well.
 * <p>
 * There's a driver, LighthouseDriver, which can be run as a CCS command-line
 * application using the script run-counter.sh. The class Client
 * represents a single device.
 * <p>
 * Remote control is via the ASCII variant of the Modbus protocol over an RS-232C
 * line. Modern versions of the device come with an FTDI USB-to-serial conversion
 * cable that's USB-A on one end and RJ-45 on the other. The code in this package
 * is written assuming that the FTDI cable appears as USB serial port; for that to
 * happen your Linux system must have the ftdi_sio and usbserial modules installed.
 * <p>
 * The comm parameters for the serial port are fixed by Lighthouse: raw tty mode, 19200 bps, eight
 * data bits, no parity, one stop bit. This software doesn't attempt to set comm parameters.
 * Also, each counter is assumed to be on its own cable and to have a Modbus slave ID of 1.
 * <p>
 * Despite the settings of the built-in display, the particle counts read from the device are always raw,
 * cumulative counts. For example, a value of 2259 for the 1.0-micron counter channel indicates
 * that during the sample period the device counted 2259 particles of size 1.0 microns or larger.
 * <p>
 * Although the display may show temperature in degrees Celsius or Fahrenheit, temperatures
 * read from the device are always in degrees Fahrenheit.
 */
package org.lsst.ccs.drivers.lighthouse;
