package org.lsst.ccs.drivers.lighthouse;

/**
 * The hardware commands used by this software. The command number assigned to each
 * enumerator is the actual value written to the device command register.
 * 
 * Note that you should stop the device before reading out or clearing its stored records.
 * @author tether
 */
public enum DeviceCommand {
    /** Delete all stored records and set the record count to zero. */
    CLEAR_DATA_BUFFER(3),
    
    /** Start automatic data collection cycles. */
    INSTRUMENT_START(11),
    
    /** Stop automatic data collection. */
    INSTRUMENT_STOP(12);
    
    private final int commandNum;
    
    DeviceCommand(int commandNum) {this.commandNum = commandNum;}
    
    /**
     * Gets the command number.
     * @return The number to write to the device command register in order to execute the command.
     */
    public int getCommandNum() {return commandNum;}
}
