/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.serial;

import java.util.Arrays;
import jssc.SerialPortException;
import jssc.SerialPortTimeoutException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class SerialPort {
    jssc.SerialPort portImpl;

    public SerialPort() {
    }

    public SerialPort(String name) throws DriverException {
        this();
        this.openPort(name);
    }

    public void openPort(String name) throws DriverException {
        if (this.portImpl != null) {
            throw new IllegalStateException("Device connection already open");
        }
        this.portImpl = new jssc.SerialPort(name);
        try {
            this.portImpl.openPort();
        }
        catch (SerialPortException e) {
            throw new DriverException("cannot open port", (Throwable)e);
        }
    }

    public boolean closePort() throws DriverException {
        try {
            if (this.portImpl.closePort()) {
                this.portImpl = null;
                return true;
            }
            return false;
        }
        catch (SerialPortException e) {
            throw new DriverException("cannot close port", (Throwable)e);
        }
    }

    public int getInputBufferBytesCount() throws DriverException {
        try {
            return this.portImpl.getInputBufferBytesCount();
        }
        catch (SerialPortException e) {
            throw new DriverException("serial port error", (Throwable)e);
        }
    }

    public byte[] readBytes() throws DriverException {
        try {
            return this.portImpl.readBytes();
        }
        catch (SerialPortException e) {
            throw new DriverException("serial port error", (Throwable)e);
        }
    }

    public byte[] readBytes(int byteCount, int timeout) throws DriverException {
        try {
            return this.portImpl.readBytes(byteCount, timeout);
        }
        catch (SerialPortException e) {
            throw new DriverException("serial port error", (Throwable)e);
        }
        catch (SerialPortTimeoutException e) {
            throw new DriverTimeoutException("serial port timeout", (Throwable)e);
        }
    }

    public byte[] readBytes(int byteCount) throws DriverException {
        try {
            return this.portImpl.readBytes(byteCount);
        }
        catch (SerialPortException e) {
            throw new DriverException("serial port error", (Throwable)e);
        }
    }

    public String readString() throws DriverException {
        try {
            return this.portImpl.readString();
        }
        catch (SerialPortException e) {
            throw new DriverException("serial port error", (Throwable)e);
        }
    }

    public String readString(int byteCount, int timeout) throws DriverException {
        try {
            return this.portImpl.readString(byteCount, timeout);
        }
        catch (SerialPortException e) {
            throw new DriverException("serial port error", (Throwable)e);
        }
        catch (SerialPortTimeoutException e) {
            throw new DriverTimeoutException("serial port timeout", (Throwable)e);
        }
    }

    public String readString(int byteCount) throws DriverException {
        try {
            return this.portImpl.readString(byteCount);
        }
        catch (SerialPortException e) {
            throw new DriverException("serial port error", (Throwable)e);
        }
    }

    public boolean setFlowControlMode(int mask) throws DriverException {
        try {
            return this.portImpl.setFlowControlMode(mask);
        }
        catch (SerialPortException e) {
            throw new DriverException("serial port error", (Throwable)e);
        }
    }

    public boolean setParams(int baudRate, int dataBits, int stopBits, int parity) throws DriverException {
        try {
            return this.portImpl.setParams(baudRate, dataBits, stopBits, parity);
        }
        catch (SerialPortException e) {
            throw new DriverException("serial port error", (Throwable)e);
        }
    }

    public boolean writeByte(byte singleByte) throws DriverException {
        try {
            return this.portImpl.writeByte(singleByte);
        }
        catch (SerialPortException e) {
            throw new DriverException("serial port error", (Throwable)e);
        }
    }

    public boolean writeBytes(byte[] buffer) throws DriverException {
        try {
            return this.portImpl.writeBytes(buffer);
        }
        catch (SerialPortException e) {
            throw new DriverException("serial port error", (Throwable)e);
        }
    }

    public boolean writeBytes(byte[] buffer, int offset, int leng) throws DriverException {
        try {
            return this.portImpl.writeBytes(Arrays.copyOfRange(buffer, offset, offset + leng));
        }
        catch (SerialPortException e) {
            throw new DriverException("serial port error", (Throwable)e);
        }
    }

    public boolean writeString(String string) throws DriverException {
        try {
            return this.portImpl.writeString(string);
        }
        catch (SerialPortException e) {
            throw new DriverException("serial port error", (Throwable)e);
        }
    }

    public void writeStringCRLF(String s) throws DriverException {
        StringBuilder cmd = new StringBuilder(s);
        cmd.append('\r');
        cmd.append('\n');
        this.writeString(cmd.toString());
    }

    public void writeStringLF(String s) throws DriverException {
        StringBuilder cmd = new StringBuilder(s);
        cmd.append('\n');
        this.writeString(cmd.toString());
    }

    public void writeStringCR(String s) throws DriverException {
        StringBuilder cmd = new StringBuilder(s);
        cmd.append('\r');
        this.writeString(cmd.toString());
    }

    public String readUntilCRLF() throws DriverException {
        return this.readUntilCRLF(1000);
    }

    public String readUntilLF() throws DriverException {
        return this.readUntilLF(1000);
    }

    public String readUntilSUPSP() throws DriverException {
        return this.readUntilSUPSP(1000);
    }

    public String readUntilSUPSP(int timeout) throws DriverException {
        StringBuilder buf = new StringBuilder();
        while (true) {
            byte[] b;
            if ((b = this.readBytes(1, timeout))[0] == 62 || b[0] == 60) {
                byte sb = b[0];
                b = this.readBytes(1, timeout);
                if (b[0] == 32) {
                    return buf.toString();
                }
                buf.append((char)sb);
            }
            buf.append((char)b[0]);
        }
    }

    public String readUntilLF(int timeout) throws DriverException {
        StringBuilder buf = new StringBuilder();
        byte[] b;
        while ((b = this.readBytes(1, timeout))[0] != 10) {
            buf.append((char)b[0]);
        }
        return buf.toString();
    }

    public String readUntilCRLF(int timeout) throws DriverException {
        StringBuilder buf = new StringBuilder();
        while (true) {
            byte[] b;
            if ((b = this.readBytes(1, timeout))[0] == 13) {
                byte sb = b[0];
                b = this.readBytes(1, timeout);
                if (b[0] == 10) {
                    return buf.toString();
                }
                buf.append((char)sb);
            }
            buf.append((char)b[0]);
        }
    }

    public int read(byte[] buff, int offset, int timeout) throws DriverException {
        return this.read(buff, offset, buff.length - offset, timeout);
    }

    public int read(byte[] buff, int offset, int mleng, int timeout) throws DriverException {
        byte[] data;
        if (offset + mleng > buff.length) {
            mleng = buff.length - offset;
        }
        int leng = 0;
        int count = this.getInputBufferBytesCount();
        if (count == 0) {
            data = timeout > 0 ? this.readBytes(1, timeout) : this.readBytes(1);
            buff[offset++] = data[0];
            leng = 1;
            count = this.getInputBufferBytesCount();
        }
        if (count > mleng) {
            count = mleng;
        }
        if (count > 0) {
            data = this.readBytes(count);
            System.arraycopy(data, 0, buff, offset, count);
            leng += count;
        }
        return leng;
    }
}

