/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lighthouse;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.time.Duration;
import java.util.Optional;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.lighthouse.ASCIIModbus;
import org.lsst.ccs.drivers.lighthouse.Client;
import org.lsst.ccs.drivers.lighthouse.DataChannel;
import org.lsst.ccs.drivers.lighthouse.Hardware;
import org.lsst.ccs.drivers.serial.SerialPort;
import org.lsst.ccs.utilities.logging.Logger;

public class LighthouseDriver {
    private final int LH_BAUD_19200 = 19200;
    private final int LH_NDATA_8 = 8;
    private final int LH_NSTOP_1 = 1;
    private final int LH_PARITY_NONE = 0;
    private final Duration LH_COMM_TIMEOUT = Duration.ofSeconds(10L);
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.drivers.lighthouse");
    private Optional<Client> lhClient = Optional.empty();
    private Optional<Hardware> lhHardware = Optional.empty();
    private Optional<SerialPort> lhPort = Optional.empty();

    @Command(name="open", description="Opens the device in normal mode")
    public void open(@Argument(description="The serial port name, for example /dev/ttyUSB0.") String portName) throws DriverException {
        this.genericOpen(portName, false);
    }

    @Command(name="debugOpen", description="Opens the device in debug mode")
    public void debugOpen(@Argument(description="The serial port name, for example /dev/ttyUSB0.") String portName) throws DriverException {
        this.genericOpen(portName, true);
    }

    private void genericOpen(String portName, boolean debug) throws DriverException {
        this.close();
        SerialPort port = new SerialPort();
        port.openPort(portName);
        this.lhPort = Optional.of(port);
        ASCIIModbus hw = new ASCIIModbus(port, this.LH_COMM_TIMEOUT, debug);
        this.lhHardware = Optional.of(hw);
        this.lhClient = Optional.of(new Client(hw));
        String model = this.lhClient.get().getModel();
        log.info((Object)("Device model: " + model));
        if (!model.matches(".*(2016|3016|5016).*")) {
            throw new DriverException("Unknown device model");
        }
        int mapver = this.lhClient.get().getRegisterMapVersion();
        log.info((Object)String.format("Modbus register map v%d.%02d", mapver / 100, mapver % 100));
    }

    @Command(name="close", description="Closes the serial port used to communicate with the counter.")
    public void close() throws DriverException {
        if (this.lhPort.isPresent()) {
            this.lhPort.get().closePort();
        }
        this.lhPort = Optional.empty();
        this.lhHardware = Optional.empty();
        this.lhClient = Optional.empty();
    }

    @Command(name="stopRecording", description="Stops the counter so that it no longer updates its internal data set.")
    public void stopRecording() throws DriverException {
        this.lhClient.get().stopRecording();
    }

    @Command(name="startRecording", description="Starts the counter, appending all future records to its internal data set.")
    public void startRecording() throws DriverException {
        this.lhClient.get().startRecording();
    }

    @Command(name="clearRecords", description="Clears all readings from the counter's internal data set.")
    public void clearRecords() throws DriverException {
        this.lhClient.get().clearRecords();
    }

    @Command(name="getRecords", description="Saves the counter's buffered data set as ASCII text.")
    public void getRecords(@Argument(description="The name of the file in which to save") String filename) throws DriverException {
        try (PrintWriter p = new PrintWriter(filename, "US-ASCII");){
            this.printRecords(p);
        }
        catch (FileNotFoundException | UnsupportedEncodingException exc) {
            throw new DriverException("Can't open " + filename, exc);
        }
    }

    @Command(name="getRecords", description="Prints to stdout the counter's buffered data set using the default encoding.")
    public void getRecords() throws DriverException {
        this.printRecords(new PrintWriter(System.out));
    }

    private void printRecords(PrintWriter out) throws DriverException {
        this.lhClient.get().getRecords().forEach(rec -> {
            out.printf("begin record%n", new Object[0]);
            out.printf("    start %s%n", rec.getStartTime().toString());
            out.printf("    duration %d seconds%n", rec.getDuration().getSeconds());
            out.printf("    location %s%n", rec.getLocation());
            out.printf("    status", rec);
            rec.getFlags().stream().forEach(flag -> out.printf(" %s", flag));
            out.println();
            rec.getChannels().forEach(datum -> {
                DataChannel chan = datum.getChannel();
                out.printf("    channel", new Object[0]);
                out.printf(" %s", chan.getName());
                out.printf(" %s", new Object[]{chan.getType()});
                if (chan.isAnalog()) {
                    out.printf(" %5.2f", datum.getValue());
                } else {
                    out.printf(" %d", (long)datum.getValue());
                }
                out.printf(" %s%n", new Object[]{chan.getUnits()});
            });
            out.printf("end record%n", new Object[0]);
        });
        out.flush();
    }
}

