/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ascii;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;

public class TestAscii {
    protected final Ascii dev;

    public TestAscii() {
        this.dev = new Ascii();
    }

    public TestAscii(Ascii dev) {
        this.dev = dev;
    }

    @Command(name="open", description="Open connection to general device")
    public void open(@Argument(name="type", description="Connection type: net, serial or ftdi") DriverConstants.ConnType type, @Argument(name="ident", description="Device identifier") String ident, @Argument(name="param", description="Device parameter") int param) throws DriverException {
        this.dev.open(type, ident, param);
    }

    @Command(name="open", description="Open connection with serial data characteristics")
    public void open(@Argument(name="type", description="Connection type: serial or ftdi") DriverConstants.ConnType type, @Argument(name="ident", description="Device identifier") String ident, @Argument(name="baud", description="Baud rate") int baud, @Argument(name="dbits", description="The number of data bits") Ascii.DataBits dbits, @Argument(name="sbits", description="The number of stop bits") Ascii.StopBits sbits, @Argument(name="parity", description="The parity") Ascii.Parity parity, @Argument(name="flow", description="The flow control") Ascii.FlowCtrl flow) throws DriverException {
        this.dev.open(type, ident, baud, Ascii.makeDataCharacteristics(dbits, sbits, parity, flow));
    }

    @Command(name="opennet", description="Open connection to network device")
    public void openNet(@Argument(name="host", description="Host name") String host, @Argument(name="port", description="Port number") int port) throws DriverException {
        this.dev.openNet(host, port);
    }

    @Command(name="openserial", description="Open connection to serial device")
    public void openSerial(@Argument(name="devc", description="Device name") String devc, @Argument(name="baud", description="Baud rate") int baud) throws DriverException {
        this.dev.openSerial(devc, baud);
    }

    @Command(name="openftdi", description="Open connection to FTDI device")
    public void openFtdi(@Argument(name="serial", description="USB serial number") String serial, @Argument(name="baud", description="Baud rate") int baud) throws DriverException {
        this.dev.openFtdi(serial, baud);
    }

    @Command(name="close", description="Close connection to device")
    public void close() throws DriverException {
        this.dev.close();
    }

    @Command(name="write", description="Write command to device")
    public void write(@Argument(name="command", description="Command word") String command, String ... args) throws DriverException {
        StringBuilder cmnd = new StringBuilder(command);
        for (String arg : args) {
            cmnd.append(" ").append(arg);
        }
        this.dev.write(TestAscii.makeCommandString(command, args));
    }

    @Command(name="read", description="Read response from device")
    public String read() throws DriverException {
        return this.dev.read();
    }

    @Command(name="read", description="Write command and read response")
    public String read(@Argument(name="command", description="Command to send") String command) throws DriverException {
        return this.dev.read(command);
    }

    @Command(name="settimeout", description="Set read response timeout")
    public void setTimeout(@Argument(name="time", description="Timeout value (sec)") double time) throws DriverException {
        this.dev.setTimeout(time);
    }

    @Command(name="setcmndterm", description="Set command terminator")
    public void setCmndTerm(@Argument(name="term", description="Terminator enum") Ascii.Terminator term) {
        this.dev.setCommandTerm(term);
    }

    @Command(name="setrespterm", description="Set response terminator")
    public void setRespTerm(@Argument(name="term", description="Terminator enum") Ascii.Terminator term) {
        this.dev.setResponseTerm(term);
    }

    @Command(name="setterm", description="Set both terminators")
    public void setTerminator(@Argument(name="term", description="Terminator enum") Ascii.Terminator term) {
        this.dev.setTerminator(term);
    }

    protected static String makeCommandString(String command, String ... args) {
        StringBuilder cmnd = new StringBuilder(command);
        for (String arg : args) {
            cmnd.append(' ').append(arg);
        }
        return cmnd.toString();
    }
}

