/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lambda;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.i2c.I2c;
import org.lsst.ccs.drivers.lambda.Cpfe1000;

public class TestCpfe1000 {
    private final Cpfe1000 cpfe = new Cpfe1000();

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="type", description="Connection type") I2c.ConnType connType, @Argument(name="ident", description="Identification") String ident, @Argument(name="addr", description="Bus address") int addr) throws DriverException {
        this.cpfe.open(connType, ident, addr);
    }

    @Command(name="close", description="Close the connection")
    public void close() throws DriverException {
        this.cpfe.close();
    }

    @Command(name="showserial", description="Show the serial number")
    public String showSerial() throws DriverException {
        return this.cpfe.getSerialNo();
    }

    @Command(name="showfirmware", description="Show the firmware revision")
    public String showFirmware() throws DriverException {
        return this.cpfe.getFirmwareRev();
    }

    @Command(name="showproduct", description="Show the product revision")
    public String showProduct() throws DriverException {
        return this.cpfe.getProductRev();
    }

    @Command(name="showunitpart", description="Show the unit part number")
    public String showUnitPart() throws DriverException {
        return this.cpfe.getUnitPartNo();
    }

    @Command(name="showdatemanu", description="Show the manufacture date")
    public String showDateManu() throws DriverException {
        return this.cpfe.getManufactureDate();
    }

    @Command(name="showlocmanu", description="Show the manufacture location")
    public String showLocManu() throws DriverException {
        return this.cpfe.getManufactureLoc();
    }

    @Command(name="showstatus", description="Show the status byte")
    public String showStatus() throws DriverException {
        return String.format("%02x", this.cpfe.readStatus());
    }

    @Command(name="showvoltage", description="Show the voltage")
    public String showVoltage() throws DriverException {
        return String.format("%.2f", this.cpfe.readVoltage());
    }

    @Command(name="showcurrent", description="Show the current")
    public String showCurrent() throws DriverException {
        return String.format("%.2f", this.cpfe.readCurrent());
    }

    @Command(name="showtemperature", description="Show the temperature")
    public String showTemperature() throws DriverException {
        return String.format("%.2f", this.cpfe.readTemperature());
    }

    @Command(name="power", description="Turn the power on or off")
    public void power(@Argument(name="action", description="Action: on or off") OnOff action) throws DriverException {
        if (action == OnOff.ON) {
            this.cpfe.powerOn();
        } else {
            this.cpfe.powerOff();
        }
    }

    protected static enum OnOff {
        ON,
        OFF;

    }
}

