/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lambda;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.i2c.I2c;

public class Cpfe1000
extends I2c {
    public static final int STATUS_OFF = 1;
    public static final int STATUS_DSAB = 2;
    public static final int STATUS_IOGB = 4;
    public static final int STATUS_OTW = 8;
    public static final int STATUS_OTP = 16;
    public static final int STATUS_VBAD = 32;
    public static final int STATUS_IBAD = 64;
    private static final int REG_STATUS = 7;
    private static final int REG_SERIAL_NO = 1;
    private static final int REG_FIRMWARE_REV = 2;
    private static final int REG_PRODUCT_REV = 3;
    private static final int REG_UNIT_PART_NO = 8;
    private static final int REG_MFG_DATE = 9;
    private static final int REG_MFG_LOCATION = 16;
    private static final int REG_VOLTAGE = 4;
    private static final int REG_CURRENT = 5;
    private static final int REG_TEMPERATURE = 6;
    private static final int REG_TURN_ON = 26;
    private static final int REG_TURN_OFF = 10;
    private static final int LENG_STATUS = 1;
    private static final int LENG_SERIAL_NO = 20;
    private static final int LENG_FIRMWARE_REV = 3;
    private static final int LENG_PRODUCT_REV = 4;
    private static final int LENG_UNIT_PART_NO = 11;
    private static final int LENG_MFG_DATE = 8;
    private static final int LENG_MFG_LOCATION = 3;
    private static final int LENG_VOLTAGE = 2;
    private static final int LENG_CURRENT = 2;
    private static final int LENG_TEMPERATURE = 2;
    private static final int LENG_TURN_ON = 1;
    private static final int LENG_TURN_OFF = 1;
    private static final int MODEL_UNK = -1;
    private static final int MODEL_12 = 0;
    private static final int MODEL_28 = 1;
    private static final int MODEL_48 = 2;
    private static final double[] vScale = new double[]{0.034, 0.0777, 0.1355};
    private static final double[] iScale = new double[]{0.0815, 0.0488, 0.0282};
    private int busAddr;
    private int model;

    @Override
    public void open(I2c.ConnType connType, String ident, int addr) throws DriverException {
        super.open(connType, ident, 0);
        this.busAddr = addr;
        this.model = -1;
        try {
            String mName = this.getUnitPartNo();
            if (mName.startsWith("CPFE1000F")) {
                String mNum = mName.substring(9);
                int n = mNum.equals("12") ? 0 : (mNum.equals("28") ? 1 : (this.model = mNum.equals("48") ? 2 : -1));
            }
            if (this.model == -1) {
                throw new DriverException("Unrecognized Lambda PS model: " + mName);
            }
        }
        catch (DriverException e) {
            this.close();
            throw e;
        }
    }

    public String getSerialNo() throws DriverException {
        return this.readString(1, 20);
    }

    public String getFirmwareRev() throws DriverException {
        return this.readString(2, 3);
    }

    public String getProductRev() throws DriverException {
        return this.readString(3, 4);
    }

    public String getUnitPartNo() throws DriverException {
        return this.readString(8, 11);
    }

    public String getManufactureDate() throws DriverException {
        return this.readString(9, 8);
    }

    public String getManufactureLoc() throws DriverException {
        return this.readString(16, 3);
    }

    public int readStatus() throws DriverException {
        return this.readInt(7, 1);
    }

    public double readVoltage() throws DriverException {
        return vScale[this.model] * (double)this.readInt(4, 2);
    }

    public double readCurrent() throws DriverException {
        return iScale[this.model] * (double)this.readInt(5, 2);
    }

    public double readTemperature() throws DriverException {
        return (double)(this.readInt(6, 2) - 610) / 1.8 + 25.0;
    }

    public void powerOn() throws DriverException {
        this.write(this.busAddr, 26, new byte[1]);
    }

    public void powerOff() throws DriverException {
        this.write(this.busAddr, 10, new byte[1]);
    }

    private int readInt(int reg, int count) throws DriverException {
        byte[] data = this.doRead(reg, count);
        int value = data[0] & 0xFF;
        if (count == 2) {
            value = value << 8 | data[1] & 0xFF;
        }
        return value;
    }

    private String readString(int reg, int count) throws DriverException {
        return new String(this.doRead(reg, count));
    }

    private byte[] doRead(int reg, int count) throws DriverException {
        byte[] data = new byte[count];
        int nread = this.read(this.busAddr, reg, data);
        if (nread < count) {
            throw new DriverException("Data deficit: " + nread + "/" + count + " bytes read");
        }
        return data;
    }
}

