/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.dispatch;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.lsst.ccs.utilities.dispatch.PackCst;
import org.lsst.ccs.utilities.dispatch.SynchronousCommandFor;

public class SynchronousCommandDispatcher<T> {
    protected CopyOnWriteArrayList<T> list = new CopyOnWriteArrayList();

    public void addExecutant(T executant) {
        this.list.add(executant);
    }

    public void removeExecutant(T executant) {
        this.list.remove(executant);
    }

    public void dispatchCommand(SynchronousCommandFor<? super T> command) {
        for (T executant : this.list) {
            try {
                command.invokeOn(executant);
            }
            catch (Exception exc) {
                PackCst.CURLOG.log(Level.SEVERE, "while dispatching :", exc);
            }
        }
    }
}

