/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.keithley;

import java.io.Serializable;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.PowerSupplyDriver;
import org.lsst.ccs.drivers.scpi.Scpi;

public class Model2231A
extends Scpi
implements PowerSupplyDriver {
    public static final int BAUDRATE = 9600;
    public static final int MIN_CHANNEL = 1;
    public static final int MAX_CHANNEL = 3;
    public static final int NUM_CHANNELS = 3;
    public static final double MAX_VALUE = Double.POSITIVE_INFINITY;
    private final Timer timer = new Timer("Timer_2231A", true);
    private final long[] onDelay = new long[3];
    private final long[] offDelay = new long[3];
    private final SetOutput[] outTask = new SetOutput[3];

    public Model2231A() {
        this.setOptions(Ascii.Option.NO_NET);
        this.setDefaultBaud(9600);
    }

    public void open(DriverConstants.ConnType connType, String ident, int baudRate, int commParm) throws DriverException {
        super.open(connType, ident, 9600, 0);
        this.setTerminator(Ascii.Terminator.LF);
        try {
            this.write("SYST:REM");
            this.checkIdentification("Keithley", 1, "2231A", 1);
        }
        catch (DriverException e) {
            this.closeSilent();
            throw e;
        }
    }

    public void setOutput(boolean on, int chan) throws DriverException {
        this.checkChannel(chan);
        int index = chan - 1;
        long delay = on ? this.onDelay[index] : this.offDelay[index];
        String command = "CHAN:OUTP " + (on ? "1" : "0");
        SetOutput task = this.outTask[index];
        if (task != null) {
            task.cancel();
            this.outTask[index] = null;
        }
        if (delay == 0L) {
            this.writeChan(command, chan);
        } else {
            this.outTask[index] = new SetOutput(command, chan);
            this.timer.schedule((TimerTask)this.outTask[index], delay);
        }
    }

    public boolean getOutput(int chan) throws DriverException {
        return this.readIntegerChan("CHAN:OUTP?", chan) != 0;
    }

    public void setOnDelay(double time, int chan) throws DriverException {
        this.checkChannel(chan);
        this.onDelay[chan - 1] = (long)(1000.0 * time);
    }

    public void setOffDelay(double time, int chan) throws DriverException {
        this.checkChannel(chan);
        this.offDelay[chan - 1] = (long)(1000.0 * time);
    }

    public void setVoltage(double value, int chan) throws DriverException {
        this.writeChan("VOLT " + (Serializable)(Double.isFinite(value) ? Double.valueOf(value) : "MAX"), chan);
    }

    public void setVoltage(double[] values) throws DriverException {
        this.writeCommand("APP:VOLT " + Model2231A.makeString(values));
    }

    public double getVoltage(int chan) throws DriverException {
        return this.readDoubleChan("VOLT?", chan);
    }

    public double[] getVoltage() throws DriverException {
        return this.readDoubleArray("APP:VOLT?");
    }

    public double getMaximumVoltage(int chan) throws DriverException {
        return this.readDoubleChan("VOLT? MAX", chan);
    }

    public double readVoltage(int chan) throws DriverException {
        return this.readDoubleChan("MEAS:VOLT?", chan);
    }

    public void setCurrent(double value, int chan) throws DriverException {
        this.writeChan("CURR " + (Serializable)(Double.isFinite(value) ? Double.valueOf(value) : "MAX"), chan);
    }

    public void setCurrent(double[] values) throws DriverException {
        this.writeCommand("APP:CURR " + Model2231A.makeString(values));
    }

    public double getCurrent(int chan) throws DriverException {
        return this.readDoubleChan("CURR?", chan);
    }

    public double[] getCurrent() throws DriverException {
        return this.readDoubleArray("APP:CURR?");
    }

    public double getMaximumCurrent(int chan) throws DriverException {
        return this.readDoubleChan("CURR? MAX", chan);
    }

    public double readCurrent(int chan) throws DriverException {
        return this.readDoubleChan("MEAS:CURR?", chan);
    }

    public void setVoltageLimit(double value, int chan) throws DriverException {
        this.writeChan("VOLT:LIMIT " + (Serializable)(Double.isFinite(value) ? Double.valueOf(value) : "MAX"), chan);
    }

    public double getVoltageLimit(int chan) throws DriverException {
        return this.readDoubleChan("VOLT:LIMIT?", chan);
    }

    public void setVoltageLimitCheck(boolean on, int chan) throws DriverException {
        this.writeChan("VOLT:LIMIT:STATE " + (on ? 1 : 0), chan);
    }

    public boolean getVoltageLimitCheck(int chan) throws DriverException {
        return this.readIntegerChan("VOLT:LIMIT:STATE?", chan) == 1;
    }

    public void lockPanel(boolean lock) throws DriverException {
        this.writeCommand(lock ? "SYST:RWL" : "SYST:REM");
    }

    private void checkChannel(int chan) throws DriverException {
        if (chan < 1 || chan > 3) {
            throw new DriverException("Invalid channel number");
        }
    }

    private void writeSelect(int chan) throws DriverException {
        this.checkChannel(chan);
        this.writeCommand("INST:NSEL " + chan);
    }

    private synchronized void writeChan(String instr, int chan) throws DriverException {
        this.writeSelect(chan);
        this.writeCommand(instr);
    }

    private synchronized double readDoubleChan(String instr, int chan) throws DriverException {
        this.writeSelect(chan);
        return this.readDouble(instr);
    }

    private synchronized int readIntegerChan(String instr, int chan) throws DriverException {
        this.writeSelect(chan);
        return this.readInteger(instr);
    }

    private static String makeString(double[] values) throws DriverException {
        if (values.length != 3) {
            throw new DriverException("Invalid value array size");
        }
        StringBuilder str = new StringBuilder();
        for (int j = 0; j < values.length; ++j) {
            if (j != 0) {
                str.append(",");
            }
            str.append(Double.isFinite(values[j]) ? Double.valueOf(values[j]) : "MAX");
        }
        return str.toString();
    }

    class SetOutput
    extends TimerTask {
        private final int chan;
        private final String command;

        SetOutput(String command, int chan) {
            this.command = command;
            this.chan = chan;
        }

        @Override
        public void run() {
            try {
                Model2231A.this.writeChan(this.command, this.chan);
            }
            catch (DriverException driverException) {
                // empty catch block
            }
            Model2231A.this.outTask[this.chan - 1] = null;
        }
    }
}

