/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.keithley;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.keithley.N6487;
import org.lsst.ccs.drivers.scpi.Scpi;
import org.lsst.ccs.drivers.scpi.TestScpi;

public class TestN6487
extends TestScpi {
    private final N6487 n64;
    private final ConsThread consThread = new ConsThread();

    public TestN6487() {
        super((Scpi)new N6487());
        this.n64 = (N6487)this.scpi;
    }

    @Command(name="open", description="Open connection to device using defaults")
    public void open() throws DriverException {
        this.n64.open();
    }

    @Command(name="open", description="Open serial device connection")
    public String open(@Argument(name="device", description="Device name") String device) throws DriverException {
        this.n64.open(device);
        return this.n64.printdevid();
    }

    @Command(name="open", description="Open connection to serial device")
    public String open(@Argument(name="device", description="Device name") String device, @Argument(name="baud", description="Baud rate") int baud) throws DriverException {
        this.n64.open(device, baud);
        return this.n64.printdevid();
    }

    @Command(name="showlinefreq", description="Show the line frequency")
    public String showLineFreq() throws DriverException {
        return "Line frequency = " + this.n64.getLineFreq() + " Hz";
    }

    @Command(name="showmaxbuffsize", description="Show the maximum buffer size")
    public String showMaxBuffSize() {
        return "Maximum buffer size = " + this.n64.getMaxBufferSize();
    }

    @Command(name="setrate", description="Set reading rate")
    public void setRate(@Argument(name="value", description="number of power cycles") double value) throws DriverException {
        this.n64.setRate(value);
    }

    @Command(name="showrate", description="Show reading rate")
    public String showRate() throws DriverException {
        return "Reading rate = " + this.n64.getRate();
    }

    @Command(name="setarmcount", description="Set the ARM count")
    public void setArmCount(@Argument(name="value", description="ARM count") int value) throws DriverException {
        this.n64.setArmCount(value);
    }

    @Command(name="settrigcount", description="Set the trigger count")
    public void setTrigCount(@Argument(name="value", description="trigger count") int value) throws DriverException {
        this.n64.setTrigCount(value);
    }

    @Command(name="clrbuff", description="Clear the read buffer")
    public void clearBuffer() throws DriverException {
        this.n64.clrBuff();
    }

    @Command(name="accumbuff", description="start the buffer accumulation")
    public void accumBuffer(int nreads, double nplc) throws DriverException {
        this.n64.accumBuffer(nreads, nplc);
    }

    @Command(name="waitaccum", description="wait for accumulation completion")
    public void waitAccum(double timeout) throws DriverException {
        this.n64.waitAccum(timeout);
    }

    @Command(name="readdblbuff", description="read the buffer")
    public String readBuffer() throws DriverException {
        double[][] data = this.n64.readBuffer();
        return "Data  = " + this.getString(data[0]) + "\nTimes = " + this.getString(data[1]);
    }

    @Command(name="readcurrents", description="read a set of currents")
    public String readCurrents(int nreads, double nplc) throws DriverException {
        double[][] data = this.n64.readCurrents(nreads, nplc);
        return "Data  = " + this.getString(data[0]) + "\nTimes = " + this.getString(data[1]);
    }

    @Command(name="reset", description="reset the device to a useable state")
    public void reset() throws DriverException {
        this.n64.reset();
    }

    @Command(name="setbuffsize", description="Set the buffer size.")
    public void setBuffSize(@Argument(name="value", description="buffer size") int value) throws DriverException {
        this.n64.setBuffSize(value);
    }

    @Command(name="setvoltagerange", description="Set the voltage range. Can be 10V, 50V or 500V")
    public void setVoltageRange(@Argument(name="value", description="Voltage Range to set") double value) throws DriverException {
        this.n64.setVoltageRange(value);
    }

    @Command(name="setvoltage", description="Set the voltage")
    public void setVoltage(@Argument(name="value", description="Voltage to set") double value) throws DriverException {
        this.n64.setVoltage(value);
    }

    @Command(name="rampvolts", description="Set the voltage")
    public void rampVolts(@Argument(name="duration", description="number of second for the ramp") double duration, @Argument(name="value", description="Voltage to set") double value) throws DriverException {
        this.n64.rampVolts(duration, value);
    }

    @Command(name="showvoltage", description="Show the set voltage")
    public String getVoltage() throws DriverException {
        return "Voltage = " + this.n64.getVoltage();
    }

    @Command(name="readvoltage", description="Read the actual voltage")
    public String readVoltage() throws DriverException {
        return "Voltage = " + this.n64.readVoltage();
    }

    @Command(name="setcurrentrange", description="Set the current range")
    public void setCurrentRange(@Argument(name="value", description="Current Range to set") double value) throws DriverException {
        this.n64.setCurrentRange(value);
    }

    @Command(name="zerocorrectcurrent", description="Zero correct the current")
    public void zeroCorrectCurrent() throws DriverException {
        this.n64.zeroCorrectCurrent();
    }

    @Command(name="readcurrent", description="Read the actual current")
    public String readCurrent() throws DriverException {
        return "Current = " + this.n64.readCurrent();
    }

    @Command(name="timereadcurrent", description="Time reading the actual current")
    public String timeReadCurrent() throws DriverException {
        long startTime = System.currentTimeMillis();
        double value = this.n64.readCurrent();
        int time = (int)(System.currentTimeMillis() - startTime);
        return "Current = " + value + " (" + time + " ms)";
    }

    @Command(name="setcurrlim", description="Set the soft current limit")
    public void setCurrentLimit(@Argument(name="value", description="Current limit to set") double value) throws DriverException {
        this.n64.setCurrentLimit(value);
    }

    @Command(name="showcurrlim", description="Show the soft current limit")
    public String getCurrentLimit() throws DriverException {
        return "Current limit = " + this.n64.getCurrentLimit();
    }

    @Command(name="setoutput", description="Turn output on or off")
    public void setOutput(@Argument(name="state", description="Output state: on or off") onOff state) throws DriverException {
        this.n64.setOutput(state == onOff.ON);
    }

    @Command(name="showoutput", description="Show the output state")
    public String showOutput() throws DriverException {
        return "Output state = " + this.getOnOff(this.n64.getOutput());
    }

    @Command(name="moncurrent", description="Monitor the current")
    public void monCurrent(@Argument(name="interval", description="Monitoring interval (secs)") double intvl) throws DriverException {
        System.out.println("Monitoring current: press any key to terminate");
        long millis = (long)(1000.0 * intvl);
        boolean[] done = new boolean[]{false};
        this.consThread.start(done, true);
        while (!done[0]) {
            System.out.print(this.n64.readCurrent() + " ");
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println();
    }

    @Command(name="timereadstring", description="Time reading arbitrary command data")
    public String timeReadString(@Argument(name="command", description="Command to execute") String command) throws DriverException {
        long startTime = System.currentTimeMillis();
        String value = this.n64.readString(command);
        int time = (int)(System.currentTimeMillis() - startTime);
        return value + " (" + time + " ms)";
    }

    @Command(name="timewritecommand", description="Time writing arbitrary command")
    public String timeWriteCommand(@Argument(name="command", description="Command to execute") String command) throws DriverException {
        long startTime = System.currentTimeMillis();
        this.n64.writeCommand(command);
        int time = (int)(System.currentTimeMillis() - startTime);
        return "(" + time + " ms)";
    }

    private StringBuilder getString(double[] values) {
        StringBuilder text = new StringBuilder();
        text.append(values[0]);
        for (int j = 1; j < values.length; ++j) {
            text.append(", ").append(values[j]);
        }
        return text;
    }

    private String getOnOff(boolean on) {
        return on ? "on" : "off";
    }

    public static enum onOff {
        OFF,
        ON;

    }

    class ConsThread
    extends Thread {
        private final BlockingQueue<Integer> consQueue = new ArrayBlockingQueue<Integer>(1);
        private boolean[] consDone;
        private Thread mainThread;

        ConsThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                this.awaitStart();
                this.awaitTerminal();
                this.consDone[0] = true;
                if (this.mainThread == null) continue;
                this.mainThread.interrupt();
            }
        }

        public void start(boolean[] done, boolean wake) {
            if (this.getState() == Thread.State.NEW) {
                this.start();
            }
            this.consDone = done;
            this.consDone[0] = false;
            this.mainThread = wake ? Thread.currentThread() : null;
            this.consQueue.offer(0);
        }

        public void start(boolean[] done) {
            this.start(done, false);
        }

        private void awaitStart() {
            while (true) {
                try {
                    this.consQueue.take();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private void awaitTerminal() {
            block6: while (true) {
                try {
                    while (System.in.available() <= 0) {
                        try {
                            Thread.sleep(50L);
                            continue block6;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    break;
                }
                catch (IOException e) {
                    // empty catch block
                    break;
                }
            }
            try {
                while (System.in.available() > 0) {
                    System.in.read();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

