/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.keithley;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.Scpi;

public class N6487
extends Scpi {
    private double timeout = 10.0;
    private static final int DEFAULT_BAUD = 19200;
    private static final String DEFAULT_DEV = "/dev/ttyUSB0";
    private static final double MINBIAS = -75.0;
    private static final double MAXBIAS = 5.0;
    private static final double MAXCURRENT = 0.001;
    private static final boolean debug = true;
    private boolean OKTOTALK = true;
    private boolean DATAREADY = false;
    private boolean trip = false;
    private boolean abort = false;
    private boolean ACCUM_IN_PROGRESS;

    public void open(String devname) throws DriverException {
        this.open(devname, 19200);
    }

    public void open() throws DriverException {
        this.open(DEFAULT_DEV, 19200);
        this.setTimeout(this.timeout);
    }

    public void open(String devname, int port) throws DriverException {
        this.open(2, devname, port);
        this.checkIdentification("KEITHLEY", 1, "MODEL 648", 1);
        this.setTimeout(this.timeout);
    }

    public void openftdi(String serialname, int port) throws DriverException {
        this.open(1, serialname, port);
        this.checkIdentification("KEITHLEY", 1, "MODEL 648", 1);
        this.setTimeout(this.timeout);
    }

    public String printdevid() throws DriverException {
        String[] id = this.getIdentification();
        return "Successfully connected to:\nManufacturer:   " + id[0] + "\nModel name:     " + id[1] + "\nSerial number:  " + id[2] + "\nF/W version:    " + id[3];
    }

    @Override
    public void reset() throws DriverException {
        this.OKTOTALK = true;
        this.writeKthly("*RST");
        this.writeKthly("ARM:COUN 1");
        this.writeKthly("TRAC:FEED:CONT NEVER");
        this.writeKthly("SOUR:VOLT:SWE:ABOR");
    }

    public void softReset() throws DriverException {
        this.OKTOTALK = true;
        this.writeKthly("ARM:COUN 1");
        this.writeKthly("TRAC:FEED:CONT NEVER");
        this.writeKthly("SOUR:VOLT:SWE:ABOR");
    }

    public void clearStat() throws DriverException {
        this.writeKthly("*CLS");
    }

    public void setOutput(boolean on) throws DriverException {
        this.writeKthly("SOUR:VOLT:STAT " + (on ? "ON" : "OFF"));
    }

    public boolean getOutput() throws DriverException {
        return this.readIntegerKthly("SOUR:VOLT:STAT?") != 0;
    }

    public boolean isTrip() {
        return this.trip;
    }

    public void setTrip(boolean trip) {
        this.trip = trip;
    }

    public boolean isAbort() {
        return this.abort;
    }

    public void setAbort(boolean abort) {
        this.abort = abort;
    }

    public void setRate(double value) throws DriverException {
        this.writeKthly("NPLC " + value);
    }

    public void setArmCount(int value) throws DriverException {
        String line = "ARM:COUN " + value;
        this.writeKthly(line);
    }

    public void setTrigCount(int value) throws DriverException {
        this.writeKthly("TRIG:COUN " + value);
    }

    public void setTrigDelay(int value) throws DriverException {
        this.writeKthly("TRIG:DEL " + value);
    }

    public void setBuffSize(int value) throws DriverException {
        this.write("TRAC:POIN " + value);
    }

    public void clrBuff() throws DriverException {
        this.write("TRAC:CLE");
    }

    public void setVoltageRange(double value) throws DriverException {
        this.writeKthly("SOUR:VOLT:RANG " + value);
    }

    public void setVoltage(double value) throws DriverException {
        double usedvalue = 0.0;
        if (value < -75.0 || value > 5.0) {
            System.out.println("Only values between -75.V and 5.V are allowed in order to protect the CCD!");
            throw new DriverException();
        }
        usedvalue = value;
        this.writeKthly("SOUR:VOLT " + usedvalue);
    }

    public void rampVolts_sweep(double duration, double value, int nsteps) throws DriverException {
        double vnow = this.readVoltage();
        double vstep = Math.abs(value - vnow) / (double)nsteps;
        double delta = duration / (double)nsteps;
        System.out.println("starting ramp from " + Double.toString(vnow) + " to " + Double.toString(value) + " with vstep = " + Double.toString(vstep) + " with tstep = " + Double.toString(delta));
        this.writeKthly("SOUR:VOLT " + value);
        this.writeKthly("SOUR:VOLT:SWE:STAR " + vnow);
        this.writeKthly("SOUR:VOLT:SWE:STOP " + value);
        this.writeKthly("SOUR:VOLT:SWE:STEP " + vstep);
        this.writeKthly("SOUR:VOLT:SWE:DEL " + delta);
        this.setArmCount(nsteps + 1);
        this.writeKthly("FORM:ELEM READ");
        this.writeKthly("SOUR:VOLT:SWE:INIT");
        this.writeKthly("SYST:ZCH OFF");
        System.out.println("started ramp");
        double[] buff = this.readDoubleArray("READ?");
        System.out.println("ramp completed");
    }

    public boolean current_OK() throws DriverException {
        return this.readCurrent() < 0.001;
    }

    public void rampVolts(double duration, double value, int nsteps) throws DriverException {
        double vnow = this.readVoltage();
        double vstep = (value - vnow) / (double)nsteps;
        int delta = (int)(1000.0 * duration / (double)nsteps);
        System.out.println("ramp from " + Double.toString(vnow) + " to " + Double.toString(value) + " with vstep = " + Double.toString(vstep) + " with tstep = " + Integer.toString(delta));
        System.out.println("starting ramp");
        double v = vnow;
        boolean trip0 = this.isTrip();
        this.OKTOTALK = true;
        for (int istep = 0; istep < nsteps + 1; ++istep) {
            System.out.println("V = " + v);
            if (!trip0 && this.isTrip() || this.isAbort()) {
                System.out.println("STOPPING RAMP!!! IT LOOKS LIKE WE CAUSED A TRIP!");
                break;
            }
            if (this.current_OK()) {
                this.setVoltage(v);
            } else {
                System.out.println("driver aborting ramp due to high current!");
                this.setAbort(true);
            }
            try {
                Thread.currentThread();
                Thread.sleep(delta);
            }
            catch (Exception exception) {
                // empty catch block
            }
            v += vstep;
        }
        System.out.println("ramp completed");
    }

    public void rampVolts(double duration, double value) throws DriverException {
        int nsteps = 10;
        this.rampVolts(duration, value, nsteps);
    }

    public double getVoltage() throws DriverException {
        return this.readDoubleKthly("SOUR:VOLT?");
    }

    public void zeroCorrectVoltage() throws DriverException {
        this.writeKthly("SYST:ZCH ON");
        this.writeKthly("SYST:GUAR ON");
        this.writeKthly("FUNC 'VOLT'");
        this.writeKthly("SYST:ZCOR ON");
        this.writeKthly("SYST:ZCH OFF");
    }

    public double readVoltage() throws DriverException {
        if (this.OKTOTALK) {
            this.setArmCount(1);
            this.writeKthly("SYST:ZCH OFF");
            this.writeKthly("FORM:ELEM VSO");
            return this.readDoubleKthly("READ?");
        }
        throw new DriverException("Can't read voltage because buffered read is in progress.");
    }

    public void setCurrentRange(double value) throws DriverException {
        this.writeKthly("FUNC 'CURR'");
        this.writeKthly("RANG " + value);
    }

    public void setCurrent(double value) throws DriverException {
        this.writeKthly("SOUR:CURR " + value);
    }

    public double getCurrent() throws DriverException {
        if (this.OKTOTALK) {
            return this.readDoubleKthly("CURR?");
        }
        throw new DriverException("Can't read set current because buffered read is in progress.");
    }

    public void zeroCorrectCurrent() throws DriverException {
        this.writeKthly("SYST:ZCH ON");
        this.writeKthly("FUNC 'CURR'");
        this.writeKthly("INIT");
        this.writeKthly("SYST:ZCOR:ACQ");
        this.writeKthly("SYST:ZCOR ON");
        this.writeKthly("SYST:ZCH OFF");
    }

    public double readCurrent() throws DriverException {
        if (this.OKTOTALK) {
            this.setArmCount(1);
            this.writeKthly("SYST:ZCH OFF");
            this.writeKthly("FORM:ELEM READ");
            return this.readDoubleKthly("READ?");
        }
        throw new DriverException("Can't read current because buffered read is in progress.");
    }

    public void setVoltageLimit(double maxima) throws DriverException {
        this.writeKthly("SOUR:VOLT:LIM " + maxima);
    }

    public double getVoltageLimit() throws DriverException {
        return this.readDoubleKthly("SOUR:VOLT:LIM?");
    }

    public void setCurrentLimit(double maxima) throws DriverException {
        this.writeKthly("SOUR:VOLT:ILIM " + maxima);
    }

    public double getCurrentLimit() throws DriverException {
        return this.readDoubleKthly("SOUR:VOLT:ILIM?");
    }

    public void setDisplay(boolean dstate) throws DriverException {
        this.writeKthly("DISP:ENAB " + (dstate ? "ON" : "OFF"));
    }

    public void accumBuffer(int nreads, double nplc, boolean wait) throws DriverException {
        this.OKTOTALK = false;
        this.DATAREADY = false;
        this.ACCUM_IN_PROGRESS = false;
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            System.out.println("Cannot sleep because of exception: " + ex);
        }
        this.readIntegerKthly("*OPC?");
        this.writeKthly("TRAC:FEED:CONT NEVER");
        System.out.println("Waited for any previous operations to complete.");
        int eachnreads = nreads;
        if (nreads > 2048) {
            if (wait) {
                System.out.println("Requested nreads over 2048, splitting into two reads of " + (eachnreads /= 2));
            } else {
                eachnreads = 2048;
                System.out.println("Requested nreads over 2048, and wait mode not specified, thus nreads set to " + eachnreads);
            }
        }
        this.setArmCount(1);
        this.setTrigDelay(0);
        this.setTrigCount(eachnreads);
        this.setRate(nplc);
        this.clearStat();
        if (nreads <= 2048) {
            this.setBuffSize(nreads);
        } else {
            this.setBuffSize(eachnreads * 2);
        }
        this.clrBuff();
        this.write("FORM:ELEM READ,TIME");
        this.write("SYST:ZCH OFF");
        this.write("SYST:AZER:STAT OFF");
        this.write("TRAC:TST:FORM ABS");
        this.write("TRAC:FEED SENS");
        this.write("TRAC:FEED:CONT NEXT");
        this.write("STAT:MEAS:ENAB 512");
        this.write("*SRE 1");
        this.read("*OPC?");
        if (wait) {
            if (nreads <= 2048) {
                System.out.format("Sending PD accumulation trigger at %14.3f", (double)System.currentTimeMillis() / 1000.0);
                this.ACCUM_IN_PROGRESS = true;
                this.write("INIT");
            } else {
                System.out.format("Sending first PD accumulation trigger at %14.3f", (double)System.currentTimeMillis() / 1000.0);
                this.ACCUM_IN_PROGRESS = true;
                this.write("INIT");
                System.out.format("Sending second PD accumulation trigger at %14.3f", (double)System.currentTimeMillis() / 1000.0);
                this.write("INIT");
            }
        } else {
            System.out.format("Sending PD accumulation trigger at %14.3f", (double)System.currentTimeMillis() / 1000.0);
            this.ACCUM_IN_PROGRESS = true;
            this.write("INIT");
        }
        this.DATAREADY = true;
    }

    public double[][] readBuffer() throws DriverException {
        int krdy = 0;
        System.out.println("Beginning of readBuffer: DATAREADY = " + this.DATAREADY + " krdy = " + krdy);
        while (!this.DATAREADY || krdy != 1) {
            System.out.println("In loop of readBuffer: DATAREADY = " + this.DATAREADY + " krdy = " + krdy);
            try {
                krdy = this.readIntegerKthly("*OPC?");
            }
            catch (Exception ex) {
                krdy = 0;
            }
            System.out.println("krdy = " + krdy);
            if (this.DATAREADY && krdy == 1) continue;
            System.out.println("sleep for a second then recheck.");
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                System.out.println("Cannot sleep because of exception: " + ex);
            }
            System.out.println("Waiting for data to become available. This is not an expected situation.");
        }
        this.ACCUM_IN_PROGRESS = false;
        this.setRate(1.0);
        this.writeKthly("TRAC:FEED:CONT NEVER");
        int numread = Integer.parseInt(this.read("TRAC:POIN:ACT?"));
        System.out.println("Number of elements read = " + numread);
        System.out.println("About to do double pair array read.");
        System.out.println("Calling read dbl pair array");
        double[][] buff = this.readDoublePairArray("TRAC:DATA?");
        System.out.println("Stop accumulation");
        this.writeKthly("TRAC:FEED:CONT NEVER");
        System.out.println("Reenable display");
        System.out.println("Return buff");
        this.OKTOTALK = true;
        this.DATAREADY = false;
        return buff;
    }

    public static double getMINBIAS() {
        return -75.0;
    }

    public static double getMAXBIAS() {
        return 5.0;
    }

    public void setOKTOTALK(boolean OKTOTALK) {
        this.OKTOTALK = OKTOTALK;
    }

    public boolean isOKTOTALK() {
        return this.OKTOTALK;
    }

    public boolean isDATAREADY() {
        return this.DATAREADY;
    }

    public boolean isACCUM_IN_PROGRESS() {
        return this.ACCUM_IN_PROGRESS;
    }

    public double[][] readDoublePairArray(String command) throws DriverException {
        this.flush();
        try {
            System.out.println("Doing String Array read.");
            String[] reply = this.read(command).split(",");
            System.out.println("Retrieved string of values from buffer. length = " + reply.length);
            double[][] dReply = new double[2][reply.length / 2];
            int ridx = 0;
            for (int j = 0; j < reply.length; j += 2) {
                dReply[0][ridx] = Double.valueOf(reply[j]);
                dReply[1][ridx] = Double.valueOf(reply[j + 1]);
                ++ridx;
            }
            System.out.println("Binary array prepared.");
            this.OKTOTALK = true;
            return dReply;
        }
        catch (NumberFormatException e) {
            throw new DriverException((Throwable)e);
        }
    }

    public void writeKthly(String instr) throws DriverException {
        if (!this.OKTOTALK) {
            System.out.println("writeK:Sending command (" + instr + ") while OKTOTALK = " + this.OKTOTALK);
        }
        this.writeCommand(instr);
    }

    public String readStringKthly(String instr) throws DriverException {
        if (!this.OKTOTALK) {
            System.out.println("readStringK: Sending command (" + instr + ") while OKTOTALK = " + this.OKTOTALK);
        }
        return this.readString(instr);
    }

    private double readDoubleKthly(String instr) throws DriverException {
        if (!this.OKTOTALK) {
            System.out.println("readDblK:Sending command (" + instr + ") while OKTOTALK = " + this.OKTOTALK);
        }
        return this.readDouble(instr);
    }

    private int readIntegerKthly(String instr) throws DriverException {
        if (!this.OKTOTALK) {
            System.out.println("readIK:Sending command (" + instr + ") while OKTOTALK = " + this.OKTOTALK);
        }
        return this.readInteger(instr);
    }
}

