/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ftdi;

import java.io.PrintStream;
import java.util.ArrayList;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.ftdi.Ftdi;

public class TestThreads
extends Thread {
    private static final PrintStream out = System.out;
    private final Ftdi ftd = new Ftdi();
    private int count;
    private final String serial;

    public TestThreads(int count, String serial) {
        this.count = count;
        this.serial = serial;
    }

    @Override
    public void run() {
        while (this.count > 0) {
            try {
                this.ftd.open(0, this.serial);
                this.ftd.close();
            }
            catch (DriverException e) {
                out.println((Object)e);
                this.count = 0;
                break;
            }
            --this.count;
        }
    }

    public boolean isDone() {
        return this.count == 0;
    }

    public static void main(String[] args) {
        ArrayList<TestThreads> threads = new ArrayList<TestThreads>();
        int count = 0;
        if (args.length < 1) {
            out.println("No loop count supplied");
            System.exit(0);
        }
        try {
            count = Integer.valueOf(args[0]);
        }
        catch (NumberFormatException numberFormatException) {
            out.println("Invalid loop count");
            System.exit(0);
        }
        if (args.length < 2) {
            out.println("No serial numbers supplied");
            System.exit(0);
        }
        int j = 1;
        while (j < args.length) {
            TestThreads thread = new TestThreads(count, args[j]);
            threads.add(thread);
            thread.start();
            ++j;
        }
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            boolean done = true;
            for (TestThreads thread : threads) {
                if (thread.isDone()) continue;
                done = false;
            }
            if (!done) continue;
            System.exit(0);
        }
    }
}

