/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.dispatch;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.lsst.ccs.utilities.dispatch.PackCst;

public class SynchronousDispatchProxy<I> {
    protected CopyOnWriteArrayList<Object> list = new CopyOnWriteArrayList();
    protected I proxy;

    public SynchronousDispatchProxy(Class<I> interfaceType) {
        this.proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{interfaceType}, (InvocationHandler)new Invoker());
    }

    public SynchronousDispatchProxy(Class<I> interfaceType, ClassLoader loader) {
        this.proxy = Proxy.newProxyInstance(loader, new Class[]{interfaceType}, (InvocationHandler)new Invoker());
    }

    public <T extends I> void addExecutant(T executant) {
        this.list.add(executant);
    }

    public <T extends I> void removeExecutant(T executant) {
        this.list.remove(executant);
    }

    public I getProxy() {
        return this.proxy;
    }

    class Invoker
    implements InvocationHandler {
        Invoker() {
        }

        @Override
        public Object invoke(Object o, Method method, Object[] parms) {
            for (Object goal : SynchronousDispatchProxy.this.list) {
                try {
                    method.invoke(goal, parms);
                }
                catch (Exception exc) {
                    PackCst.CURLOG.log(Level.SEVERE, "dispatching to " + goal, exc);
                }
            }
            return null;
        }
    }
}

