/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.logging;

import java.util.logging.Level;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.lsst.ccs.utilities.logging.LogManagement;
import org.lsst.ccs.utilities.logging.Logger;

public class JULAppender
extends AppenderSkeleton {
    public JULAppender() {
    }

    public JULAppender(Layout layout) {
        this.setLayout(layout);
    }

    protected void append(LoggingEvent loggingEvent) {
        Logger logger = Logger.getLogger(loggingEvent.getLoggerName());
        if (logger == null) {
            LogManagement.ERROR_MANAGER.error("cannot link log4J code for " + loggingEvent.getLoggerName(), null, 0);
            return;
        }
        String msg = this.layout != null ? this.layout.format(loggingEvent) : loggingEvent.getRenderedMessage();
        String log4jLevelName = loggingEvent.getLevel().toString();
        Levelz levelz = Levelz.valueOf(log4jLevelName);
        ThrowableInformation ti = loggingEvent.getThrowableInformation();
        if (ti == null) {
            logger.logMessage(levelz.getJulLevel(), msg, new String[0]);
        } else {
            logger.logSimpleThrowable(levelz.getJulLevel(), msg, ti.getThrowable(), new String[0]);
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }

    static enum Levelz {
        ALL(Level.ALL),
        DEBUG(Level.FINE),
        ERROR(Level.SEVERE),
        FATAL(Level.SEVERE),
        INFO(Level.INFO),
        OFF(Level.OFF),
        TRACE(Level.FINER),
        WARN(Level.WARNING);

        Level julLevel;

        private Levelz(Level julLevel) {
            this.julLevel = julLevel;
        }

        public Level getJulLevel() {
            return this.julLevel;
        }
    }
}

