/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.keithley;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.keithley.N6517;
import org.lsst.ccs.drivers.scpi.TestScpi;

public class TestN6517
extends TestScpi {
    private N6517 n65 = new N6517();
    private int chanNum = 1;

    public TestN6517() {
        this.scpi = this.n65;
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="host", description="Host name") String host) throws DriverException {
        this.n65.open(host);
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="host", description="Host name") String host, @Argument(name="port", description="Port number") int port) throws DriverException {
        this.n65.open(host, port);
    }

    @Command(name="setvoltagerange", description="Set the voltage range")
    public void setVoltageRange(@Argument(name="value", description="Voltage Range to set") double value) throws DriverException {
        this.n65.setVoltageRange(value);
    }

    @Command(name="setvoltage", description="Set the voltage")
    public void setVoltage(@Argument(name="value", description="Voltage to set") double value) throws DriverException {
        this.n65.setVoltage(value);
    }

    @Command(name="showvoltage", description="Show the set voltage")
    public String getVoltage() throws DriverException {
        return "Voltage = " + this.n65.getVoltage();
    }

    @Command(name="readvoltage", description="Read the actual voltage")
    public String readVoltage() throws DriverException {
        return "Voltage = " + this.n65.readVoltage();
    }

    @Command(name="setvoltlim", description="Set the soft voltage limit")
    public void setVoltageLimit(@Argument(name="value", description="Voltage limit to set") double value) throws DriverException {
        this.n65.setVoltageLimit(value);
    }

    @Command(name="showvoltlim", description="Show the soft voltage limit")
    public String getVoltageLimit() throws DriverException {
        return "Voltage limit = " + this.n65.getVoltageLimit();
    }

    @Command(name="setcurrent", description="Set the current")
    public void setCurrent(@Argument(name="value", description="Current to set") double value) throws DriverException {
        this.n65.setCurrent(value);
    }

    @Command(name="showcurrent", description="Show the set current")
    public String getCurrent() throws DriverException {
        return "Current = " + this.n65.getCurrent();
    }

    @Command(name="readcurrent", description="Read the actual current")
    public String readCurrent() throws DriverException {
        return "Current = " + this.n65.readCurrent();
    }

    @Command(name="setcurrlim", description="Set the soft current limit")
    public void setCurrentLimit(@Argument(name="value", description="Current limit to set") double value) throws DriverException {
        this.n65.setCurrentLimit(value);
    }

    @Command(name="showcurrlim", description="Show the soft current limit")
    public String getCurrentLimit() throws DriverException {
        return "Current limit = " + this.n65.getCurrentLimit();
    }

    @Command(name="setoutput", description="Turn output on or off")
    public void setOutput(@Argument(name="state", description="Output state: on or off") onOff state) throws DriverException {
        this.n65.setOutput(state == onOff.ON);
    }

    @Command(name="showoutput", description="Show the output state")
    public String showOutput() throws DriverException {
        return "Output state = " + this.getOnOff(this.n65.getOutput());
    }

    private StringBuilder getString(double[] values) {
        StringBuilder text = new StringBuilder();
        text.append(values[0]);
        int j = 1;
        while (j < values.length) {
            text.append(", ").append(values[j]);
            ++j;
        }
        return text;
    }

    private String getOnOff(boolean on) {
        return on ? "on" : "off";
    }

    public static enum onOff {
        OFF,
        ON;

    }
}

