/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.keithley;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.Scpi;

public class N6517
extends Scpi {
    public static final int DEFAULT_BAUD = 9600;
    public static final String DEFAULT_DEV = "/dev/ttyUSB0";

    public void open(String devname) throws DriverException {
        this.open(devname, 9600);
        this.writeKthly("ARM:COUN 1");
    }

    public void open() throws DriverException {
        this.open(DEFAULT_DEV, 9600);
        this.writeKthly("ARM:COUN 1");
    }

    public void open(String devname, int port) throws DriverException {
        this.open(2, devname, port);
        this.checkIdentification("KEITHLEY", 1, "MODEL 648", 1);
        this.writeKthly("ARM:COUN 1");
    }

    public void reset() throws DriverException {
        this.writeKthly("RST*");
        this.writeKthly("ARM:COUN 1");
    }

    public void setOutput(boolean on) throws DriverException {
        this.writeKthly("SOUR:VOLT:STAT " + (on ? "ON" : "OFF"));
    }

    public boolean getOutput() throws DriverException {
        return this.readIntegerKthly("SOUR:VOLT:STAT?") != 0;
    }

    public void setVoltageRange(double value) throws DriverException {
        this.writeKthly("SOUR:VOLT:RANG " + value);
    }

    public void setVoltage(double value) throws DriverException {
        this.writeKthly("SOUR:VOLT " + value);
    }

    public double getVoltage() throws DriverException {
        return this.readDoubleKthly("SOUR:VOLT?");
    }

    public void zeroCorrectVoltage() throws DriverException {
        this.writeKthly("SYST:ZCH ON");
        this.writeKthly("SYST:GUAR ON");
        this.writeKthly("FUNC 'VOLT'");
        this.writeKthly("SYST:ZCOR ON");
        this.writeKthly("SYST:ZCH OFF");
    }

    public double readVoltage() throws DriverException {
        this.writeKthly("SYST:ZCH OFF");
        this.writeKthly("FORM:ELEM READ");
        return this.readDoubleKthly("READ?");
    }

    public void setCurrentRange(double value) throws DriverException {
        this.writeKthly("FUNC 'CURR'");
        this.writeKthly("RANG " + value);
    }

    public void setCurrent(double value) throws DriverException {
        this.writeKthly("SOUR:CURR " + value);
    }

    public double getCurrent() throws DriverException {
        return this.readDoubleKthly("CURR?");
    }

    public void zeroCorrectCurrent() throws DriverException {
        this.writeKthly("SYST:ZCH ON");
        this.writeKthly("FUNC 'CURR'");
        this.writeKthly("INIT");
        this.writeKthly("SYST:ZCOR:ACQ");
        this.writeKthly("SYST:ZCOR ON");
        this.writeKthly("SYST:ZCH OFF");
    }

    public double readCurrent() throws DriverException {
        this.writeKthly("SYST:ZCH OFF");
        this.writeKthly("FORM:ELEM READ");
        return this.readDoubleKthly("READ?");
    }

    public void setVoltageLimit(double maxima) throws DriverException {
        this.writeKthly("SOUR:VOLT:LIM " + maxima);
    }

    public double getVoltageLimit() throws DriverException {
        return this.readDoubleKthly("SOUR:VOLT:LIM?");
    }

    public void setCurrentLimit(double maxima) throws DriverException {
        this.writeKthly("SOUR:VOLT:ILIM " + maxima);
    }

    public double getCurrentLimit() throws DriverException {
        return this.readDoubleKthly("SOUR:VOLT:ILIM?");
    }

    private void writeKthly(String instr) throws DriverException {
        this.writeCommand(instr);
    }

    private String readStringKthly(String instr) throws DriverException {
        return this.readString(instr);
    }

    private double readDoubleKthly(String instr) throws DriverException {
        return this.readDouble(instr);
    }

    private int readIntegerKthly(String instr) throws DriverException {
        return this.readInteger(instr);
    }
}

