package org.lsst.ccs.drivers.keithley;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.TestScpi;

/**
 *************************************************************************** 
 ** 
 **  Program to test the Keithley N6517 device driver
 **     (based on Owen Saxton's Agilent driver tester)
 **
 **  @author Homer Neal
 ** 
 *************************************************************************** 
 */
public class TestN6517 extends TestScpi {

    private N6517 n65 = new N6517();
    private int chanNum = 1;

    public enum onOff {
        OFF, ON;
    }


   /**
    *************************************************************************** 
    ** 
    **  Constructor
    ** 
    *************************************************************************** 
    */
    public TestN6517()
    {
        scpi = n65;
    }


   /**
    *************************************************************************** 
    ** 
    **  Opens connection to a device.
    ** 
    *************************************************************************** 
    */
    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="host", description="Host name")
                     String host
                     ) throws DriverException
    {
        n65.open(host);
    }


   /**
    *************************************************************************** 
    ** 
    **  Opens connection to a device.
    ** 
    *************************************************************************** 
    */
    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="host", description="Host name")
                     String host,
                     @Argument(name="port", description="Port number")
                     int port
                     ) throws DriverException
    {
        n65.open(host, port);
    }



   /**
    *************************************************************************** 
    ** 
    **  Sets the voltage range
    ** 
    *************************************************************************** 
    */
    @Command(name="setvoltagerange", description="Set the voltage range")
    public void setVoltageRange(@Argument(name="value", description="Voltage Range to set")
                           double value) throws DriverException
    {
        n65.setVoltageRange(value);
    }


   /**
    *************************************************************************** 
    ** 
    **  Sets the voltage.
    ** 
    *************************************************************************** 
    */
    @Command(name="setvoltage", description="Set the voltage")
    public void setVoltage(@Argument(name="value", description="Voltage to set")
                           double value) throws DriverException
    {
        n65.setVoltage(value);
    }



   /**
    *************************************************************************** 
    ** 
    **  Shows the set voltage.
    ** 
    *************************************************************************** 
    */
    @Command(name="showvoltage", description="Show the set voltage")
    public String getVoltage() throws DriverException
    {
        return "Voltage = " + n65.getVoltage();
    }


   /**
    *************************************************************************** 
    ** 
    **  Reads the actual voltage.
    ** 
    *************************************************************************** 
    */
    @Command(name="readvoltage", description="Read the actual voltage")
    public String readVoltage() throws DriverException
    {
        return "Voltage = " + n65.readVoltage();
    }



   /**
    *************************************************************************** 
    ** 
    **  Sets the soft voltage limit.
    ** 
    *************************************************************************** 
    */
    @Command(name="setvoltlim", description="Set the soft voltage limit")
    public void setVoltageLimit(@Argument(name="value",
                                          description="Voltage limit to set")
                                double value) throws DriverException
    {
        n65.setVoltageLimit(value);
    }




   /**
    *************************************************************************** 
    ** 
    **  Shows the soft voltage limit.
    ** 
    *************************************************************************** 
    */
    @Command(name="showvoltlim", description="Show the soft voltage limit")
    public String getVoltageLimit() throws DriverException
    {
        return "Voltage limit = " + n65.getVoltageLimit();
    }



   /**
    *************************************************************************** 
    ** 
    **  Sets the current.
    ** 
    *************************************************************************** 
    */
    @Command(name="setcurrent", description="Set the current")
    public void setCurrent(@Argument(name="value", description="Current to set")
                           double value) throws DriverException
    {
        n65.setCurrent(value);
    }


   /**
    *************************************************************************** 
    ** 
    **  Shows the set current.
    ** 
    *************************************************************************** 
    */
    @Command(name="showcurrent", description="Show the set current")
    public String getCurrent() throws DriverException
    {
        return "Current = " + n65.getCurrent();
    }


   /**
    *************************************************************************** 
    ** 
    **  Reads the actual current.
    ** 
    *************************************************************************** 
    */
    @Command(name="readcurrent", description="Read the actual current")
    public String readCurrent() throws DriverException
    {
        return "Current = " + n65.readCurrent();
    }



   /**
    *************************************************************************** 
    ** 
    **  Sets the soft current limit.
    ** 
    *************************************************************************** 
    */
    @Command(name="setcurrlim", description="Set the soft current limit")
    public void setCurrentLimit(@Argument(name="value",
                                          description="Current limit to set")
                                double value) throws DriverException
    {
        n65.setCurrentLimit(value);
    }


   /**
    *************************************************************************** 
    ** 
    **  Shows the soft current limit.
    ** 
    *************************************************************************** 
    */
    @Command(name="showcurrlim", description="Show the soft current limit")
    public String getCurrentLimit() throws DriverException
    {
        return "Current limit = " + n65.getCurrentLimit();
    }


   /**
    *************************************************************************** 
    ** 
    **  Turns the output on or off.
    ** 
    *************************************************************************** 
    */
    @Command(name="setoutput", description="Turn output on or off")
    public void setOutput(@Argument(name="state",
                                    description="Output state: on or off")
                          onOff state) throws DriverException
    {
        n65.setOutput(state == onOff.ON);
    }



   /**
    *************************************************************************** 
    ** 
    **  Shows the output state.
    ** 
    *************************************************************************** 
    */
    @Command(name="showoutput", description="Show the output state")
    public String showOutput() throws DriverException
    {
        return "Output state = " + getOnOff(n65.getOutput());
    }

   /**
    *************************************************************************** 
    ** 
    **  Converts an array of numbers to a string.
    ** 
    *************************************************************************** 
    */
    private StringBuilder getString(double[] values)
    {
        StringBuilder text = new StringBuilder();
        text.append(values[0]);
        for (int j = 1; j < values.length; j++) {
            text.append(", ").append(values[j]);
        }

        return text;
    }


   /**
    *************************************************************************** 
    ** 
    **  Converts a boolean to on/off.
    ** 
    *************************************************************************** 
    */
    private String getOnOff(boolean on)
    {
        return on ? "on" : "off";
    }

}
