/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.keithley;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.Scpi;

public class N6487
extends Scpi {
    public static final int DEFAULT_BAUD = 19200;
    public static final String DEFAULT_DEV = "/dev/ttyUSB0";

    public void open(String devname) throws DriverException {
        this.open(devname, 19200);
        this.writeKthly("ARM:COUN 1");
    }

    public void open() throws DriverException {
        this.open(DEFAULT_DEV, 19200);
        this.writeKthly("ARM:COUN 1");
    }

    public void open(String devname, int port) throws DriverException {
        this.open(2, devname, port);
        this.checkIdentification("KEITHLEY", 1, "MODEL 648", 1);
        this.writeKthly("ARM:COUN 1");
    }

    public void openftdi(String serialname, int port) throws DriverException {
        this.open(1, serialname, port);
        this.checkIdentification("KEITHLEY", 1, "MODEL 648", 1);
        this.writeKthly("ARM:COUN 1");
    }

    public String printdevid() throws DriverException {
        String[] id = this.getIdentification();
        return "Successfully connected to:\nManufacturer:   " + id[0] + "\nModel name:     " + id[1] + "\nSerial number:  " + id[2] + "\nF/W version:    " + id[3];
    }

    @Override
    public void reset() throws DriverException {
        this.writeKthly("*RST");
        this.writeKthly("ARM:COUN 1");
    }

    public void setOutput(boolean on) throws DriverException {
        this.writeKthly("SOUR:VOLT:STAT " + (on ? "ON" : "OFF"));
    }

    public boolean getOutput() throws DriverException {
        return this.readIntegerKthly("SOUR:VOLT:STAT?") != 0;
    }

    public void setRate(int value) throws DriverException {
        this.writeKthly("CURR:NPLC " + value);
    }

    public void setArmCount(int value) throws DriverException {
        this.writeKthly("ARM:COUN " + value);
    }

    public void setTrigCount(int value) throws DriverException {
        this.writeKthly("TRIG:COUN " + value);
    }

    public void setBuffSize(int value) throws DriverException {
        this.writeKthly("TRAC:POIN " + value);
    }

    public void clrBuff() throws DriverException {
        this.writeKthly("TRAC:CLE");
    }

    public void setVoltageRange(double value) throws DriverException {
        this.writeKthly("SOUR:VOLT:RANG " + value);
    }

    public void setVoltage(double value) throws DriverException {
        this.writeKthly("SOUR:VOLT " + value);
    }

    public void rampVolts(double duration, double value) throws DriverException {
        double nsteps = 10.0;
        double vnow = this.readVoltage();
        this.writeKthly("SOUR:VOLT " + value);
        this.writeKthly("SOUR:VOLT:SWE:STAR " + vnow);
        this.writeKthly("SOUR:VOLT:SWE:STOP " + value);
        double vstep = (vnow - value) / nsteps;
        this.writeKthly("SOUR:VOLT:SWE:STEP " + vstep);
        double delta = duration / nsteps;
        this.writeKthly("SOUR:VOLT:SWE:DEL " + delta);
        this.writeKthly("SOUR:VOLT:SWE:INIT");
        this.writeKthly("SYST:ZCH OFF");
        System.out.println("starting ramp from " + Double.toString(vnow) + " to " + Double.toString(value) + " with vstep = " + Double.toString(vstep) + " with tstep = " + Double.toString(delta));
        this.writeKthly("INIT");
    }

    public double getVoltage() throws DriverException {
        return this.readDoubleKthly("SOUR:VOLT?");
    }

    public void zeroCorrectVoltage() throws DriverException {
        this.writeKthly("SYST:ZCH ON");
        this.writeKthly("SYST:GUAR ON");
        this.writeKthly("FUNC 'VOLT'");
        this.writeKthly("SYST:ZCOR ON");
        this.writeKthly("SYST:ZCH OFF");
    }

    public double readVoltage() throws DriverException {
        this.setArmCount(1);
        this.writeKthly("SYST:ZCH OFF");
        this.writeKthly("FORM:ELEM VSO");
        return this.readDoubleKthly("READ?");
    }

    public void setCurrentRange(double value) throws DriverException {
        this.writeKthly("FUNC 'CURR'");
        this.writeKthly("RANG " + value);
    }

    public void setCurrent(double value) throws DriverException {
        this.writeKthly("SOUR:CURR " + value);
    }

    public double getCurrent() throws DriverException {
        return this.readDoubleKthly("CURR?");
    }

    public void zeroCorrectCurrent() throws DriverException {
        this.writeKthly("SYST:ZCH ON");
        this.writeKthly("FUNC 'CURR'");
        this.writeKthly("INIT");
        this.writeKthly("SYST:ZCOR:ACQ");
        this.writeKthly("SYST:ZCOR ON");
        this.writeKthly("SYST:ZCH OFF");
    }

    public double readCurrent() throws DriverException {
        this.setArmCount(1);
        this.writeKthly("SYST:ZCH OFF");
        this.writeKthly("FORM:ELEM READ");
        return this.readDoubleKthly("READ?");
    }

    public void setVoltageLimit(double maxima) throws DriverException {
        this.writeKthly("SOUR:VOLT:LIM " + maxima);
    }

    public double getVoltageLimit() throws DriverException {
        return this.readDoubleKthly("SOUR:VOLT:LIM?");
    }

    public void setCurrentLimit(double maxima) throws DriverException {
        this.writeKthly("SOUR:VOLT:ILIM " + maxima);
    }

    public double getCurrentLimit() throws DriverException {
        return this.readDoubleKthly("SOUR:VOLT:ILIM?");
    }

    public double[] readBuffer() throws DriverException {
        this.writeKthly("TRAC:FEED:CONT NEVER");
        this.writeKthly("FORM:ELEM READ");
        this.writeKthly("TRAC:FEED SENS");
        this.writeKthly("TRAC:FEED:CONT NEXT");
        this.writeKthly("SYST:ZCH OFF");
        this.writeKthly("INIT");
        double[] buff = this.readDoubleArray("TRAC:DATA?");
        this.writeKthly("TRAC:FEED:CONT NEVER");
        return buff;
    }

    private void writeKthly(String instr) throws DriverException {
        this.writeCommand(instr);
    }

    private String readStringKthly(String instr) throws DriverException {
        return this.readString(instr);
    }

    private double readDoubleKthly(String instr) throws DriverException {
        return this.readDouble(instr);
    }

    private int readIntegerKthly(String instr) throws DriverException {
        return this.readInteger(instr);
    }
}

