/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.iocard;

import org.lsst.ccs.drivers.iocard.HeliosException;
import org.lsst.ccs.drivers.iocard.Iocard;

public final class Helios
extends Iocard {
    public static final int N_REGS = 16;
    public static final int N_AD_CHANS = 16;
    public static final int N_DA_CHANS = 4;
    public static final int CMND_REG = 0;
    public static final int CMND_CLEAR_AINT = 1;
    public static final int CMND_CLEAR_DINT = 2;
    public static final int CMND_CLEAR_TINT = 4;
    public static final int CMND_CLEAR_INTS = 7;
    public static final int CMND_RESET_FIFO = 16;
    public static final int CMND_RESET_DA = 32;
    public static final int CMND_RESET_BOARD = 64;
    public static final int CMND_START_AD = 128;
    public static final int AD_FIFO_REG = 0;
    public static final int PAGE_REG = 1;
    public static final int AD_CHAN_REG = 2;
    public static final int AD_STAT_REG = 3;
    public static final int AD_GAIN_MASK = 3;
    public static final int AD_SCAN_ENAB = 4;
    public static final int AD_FIFO_OF = 8;
    public static final int DAC_BUSY = 16;
    public static final int AD_WAIT = 32;
    public static final int AD_SING_END = 64;
    public static final int AD_BUSY = 128;
    public static final int INT_CTL_REG = 4;
    public static final int ENAB_AINT = 1;
    public static final int ENAB_DINT = 2;
    public static final int ENAB_TINT = 4;
    public static final int ENAB_INTS = 7;
    public static final int AD_EXT_TRIG = 16;
    public static final int CNTR0_USE_LOW = 32;
    public static final int CNTR1_USE_LOW = 64;
    public static final int CNTR1_EXT_CLOCK = 128;
    public static final int FIFO_THR_REG = 5;
    public static final int DA_OUTP_REG = 6;
    public static final int FIFO_STS_REG = 6;
    public static final int FIFO_EMPTY = 1;
    public static final int FIFO_HALF_FULL = 2;
    public static final int FIFO_FULL = 4;
    public static final int FIFO_OVERFLOW = 8;
    public static final int FIFO_MSB_MASK = 240;
    public static final int INTAD_STS_REG = 7;
    public static final int AD_CHAN_MASK = 15;
    public static final int PEND_AINT = 16;
    public static final int PEND_DINT = 32;
    public static final int PEND_TINT = 64;
    public static final int PEND_INTS = 112;
    public static final int PORTA_REG = 8;
    public static final int PORTB_REG = 9;
    public static final int PORTC_REG = 10;
    public static final int DIODA_CTL_REG = 11;
    public static final int DIO_INPUT_CL = 1;
    public static final int DIO_INPUT_B = 2;
    public static final int DIO_INPUT_CH = 8;
    public static final int DIO_INPUT_A = 16;
    public static final int DIO_CONF_MASK = 27;
    public static final int DA_SIM_UPDATE = 32;
    public static final int DA_HIGH_RES = 64;
    public static final int DIO_COUNTER = 128;
    public static final int CNTR_VAL_REG = 12;
    public static final int CNTR_CTL_REG = 15;
    public static final int CNTR_CLEAR = 1;
    public static final int CNTR_LOAD = 2;
    public static final int CNTR_ENABLE = 4;
    public static final int CNTR_DISABLE = 8;
    public static final int CNTR_GATE_ENAB = 16;
    public static final int CNTR_GATE_DISA = 32;
    public static final int CNTR_LATCH = 64;
    public static final int CNTR_ONE = 128;
    public static final int FPGA_REV_REG = 15;
    public static final int EXP_FIFO_REG = 12;
    public static final int FIFO_ENHANCED = 1;
    public static final int AD_MODE_REG = 13;
    public static final int AD_DIFF = 2;
    public static final int AD_UNIPOLAR = 8;
    public static final int DA_MODE_REG = 14;
    public static final int DA_RANGE_MASK = 3;
    public static final int DA_BIPOLAR = 8;
    public static final int DA_CHAN_MASK = 48;
    public static final int DA_UNIQUE_RNG = 128;
    public static final int DA_HIGH_RES_HW = 16;
    public static final int DA_MSB_REG = 15;
    public static final int DA_SIMUPD_REG = 15;
    public static final int CNTR0_LOW_FREQ = 1000000;
    public static final int CNTR1_LOW_FREQ = 100000;
    public static final int CNTR_HIGH_FREQ = 10000000;
    public static final int CLK_HIGH_FREQ = 0;
    public static final int CLK_LOW_FREQ = 1;
    public static final int CLK_EXTERNAL = 2;
    private static final int AD_MAX_LOOP = 100;
    private static final int CNTR_INT_ID = 1;
    private static final int DIO_INT_ID = 2;
    private static String INV_DIO_PORT = "Invalid DIO port number";
    private static String INV_AD_CHAN = "Invalid A/D channel number";
    private static String INV_AD_GAIN = "Invalid A/D channel gain";
    private static String AD_READY_TMO = "A/D ready timeout";
    private static String AD_CONV_TMO = "A/D conversion timeout";
    private static String INV_DA_CHAN = "Invalid D/A channel number";
    private static String INV_DA_GAIN = "Invalid D/A channel gain";
    private static String INV_DA_GPOL = "Invalid D/A channel gain/polarity";
    private static String HI_RES_UNAVL = "16-bit resolution not available";
    private static String DA_GAIN_UNKN = "Gain not set for D/A channel";
    private static String INV_FREQUENCY = "Invalid frequency";
    private static String INV_COUNT = "Invalid counter value";
    private static String INV_CLOCK = "Invalid clock specifier";
    private int[] daGain = new int[]{-1, -1, -1, -1};

    public Helios(int base, int irq) {
        super.init(base, 16, irq);
    }

    public Helios() {
    }

    public void init(int base, int irq) {
        super.init(base, 16, irq);
    }

    public void dioConfig(int value) {
        this.updateB(11, 27, value & 0xA | value << 4 & 0x10 | value >> 2 & 1);
    }

    public int dioGetConfig() {
        int value = this.readB(11);
        return value & 0xA | value >> 4 & 1 | value << 2 & 4;
    }

    public int dioInp(int port) {
        if (port < 0 || port > 2) {
            throw new HeliosException(INV_DIO_PORT);
        }
        return this.readB(8 + port);
    }

    public void dioOut(int port, int value) {
        if (port < 0 || port > 2) {
            throw new HeliosException(INV_DIO_PORT);
        }
        this.writeB(8 + port, value);
    }

    public int dioInpBit(int port, int bit) {
        if (port < 0 || port > 2) {
            throw new HeliosException(INV_DIO_PORT);
        }
        return this.readB(8 + port) >> bit & 1;
    }

    public void dioOutBit(int port, int bit, int value) {
        if (port < 0 || port > 2) {
            throw new HeliosException(INV_DIO_PORT);
        }
        this.updateB(8 + port, 1 << bit, value << bit);
    }

    public void dioSetBit(int port, int bit) {
        if (port < 0 || port > 2) {
            throw new HeliosException(INV_DIO_PORT);
        }
        int value = 1 << bit;
        this.updateB(8 + port, value, value);
    }

    public void dioClrBit(int port, int bit) {
        if (port < 0 || port > 2) {
            throw new HeliosException(INV_DIO_PORT);
        }
        this.updateB(8 + port, 1 << bit, 0);
    }

    public void adConfig(int gain, boolean unip, boolean diff) {
        if (gain < 0 || gain > 3) {
            throw new HeliosException(INV_AD_GAIN);
        }
        this.updateB(3, 3, gain);
        this.writeB(1, 2);
        this.writeB(13, (unip ? 8 : 0) | (diff ? 2 : 0));
    }

    public int adGetGain() {
        return this.readB(3) & 3;
    }

    public boolean adIsUnipolar() {
        this.writeB(1, 2);
        return (this.readB(13) & 8) != 0;
    }

    public boolean adIsDifferential() {
        this.writeB(1, 2);
        return (this.readB(13) & 2) != 0;
    }

    public void adSetChans(int lowChan, int highChan) {
        if (lowChan < 0 || lowChan >= 16 || highChan < 0 || highChan >= 16) {
            throw new HeliosException(INV_AD_CHAN);
        }
        this.writeB(2, lowChan | highChan << 4);
    }

    public void adSetChan(int chan) {
        this.adSetChans(chan, chan);
    }

    public int[] adGetChans() {
        int value = this.readB(2);
        int[] chans = new int[]{value & 0xF, value >> 4};
        return chans;
    }

    public int adGetCurrChan() {
        return this.readB(7) & 0xF;
    }

    public short adSample() {
        int j;
        int status = 1;
        this.updateB(3, 4, 0);
        for (j = 0; j < 100 && (status = this.readB(3) & 0x20) != 0; ++j) {
        }
        if (status != 0) {
            throw new HeliosException(AD_READY_TMO);
        }
        this.writeB(0, 144);
        for (j = 0; j < 100 && (status = this.readB(3) & 0x80) != 0; ++j) {
        }
        if (status != 0) {
            throw new HeliosException(AD_CONV_TMO);
        }
        return (short)this.readW(0);
    }

    public int adScan(short[] data) {
        int count;
        int j;
        int status = 1;
        this.updateB(3, 4, 4);
        for (j = 0; j < 100 && (status = this.readB(3) & 0x20) != 0; ++j) {
        }
        if (status != 0) {
            throw new HeliosException(AD_READY_TMO);
        }
        this.writeB(0, 144);
        for (j = 0; j < 100 && (status = this.readB(3) & 0x80) != 0; ++j) {
        }
        if (status != 0) {
            throw new HeliosException(AD_CONV_TMO);
        }
        int depth = this.readB(6);
        for (count = 0; count < depth; ++count) {
            data[count] = (short)this.readW(0);
        }
        return count;
    }

    public float adCountToVolts(short count) {
        this.writeB(1, 2);
        boolean unip = (this.readB(13) & 8) != 0;
        int gain = this.readB(3) & 3;
        if (unip) {
            return 1.5258789E-4f / (float)(1 << gain) * (float)(count + 32768);
        }
        return 3.0517578E-4f / (float)(1 << gain) * (float)count;
    }

    public short adVoltsToCount(float volts) {
        this.writeB(1, 2);
        boolean unip = (this.readB(13) & 8) != 0;
        int gain = this.readB(3) & 3;
        int count = unip ? (int)((float)(1 << gain) * 6553.6f * volts) - 32768 : (int)((float)(1 << gain) * 3276.8f * volts);
        if (count > Short.MAX_VALUE) {
            count = Short.MAX_VALUE;
        } else if (count < Short.MIN_VALUE) {
            count = Short.MIN_VALUE;
        }
        return (short)count;
    }

    public void daConfig(int gain, boolean uniPol, boolean simUpd, boolean hiRes) {
        if (gain < 0 || gain > 2) {
            throw new HeliosException(INV_DA_GAIN);
        }
        if (uniPol && gain == 2) {
            throw new HeliosException(INV_DA_GPOL);
        }
        this.writeB(1, 2);
        this.writeB(14, gain | (uniPol ? 0 : 8));
        this.updateB(11, 96, (simUpd ? 32 : 0) | (hiRes ? 64 : 0));
        for (int j = 0; j < 4; ++j) {
            this.daGain[j] = gain;
        }
    }

    public void daSetGain(int chan, int gain) {
        if (chan < -1 || chan >= 4) {
            throw new HeliosException(INV_DA_CHAN);
        }
        if (gain < 0 || gain > 2) {
            throw new HeliosException(INV_DA_GAIN);
        }
        this.writeB(1, 2);
        int bipolar = this.readB(14) & 8;
        if (gain == 2 && bipolar == 0) {
            throw new HeliosException(INV_DA_GPOL);
        }
        this.writeB(14, bipolar | gain | (chan >= 0 ? 0x80 | chan << 4 : 0));
        if (chan >= 0) {
            this.daGain[chan] = gain;
        } else {
            for (int j = 0; j < 4; ++j) {
                this.daGain[j] = gain;
            }
        }
    }

    public int daGetGain(int chan) {
        if (chan < -1 || chan >= 4) {
            throw new HeliosException(INV_DA_CHAN);
        }
        if (chan >= 0) {
            return this.daGain[chan];
        }
        int gain = this.daGain[0];
        for (int j = 1; j < 4; ++j) {
            if (gain == this.daGain[j]) continue;
            return -1;
        }
        return gain;
    }

    public boolean daIsUnipolar() {
        this.writeB(1, 2);
        return (this.readB(14) & 8) == 0;
    }

    public boolean daIsSimUpdate() {
        return (this.readB(11) & 0x20) != 0;
    }

    public boolean daIsHighRes() {
        return (this.readB(11) & 0x40) != 0;
    }

    public boolean daIsHighResHW() {
        this.writeB(1, 2);
        return (this.readB(14) & 0x10) != 0;
    }

    public void daOutput(int chan, int code) {
        if (chan < 0 || chan >= 4) {
            throw new HeliosException(INV_DA_CHAN);
        }
        if ((this.readB(11) & 0x40) != 0) {
            this.writeB(1, 2);
            this.writeB(15, code >> 8);
            this.writeW(6, code & 0xFF | chan << 14);
        } else {
            this.writeW(6, code & 0xFFF | chan << 14);
        }
    }

    public void daUpdate() {
        this.writeB(1, 2);
        this.readB(15);
    }

    public int daVoltsToCode(int chan, float volts) {
        if (chan < 0 || chan >= 4) {
            throw new HeliosException(INV_DA_CHAN);
        }
        int gain = this.daGain[chan];
        if (gain < 0) {
            throw new HeliosException(DA_GAIN_UNKN);
        }
        float range = 5.0f * (float)(1 << gain);
        int resol = (this.readB(11) & 0x40) != 0 ? 32768 : 2048;
        int code = (int)((float)(2 * resol) * volts / range);
        this.writeB(1, 2);
        if ((this.readB(14) & 8) != 0) {
            code += resol;
        }
        if (code >= 2 * resol) {
            code = 2 * resol - 1;
        } else if (code < 0) {
            code = 0;
        }
        return code;
    }

    public float daCodeToVolts(int chan, int code) {
        if (chan < 0 || chan >= 4) {
            throw new HeliosException(INV_DA_CHAN);
        }
        int gain = this.daGain[chan];
        if (gain < 0) {
            throw new HeliosException(DA_GAIN_UNKN);
        }
        float range = 5.0f * (float)(1 << gain);
        int resol = (this.readB(11) & 0x40) != 0 ? 32768 : 2048;
        this.writeB(1, 2);
        if ((this.readB(14) & 8) != 0) {
            code -= resol;
        }
        return range * (float)code / (float)(2 * resol);
    }

    public void cntrConfig(float freq, boolean gated) {
        int clock = 0;
        int count = (int)(1.0E7f / freq);
        if (count >= 65536) {
            count = (int)(100000.0f / freq);
            clock = 1;
        }
        if (count < 2 || count >= 65536) {
            throw new HeliosException(INV_FREQUENCY);
        }
        this.cntrConfig(count, clock, gated);
    }

    public void cntrConfig(int count, int clock, boolean gated) {
        if (count < 2 || count >= 65536) {
            throw new HeliosException(INV_COUNT);
        }
        if (clock < 0 || clock > 2) {
            throw new HeliosException(INV_CLOCK);
        }
        int value = 0;
        if (clock == 2) {
            value = 128;
        } else if (clock == 1) {
            value = 64;
        }
        this.updateB(4, 192, value);
        if (clock == 2 || gated) {
            this.updateB(11, 128, 128);
        }
        this.writeB(1, 0);
        this.writeW(12, count);
        this.writeB(15, 130);
        if (gated) {
            this.writeB(15, 144);
        } else {
            this.writeB(15, 160);
        }
    }

    public void cntrStart() {
        this.writeB(1, 0);
        this.writeB(15, 132);
    }

    public void cntrStop() {
        this.writeB(1, 0);
        this.writeB(15, 136);
    }

    public void cntrClear() {
        this.writeB(1, 0);
        this.writeB(15, 129);
    }

    public int cntrRead() {
        this.writeB(1, 0);
        this.writeB(15, 192);
        return this.readW(12);
    }

    public void cntrEnable(Object cbObj, String cbMeth, Object cbParm) {
        super.attachInt(1, 3, 7, 64, 0, 4, 0, cbObj, cbMeth, cbParm);
        this.updateB(4, 4, 4);
    }

    public void cntrDisable() {
        this.updateB(4, 4, 0);
        super.detachInt(1);
    }
}

