/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.iocard.utility;

import java.time.Instant;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import org.lsst.ccs.drivers.iocard.AccesDio;

public final class MonitorDIO {
    private final AccesDio dioCard;
    private int oldA = 0;
    private int oldB = 0;
    private int oldC = 0;
    private final BlockingQueue<RegisterData> dataQueue = new LinkedTransferQueue<RegisterData>();

    private MonitorDIO() {
        this.dioCard = new AccesDio(-1, -1);
    }

    public void logStateChange(int regA, int regB, int regC) {
        String current = String.format("A %02x B %02x C %02x", regA, regB, regC);
        String changes = String.format("A %02x B %02x C %02x", regA ^ this.oldA, regB ^ this.oldB, regC ^ this.oldC);
        System.out.format("State at %s %s changes %s%n", Instant.now(), current, changes);
        this.oldA = regA;
        this.oldB = regB;
        this.oldC = regC;
    }

    private void stateChangeListener(int dummy1, Object dummy2) {
        this.dataQueue.add(new RegisterData(this.dioCard.dioInp(0), this.dioCard.dioInp(1), this.dioCard.dioInp(0), false));
    }

    public void attachToDIO() {
        this.dioCard.dioConfig(15);
        this.oldA = this.dioCard.dioInp(0);
        this.oldB = this.dioCard.dioInp(1);
        this.oldC = this.dioCard.dioInp(2);
        this.dioCard.attachInt(7, this, "stateChangeListener", null);
        System.err.format("Configuration reg = %02x%n", this.dioCard.readB(3));
    }

    public void detachFromDIO() {
        this.dioCard.detachInt();
    }

    public BlockingQueue<RegisterData> getDataQueue() {
        return this.dataQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        final MonitorDIO monitor = new MonitorDIO();
        monitor.attachToDIO();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                monitor.getDataQueue().add(new RegisterData(0, 0, 0, true));
                try {
                    MonitorDIO monitorDIO = monitor;
                    synchronized (monitorDIO) {
                        monitor.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        System.err.println("Ready.");
        try {
            while (true) {
                RegisterData data = monitor.getDataQueue().take();
                if (data.poison) {
                    break;
                }
                monitor.logStateChange(data.a, data.b, data.c);
            }
        }
        catch (InterruptedException interruptedException) {
            monitor.detachFromDIO();
            System.err.println("\nDone.");
            MonitorDIO monitorDIO = monitor;
            synchronized (monitorDIO) {
                monitor.notifyAll();
            }
        }
        finally {
            monitor.detachFromDIO();
            System.err.println("\nDone.");
            MonitorDIO monitorDIO = monitor;
            synchronized (monitorDIO) {
                monitor.notifyAll();
            }
        }
    }

    private static final class RegisterData {
        public final int a;
        public final int b;
        public final int c;
        public final boolean poison;

        public RegisterData(int a, int b, int c, boolean poison) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.poison = poison;
        }
    }
}

