/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.iocard;

import org.lsst.ccs.drivers.iocard.Helios;
import org.lsst.ccs.drivers.iocard.TestIocard;
import org.lsst.ccs.utilities.sa.CmndProcess;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestHelios
implements CmndProcess.Dispatch {
    private static final int CMD_INIT = 0;
    private static final int CMD_SHOW = 1;
    private static final int CMD_REGSHOW = 2;
    private static final int CMD_DIOCONFIG = 3;
    private static final int CMD_DIOIN = 4;
    private static final int CMD_DIOOUT = 5;
    private static final int CMD_DIOINBIT = 6;
    private static final int CMD_DIOOUTBIT = 7;
    private static final int CMD_DIOSETBIT = 8;
    private static final int CMD_DIOCLRBIT = 9;
    private static final int CMD_DIOSHOW = 10;
    private static final int CMD_ADCONFIG = 11;
    private static final int CMD_ADSETCHAN = 12;
    private static final int CMD_ADSAMPLE = 13;
    private static final int CMD_ADSCAN = 14;
    private static final int CMD_ADCTOV = 15;
    private static final int CMD_ADVTOC = 16;
    private static final int CMD_ADSHOW = 17;
    private static final int CMD_DACONFIG = 18;
    private static final int CMD_DASETGAIN = 19;
    private static final int CMD_DAOUTPUT = 20;
    private static final int CMD_DAUPDATE = 21;
    private static final int CMD_DAVTOC = 22;
    private static final int CMD_DACTOV = 23;
    private static final int CMD_DASHOW = 24;
    private static final int CMD_INTATTACH = 25;
    private static final int CMD_INTDETACH = 26;
    private static final int CMD_CNTRSTART = 27;
    private static final int CMD_CNTRSTOP = 28;
    private static final int CMD_CNTRSHOW = 29;
    private static final int NUM_CMDS = 30;
    private static final String[] helpInit = new String[]{"Initialize Helios card", "init <addr> <irq>", "addr   The base address of the card (initially 0x340)", "irq    The IRQ level of the card (initially 6)"};
    private static final String[] helpShow = new String[]{"Show initialization parameters", "show"};
    private static final String[] helpRegshow = new String[]{"Show register contents", "regshow"};
    private static final String[] helpDioconfig = new String[]{"Set digital I/O parameters", "dioconfig <value>", "value    The value to set"};
    private static final String[] helpDioin = new String[]{"Read and display a byte from a digital I/O port", "dioin <port>", "port    The digital I/O port to read"};
    private static final String[] helpDioout = new String[]{"Write a byte to a digital I/O port", "dioout <port> <value>", "port    The digital I/O port to write to", "value   The value to write"};
    private static final String[] helpDioinbit = new String[]{"Read and display a bit from a digital I/O port", "dioinbit <port> <bitnum>", "port    The digital I/O port to read", "bitnum  The number of the bit to read"};
    private static final String[] helpDiooutbit = new String[]{"Write a bit to a digital I/O port", "diooutbit <port> <bitnum> <value>", "port    The digital I/O port to write to", "bitnum  The number of the bit to write", "value   The value to set the bit to"};
    private static final String[] helpDiosetbit = new String[]{"Set a bit in a digital I/O port", "diosetbit <port> <bitnum>", "port    The digital I/O port to write to", "bitnum  The number of the bit to set"};
    private static final String[] helpDioclrbit = new String[]{"Clear a bit in a digital I/O port", "dioclrbit <port> <bitnum>", "port    The digital I/O port to write to", "bitnum  The number of the bit to clear"};
    private static final String[] helpDioshow = new String[]{"Show the current digital I/O parameters", "dioshow"};
    private static final String[] helpAdconfig = new String[]{"Set the A/D configuration", "adconfig <gain> <polarity> <input>", "gain      The gain setting to use (0 - 3)", "polarity  The polarity: 0 = bipolar; 1 = unipolar", "input     The input type: single-ended = 0; differential = 1"};
    private static final String[] helpAdsetchan = new String[]{"Set the A/D channel range to use in samples and scans", "adsetchan <low> <high>", "low   The low (first) channel to use (0 - 15)", "high  The high (last) channel to use (0 - 15)"};
    private static final String[] helpAdsample = new String[]{"Sample and display the current A/D channel value", "adsample"};
    private static final String[] helpAdscan = new String[]{"Scan and display the current range of A/D channel value", "adscan"};
    private static final String[] helpAdctov = new String[]{"Convert an A/D count to a voltage", "adctov <count>", "count  The A/D count to convert"};
    private static final String[] helpAdvtoc = new String[]{"Convert a voltage to an A/D count", "advtoc <voltage>", "voltage  The voltage to convert"};
    private static final String[] helpAdshow = new String[]{"Show the current A/D parameters", "adshow"};
    private static final String[] helpDaconfig = new String[]{"Set the D/A configuration", "daconfig <gain> <polarity> <update> <resoln>", "gain      The gain setting to use (0 - 3)", "polarity  The polarity: 0 = bipolar; 1 = unipolar", "update    The update type: individual = 0; simultaneous = 1", "resoln    The resolution: 12-bit = 0; 16-bit = 1"};
    private static final String[] helpDasetgain = new String[]{"Set the D/A gain for a channel", "dasetgain <chan> <gain>", "chan  The channel to use (0 - 3)", "gain  The gain to set (0 - 3)"};
    private static final String[] helpDaoutput = new String[]{"Output a code value to a D/A channel", "daoutput <chan> <code>", "chan  The channel to use (0 - 3)", "code  The code value to output"};
    private static final String[] helpDaupdate = new String[]{"Update all the D/A output values (simultaneous updating mode)", "daupdate"};
    private static final String[] helpDavtoc = new String[]{"Convert a voltage to a D/A code", "davtoc <voltage>", "voltage  The voltage to convert"};
    private static final String[] helpDactov = new String[]{"Convert a D/A code to a voltage", "dactov <code>", "code  The D/A code to convert"};
    private static final String[] helpDashow = new String[]{"Show the current D/A parameters", "dashow"};
    private static final String[] helpIntattach = new String[]{"Attach to interrupt processing", "intattach <tmask>", "tmask  A bit mask of interrupt types (1 = AD, 2 = DIO, 4 = CNTR)"};
    private static final String[] helpIntdetach = new String[]{"Detach from interrupt processing", "intdetach"};
    private static final String[] helpCntrstart = new String[]{"Start generating counter interrupts", "cntrstart <rate>", "rate  The rate of interrupt generation (number / second)"};
    private static final String[] helpCntrstop = new String[]{"Stop generating counter interrupts", "cntrstop"};
    private static final String[] helpCntrshow = new String[]{"Show generated counter statistics", "cntrshow <optns>", "optns  Display option bits: 1 = intervals, 2 = counts, 4 = combined"};
    private static final CmndProcess.Command cmnd = new CmndProcess.Command(30);
    private static final int BASE_ADDR = 640;
    private static final int IRQ_LEVEL = 5;
    private static final int MAX_CNTR_SAVED = 64;
    private final Output out;
    private final Helios hel;
    private final CmndProcess proc;
    private final TestIocard tioc;
    private int baseAddr = 640;
    private int irqLevel = 5;
    private int dioPort = 0;
    private int dioConf = 0;
    private int dioValue = 0;
    private int dioBit = 0;
    private int adGain = 0;
    private int adLowChan = 0;
    private int adHighChan = 0;
    private boolean adUnip = false;
    private boolean adDiff = false;
    private int daChan = 0;
    private int daGain = 0;
    private int daCode = 0;
    private boolean daUnip = false;
    private boolean daSimUp = false;
    private boolean daHiRes = false;
    private int intMask = 7;
    private long cntrStart = 0L;
    private long cntrStop = 0L;
    private long cntrLast = 0L;
    private long cntrSavst = 0L;
    private long[] cntrTimes = new long[64];
    private int cntrCount = 0;
    private int cntrSaved = 0;
    private int[] cntrCounts = new int[64];
    private float cntrRate = 100.0f;
    private static final String[] regDesc;
    private static final String[] pageDesc;

    private TestHelios(Output out, CmndProcess proc, TestIocard tioc, Helios hel) {
        this.out = out;
        this.proc = proc;
        this.tioc = tioc;
        this.hel = hel;
    }

    public static TestHelios newInstance(Output out) {
        Output lout = out != null ? out : new ConsOut();
        Helios hel = new Helios();
        CmndProcess proc = new CmndProcess();
        TestIocard tioc = TestIocard.newInstance(hel, proc, out);
        TestHelios obj = new TestHelios(lout, proc, tioc, hel);
        return obj;
    }

    public void addAsDispatcher() {
        this.proc.add((CmndProcess.Dispatch)this, cmnd);
        this.tioc.addAsDispatcher();
    }

    public static void main(String[] args) {
        TestHelios thel = TestHelios.newInstance(null);
        thel.addAsDispatcher();
        thel.tioc.run();
        System.exit(0);
    }

    public boolean dispatch(int code, int found, Object[] args) {
        switch (code) {
            case 0: {
                this.procInit(found, args);
                break;
            }
            case 1: {
                this.procShow(found, args);
                break;
            }
            case 2: {
                this.procRegshow(found, args);
                break;
            }
            case 3: {
                this.procDioconfig(found, args);
                break;
            }
            case 4: {
                this.procDioin(found, args);
                break;
            }
            case 5: {
                this.procDioout(found, args);
                break;
            }
            case 6: {
                this.procDioinbit(found, args);
                break;
            }
            case 7: {
                this.procDiooutbit(found, args);
                break;
            }
            case 8: {
                this.procDiosetbit(found, args);
                break;
            }
            case 9: {
                this.procDioclrbit(found, args);
                break;
            }
            case 10: {
                this.procDioshow(found, args);
                break;
            }
            case 11: {
                this.procAdconfig(found, args);
                break;
            }
            case 12: {
                this.procAdsetchan(found, args);
                break;
            }
            case 13: {
                this.procAdsample(found, args);
                break;
            }
            case 14: {
                this.procAdscan(found, args);
                break;
            }
            case 15: {
                this.procAdctov(found, args);
                break;
            }
            case 16: {
                this.procAdvtoc(found, args);
                break;
            }
            case 17: {
                this.procAdshow(found, args);
                break;
            }
            case 18: {
                this.procDaconfig(found, args);
                break;
            }
            case 19: {
                this.procDasetgain(found, args);
                break;
            }
            case 20: {
                this.procDaoutput(found, args);
                break;
            }
            case 21: {
                this.procDaupdate(found, args);
                break;
            }
            case 22: {
                this.procDavtoc(found, args);
                break;
            }
            case 23: {
                this.procDactov(found, args);
                break;
            }
            case 24: {
                this.procDashow(found, args);
                break;
            }
            case 25: {
                this.procIntattach(found, args);
                break;
            }
            case 26: {
                this.procIntdetach(found, args);
                break;
            }
            case 27: {
                this.procCntrstart(found, args);
                break;
            }
            case 28: {
                this.procCntrstop(found, args);
                break;
            }
            case 29: {
                this.procCntrshow(found, args);
                break;
            }
            default: {
                this.out.println((Object)"Command not fully implemented");
            }
        }
        return true;
    }

    private void procInit(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.baseAddr = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.irqLevel = (Integer)args[1];
        }
        this.hel.init(this.baseAddr, this.irqLevel);
        this.dioConf = this.hel.dioGetConfig();
        int[] chans = this.hel.adGetChans();
        this.adLowChan = chans[0];
        this.adHighChan = chans[1];
        this.adGain = this.hel.adGetGain();
        this.adUnip = this.hel.adIsUnipolar();
        this.adDiff = this.hel.adIsDifferential();
        this.daUnip = this.hel.daIsUnipolar();
        this.daSimUp = this.hel.daIsSimUpdate();
        this.daHiRes = this.hel.daIsHighRes();
    }

    private void procShow(int found, Object[] args) {
        this.out.println((Object)"Initialization parameters:");
        this.out.format("  Base address     = %04x\n", new Object[]{this.baseAddr});
        this.out.format("  Card size        = %04x\n", new Object[]{16});
        this.out.println((Object)("  IRQ level        = " + this.irqLevel));
    }

    private void procRegshow(int found, Object[] args) {
        int r;
        int p;
        int r2;
        int[] regs = new int[24];
        for (r2 = 0; r2 < 12; ++r2) {
            regs[r2] = this.hel.readB(r2);
        }
        for (p = 0; p < 3; ++p) {
            this.hel.writeB(1, p);
            for (r = 12; r < 16; ++r) {
                regs[4 * p + r] = this.hel.readB(r);
            }
        }
        this.out.println((Object)"Main registers:");
        for (r2 = 0; r2 < 12; ++r2) {
            if ((r2 == 5 || r2 == 6) && (regs[20] & 1) != 0) {
                this.out.format("  %2s: %02x  %s\n", new Object[]{r2, regs[r2], regDesc[r2 + 19]});
                continue;
            }
            this.out.format("  %2s: %02x  %s\n", new Object[]{r2, regs[r2], regDesc[r2]});
        }
        for (p = 0; p < 3; ++p) {
            this.out.format("\nPage %s: %s\n", new Object[]{p, pageDesc[p]});
            for (r = 12; r < 16; ++r) {
                int ri = 4 * p + r;
                this.out.format("  %2s: %02x  %s\n", new Object[]{r, regs[ri], regDesc[ri]});
            }
        }
    }

    private void procDioconfig(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioConf = (Integer)args[0];
        }
        this.hel.dioConfig(this.dioConf);
    }

    private void procDioin(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Integer)args[0];
        }
        int value = this.hel.dioInp(this.dioPort);
        this.out.format("Value = 0x%02x\n", new Object[]{value});
    }

    private void procDioout(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dioValue = (Integer)args[1];
        }
        this.hel.dioOut(this.dioPort, this.dioValue);
    }

    private void procDioinbit(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dioBit = (Integer)args[1];
        }
        int value = this.hel.dioInpBit(this.dioPort, this.dioBit);
        this.out.println((Object)("Value = " + value));
    }

    private void procDiooutbit(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dioBit = (Integer)args[1];
        }
        if ((found & 4) != 0) {
            this.dioValue = (Integer)args[2];
        }
        this.hel.dioOutBit(this.dioPort, this.dioBit, this.dioValue);
    }

    private void procDiosetbit(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dioBit = (Integer)args[1];
        }
        this.hel.dioSetBit(this.dioPort, this.dioBit);
    }

    private void procDioclrbit(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dioBit = (Integer)args[1];
        }
        this.hel.dioClrBit(this.dioPort, this.dioBit);
    }

    private void procDioshow(int found, Object[] args) {
        this.out.println((Object)"Digital I/O parameters:");
        this.out.format("  Configuration = %02x\n", new Object[]{this.dioConf});
        this.out.println((Object)("  Port          = " + this.dioPort));
        this.out.format("  Output value  = %02x\n", new Object[]{this.dioValue});
        this.out.println((Object)("  Bit number    = " + this.dioBit));
    }

    private void procAdconfig(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.adGain = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            boolean bl = this.adUnip = (Integer)args[1] != 0;
        }
        if ((found & 4) != 0) {
            this.adDiff = (Integer)args[2] != 0;
        }
        this.hel.adConfig(this.adGain, this.adUnip, this.adDiff);
    }

    private void procAdsetchan(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.adLowChan = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.adHighChan = (Integer)args[1];
        }
        this.hel.adSetChans(this.adLowChan, this.adHighChan);
    }

    private void procAdsample(int found, Object[] args) {
        int chan = this.hel.adGetCurrChan();
        short value = this.hel.adSample();
        float volts = this.hel.adCountToVolts(value);
        this.out.format("Channel %s: %04x ", new Object[]{chan, value});
        if ((double)volts > -1.0 && (double)volts < 1.0) {
            this.out.format("(%.5f)\n", new Object[]{Float.valueOf(volts)});
        } else {
            this.out.format("(%.6g)\n", new Object[]{Float.valueOf(volts)});
        }
    }

    private void procAdscan(int found, Object[] args) {
        short[] value = new short[16];
        int count = this.hel.adScan(value);
        for (int j = 0; j < count; ++j) {
            int chan = this.adLowChan + j;
            if (chan >= 16) {
                chan -= 16;
            }
            if (j > 0) {
                this.out.print((Object)((j & 3) == 0 ? "\n" : " "));
            }
            float volts = this.hel.adCountToVolts(value[j]);
            this.out.format("%2s: %04x ", new Object[]{chan, value[j]});
            if ((double)volts > -1.0 && (double)volts < 1.0) {
                this.out.format("(% -8.5f)", new Object[]{Float.valueOf(volts)});
                continue;
            }
            this.out.format("(% -8.6g)", new Object[]{Float.valueOf(volts)});
        }
        this.out.println();
    }

    private void procAdctov(int found, Object[] args) {
        float volts = this.hel.adCountToVolts((Short)args[0]);
        if ((double)volts > -1.0 && (double)volts < 1.0) {
            this.out.format("Value = %.5f\n", new Object[]{Float.valueOf(volts)});
        } else {
            this.out.format("Value = %.6g\n", new Object[]{Float.valueOf(volts)});
        }
    }

    private void procAdvtoc(int found, Object[] args) {
        short count = this.hel.adVoltsToCount(((Float)args[0]).floatValue());
        this.out.format("Value = %04x\n", new Object[]{count});
    }

    private void procAdshow(int found, Object[] args) {
        this.out.println((Object)"A/D Parameters:");
        this.out.println((Object)("  Gain setting       = " + this.adGain));
        this.out.println((Object)("  Unipolar input     = " + this.adUnip));
        this.out.println((Object)("  Differential input = " + this.adDiff));
        this.out.println((Object)("  Low channel        = " + this.adLowChan));
        this.out.println((Object)("  High channel       = " + this.adHighChan));
    }

    private void procDaconfig(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.daGain = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            boolean bl = this.daUnip = (Integer)args[1] != 0;
        }
        if ((found & 4) != 0) {
            boolean bl = this.daSimUp = (Integer)args[2] != 0;
        }
        if ((found & 8) != 0) {
            this.daHiRes = (Integer)args[3] != 0;
        }
        this.hel.daConfig(this.daGain, this.daUnip, this.daSimUp, this.daHiRes);
    }

    private void procDasetgain(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.daChan = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.daGain = (Integer)args[1];
        }
        this.hel.daSetGain(this.daChan, this.daGain);
    }

    private void procDaoutput(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.daChan = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.daCode = (Integer)args[1];
        }
        this.hel.daOutput(this.daChan, this.daCode);
    }

    private void procDaupdate(int found, Object[] args) {
        this.hel.daUpdate();
    }

    private void procDavtoc(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.daChan = (Integer)args[0];
        }
        this.daCode = this.hel.daVoltsToCode(this.daChan, ((Float)args[1]).floatValue());
        this.out.format("Value = %04x\n", new Object[]{this.daCode});
    }

    private void procDactov(int found, Object[] args) {
        float volts;
        if ((found & 1) != 0) {
            this.daChan = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.daCode = (Integer)args[1];
        }
        if ((double)(volts = this.hel.daCodeToVolts(this.daChan, this.daCode)) > -1.0 && (double)volts < 1.0) {
            this.out.format("Value = %.5f\n", new Object[]{Float.valueOf(volts)});
        } else {
            this.out.format("Value = %.6g\n", new Object[]{Float.valueOf(volts)});
        }
    }

    private void procDashow(int found, Object[] args) {
        this.out.println((Object)"D/A Parameters:");
        this.out.println((Object)("  Gain setting        = " + this.daGain));
        this.out.println((Object)("  Unipolar output     = " + this.daUnip));
        this.out.println((Object)("  Simultaneous update = " + this.daSimUp));
        this.out.println((Object)("  High resolution     = " + this.daHiRes));
        this.out.println((Object)("  Channel             = " + this.daChan));
        this.out.println((Object)("  Code                = " + this.daCode));
    }

    private void procIntattach(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.intMask = (Integer)args[0];
        }
        this.hel.attachInt(0, 3, 7, 112, 0, 7, 0, this, "reportInt", this.hel);
        this.hel.updateB(4, 7, this.intMask);
    }

    private void procIntdetach(int found, Object[] args) {
        this.hel.updateB(4, 7, 0);
        this.hel.detachInt(0);
    }

    private void procCntrstart(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.cntrRate = ((Float)args[0]).floatValue();
        }
        this.cntrStart = this.cntrLast = System.nanoTime();
        this.cntrSavst = this.cntrLast;
        this.cntrStop = 0L;
        this.cntrCount = 0;
        this.cntrSaved = 0;
        this.hel.cntrConfig(this.cntrRate, false);
        this.hel.cntrEnable(this, "cntrProc", null);
        this.hel.cntrStart();
    }

    private void procCntrstop(int found, Object[] args) {
        this.hel.cntrDisable();
        this.cntrStop = System.nanoTime();
    }

    private void procCntrshow(int found, Object[] args) {
        int option = (found & 1) != 0 ? (Integer)args[0] : 0;
        boolean times = (option & 1) != 0;
        boolean counts = (option & 2) != 0;
        boolean comb = (option & 4) != 0;
        long intvl = this.cntrStop;
        float rate = 0.0f;
        int count = this.cntrCount;
        if (intvl == 0L) {
            intvl = System.nanoTime();
        }
        if ((intvl -= this.cntrStart) != 0L) {
            rate = 1.0E9f * (float)count / (float)intvl;
        }
        this.out.println((Object)"Interrupt Parameters:");
        this.out.println((Object)("  Req. Rate    = " + this.cntrRate));
        this.out.println((Object)("  Count        = " + this.cntrCount));
        this.out.println((Object)("  Actual Rate  = " + rate));
        if (times) {
            this.out.print((Object)"  Interval samples (nsec):");
            long prev = this.cntrSavst;
            for (int j = 0; j < this.cntrSaved; ++j) {
                if ((j & 3) == 0) {
                    this.out.println();
                }
                this.out.format("%14s", new Object[]{this.cntrTimes[j] - prev});
                prev = this.cntrTimes[j];
            }
            this.out.println();
        }
        if (counts) {
            this.out.print((Object)"  Counter samples:");
            for (int j = 0; j < this.cntrSaved; ++j) {
                if ((j & 7) == 0) {
                    this.out.println();
                }
                this.out.format("%7s", new Object[]{this.cntrCounts[j]});
            }
            this.out.println();
        }
        if (comb) {
            int j;
            this.out.println((Object)"  Combined samples:");
            for (j = 0; j < 2; ++j) {
                this.out.format("%13s %5s %8s %8s", new Object[]{"Intvl(ns)", "Cntr", "Dvn(ns)", "Dly(ns)"});
            }
            this.out.println();
            for (j = 0; j < 2; ++j) {
                this.out.format("%13s %5s %8s %8s", new Object[]{"---------", "----", "-------", "-------"});
            }
            long prev = this.cntrSavst;
            int expTime = (int)(1.0E9 / (double)this.cntrRate);
            boolean low = (this.hel.readB(4) & 0x40) != 0;
            int mult = 1000000000 / (low ? 100000 : 10000000);
            int cntMax = expTime / mult;
            for (int j2 = 0; j2 < this.cntrSaved; ++j2) {
                if ((j2 & 1) == 0) {
                    this.out.println();
                }
                int period = (int)(this.cntrTimes[j2] - prev);
                int delay = cntMax - this.cntrCounts[j2];
                if (delay < 0) {
                    delay += 65536;
                }
                this.out.format("%13s %5s %8s %8s", new Object[]{period, this.cntrCounts[j2], period - expTime, mult * delay});
                prev = this.cntrTimes[j2];
            }
            this.out.println();
        }
        if (times || counts || comb) {
            this.cntrSaved = 0;
            this.cntrSavst = this.cntrLast;
        }
    }

    private void reportInt(int value, Object parm) {
        Helios heli = (Helios)parm;
        this.out.format("Flags = %02x, DIO lines = %06x\n", new Object[]{value, heli.readL(8) & 0xFFFFFF});
    }

    private void cntrProc(int value, Object parm) {
        this.cntrLast = System.nanoTime();
        if (this.cntrSaved < 64) {
            this.cntrTimes[this.cntrSaved] = this.cntrLast;
            this.cntrCounts[this.cntrSaved++] = this.hel.cntrRead();
        }
        ++this.cntrCount;
    }

    static {
        cmnd.add("init", 0, helpInit, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("show", 1, helpShow, "", new CmndProcess.Lookup[0]);
        cmnd.add("regshow", 2, helpRegshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("dioconfig", 3, helpDioconfig, "i", new CmndProcess.Lookup[0]);
        cmnd.add("dioin", 4, helpDioin, "i", new CmndProcess.Lookup[0]);
        cmnd.add("dioout", 5, helpDioout, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("dioinbit", 6, helpDioinbit, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("diooutbit", 7, helpDiooutbit, "iii", new CmndProcess.Lookup[0]);
        cmnd.add("diosetbit", 8, helpDiosetbit, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("dioclrbit", 9, helpDioclrbit, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("dioshow", 10, helpDioshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("adconfig", 11, helpAdconfig, "iii", new CmndProcess.Lookup[0]);
        cmnd.add("adsetchan", 12, helpAdsetchan, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("adsample", 13, helpAdsample, "", new CmndProcess.Lookup[0]);
        cmnd.add("adscan", 14, helpAdscan, "", new CmndProcess.Lookup[0]);
        cmnd.add("adctov", 15, helpAdctov, "W", new CmndProcess.Lookup[0]);
        cmnd.add("advtoc", 16, helpAdvtoc, "F", new CmndProcess.Lookup[0]);
        cmnd.add("adshow", 17, helpAdshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("daconfig", 18, helpDaconfig, "iiii", new CmndProcess.Lookup[0]);
        cmnd.add("dasetgain", 19, helpDasetgain, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("daoutput", 20, helpDaoutput, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("daupdate", 21, helpDaupdate, "", new CmndProcess.Lookup[0]);
        cmnd.add("davtoc", 22, helpDavtoc, "iF", new CmndProcess.Lookup[0]);
        cmnd.add("dactov", 23, helpDactov, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("dashow", 24, helpDashow, "", new CmndProcess.Lookup[0]);
        cmnd.add("intattach", 25, helpIntattach, "i", new CmndProcess.Lookup[0]);
        cmnd.add("intdetach", 26, helpIntdetach, "", new CmndProcess.Lookup[0]);
        cmnd.add("cntrstart", 27, helpCntrstart, "f", new CmndProcess.Lookup[0]);
        cmnd.add("cntrstop", 28, helpCntrstop, "", new CmndProcess.Lookup[0]);
        cmnd.add("cntrshow", 29, helpCntrshow, "", new CmndProcess.Lookup[0]);
        regDesc = new String[]{"| AD7  | AD6  | AD5  | AD4  | AD3  | AD2  | AD1  | AD0  |", "| AD15 | AD14 | AD13 | AD12 | AD11 | AD10 | AD9  | AD8  |", "|  H3  |  H2  |  H1  |  H0  |  L3  |  L2  |  L1  |  L0  |", "|ADBUSY|SE/DIF|ADWAIT|DACBSY|  OF  |SCANEN| ADG1 | ADG0 |", "|CKSEL1|FRQSL1|FRQSL0|ADCLK |  -   |TINTE |DINTE |AINTE |", "|  -   |  -   | FT5  | FT4  | FT3  | FT2  | FT1  | FT0  |", "|  -   |  -   | FD5  | FD4  | FD3  | FD2  | FD1  | FD0  |", "|  -   | TINT | DINT | AINT |ADCH3 |ADCH2 |ADCH1 |ADCH0 |", "|  A7  |  A6  |  A5  |  A4  |  A3  |  A2  |  A1  |  A0  |", "|  B7  |  B6  |  B5  |  B4  |  B3  |  B2  |  B1  |  B0  |", "|  C7  |  C6  |  C5  |  C4  |  C3  |  C2  |  C1  |  C0  |", "|DIOCTR|DAMODE|DASIM | DIRA |DIRCH |  -   | DIRB |DIRCL |", "|CTRD7 |CTRD6 |CTRD5 |CTRD4 |CTRD3 |CTRD2 |CTRD1 |CTRD0 |", "|CTRD15|CTRD14|CTRD13|CTRD12|CTRD11|CTRD10|CTRD9 |CTRD8 |", "|CTRD23|CTRD22|CTRD21|CTRD20|CTRD19|CTRD18|CTRD17|CTRD16|", "|                  FPGA Revision Code                   |", "|  D7  |  D6  |  D5  |  D4  |  D3  |  D2  |  D1  |  D0  |", "|  A7  |  A6  |  A5  |  A4  |  A3  |  A2  |  A1  |  A0  |", "|  -   |TDBUSY|EEBUSY|CALMUX|  -   |  -   |  -   |  -   |", "|                       Not Used                        |", "|  -   |  -   |  -   |  -   |  -   |  -   |  -   |EXFIFO|", "| DAUR |DACH1 |DACH0 |  -   |ADPOL |  -   | ADSD |  -   |", "|  -   |  -   |  -   |DASIZE|DAPOL |  -   | DAG1 | DAG0 |", "|                D/A Simultaneous Update                |", "| FD07 | FD06 | FD05 | FD04 | FD03 | FD02 | FD01 | FD00 |", "| FD11 | FD10 | FD09 | FD08 |  OF  |  FF  |  HF  |  EF  |"};
        pageDesc = new String[]{"Counter/Timer Access", "AutoCal Control", "Expanded FIFO and AD/DA Control"};
    }
}

