/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.iocard;

import org.lsst.ccs.drivers.iocard.AccesDio;
import org.lsst.ccs.drivers.iocard.TestIocard;
import org.lsst.ccs.utilities.sa.CmndProcess;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestAccesDio
implements CmndProcess.Dispatch {
    private static final int CMD_INIT = 0;
    private static final int CMD_DIOCONF = 1;
    private static final int CMD_DIOIN = 2;
    private static final int CMD_DIOOUT = 3;
    private static final int CMD_DIOINBIT = 4;
    private static final int CMD_DIOOUTBIT = 5;
    private static final int CMD_DIOSETBIT = 6;
    private static final int CMD_DIOCLRBIT = 7;
    private static final int CMD_DIOSHOW = 8;
    private static final int CMD_INTATTACH = 9;
    private static final int CMD_INTDETACH = 10;
    private static final int CMD_INTSTART = 11;
    private static final int CMD_INTSTOP = 12;
    private static final int CMD_INTSHOW = 13;
    private static final int CMD_SHOW = 14;
    private static final int CMD_REGSHOW = 15;
    private static final int NUM_CMDS = 16;
    private static final String[] helpInit = new String[]{"Initialize Acces DIO card. Omit the parameters to scan the PCI device tree.", "init <addr> <irq>", "addr   The base address of the card (0x340 for ISA)", "irq    The IRQ level of the card (6 for ISA)"};
    private static final String[] helpShow = new String[]{"Show initialization parameters", "show"};
    private static final String[] helpRegshow = new String[]{"Show register contents", "regshow"};
    private static final String[] helpDioconf = new String[]{"Set digital I/O configuration register (set ", "dioconf <mask>", "mask    which are inputs: 1=C low, 2=B, 8=C high, 16=A"};
    private static final String[] helpDioin = new String[]{"Read and display a byte from a digital I/O port", "dioin <port>", "port    The digital I/O port to read (0=A, 1=B, 2=C)"};
    private static final String[] helpDioout = new String[]{"Write a byte to a digital I/O port", "dioout <port> <value>", "port    The digital I/O port to write to (0=A, 1=B, 2=C)", "value   The value to write"};
    private static final String[] helpDioinbit = new String[]{"Read and display a bit from a digital I/O port", "dioinbit <port> <bitnum>", "port    The digital I/O port to read (0=A, 1=B, 2=C)", "bitnum  The number of the bit to read"};
    private static final String[] helpDiooutbit = new String[]{"Write a bit to a digital I/O port", "diooutbit <port> <bitnum> <value>", "port    The digital I/O port to write to (0=A, 1=B, 2=C)", "bitnum  The number of the bit to write", "value   The value to set the bit to"};
    private static final String[] helpDiosetbit = new String[]{"Set a bit in a digital I/O port", "diosetbit <port> <bitnum>", "port    The digital I/O port to write to (0=A, 1=B, 2=C)", "bitnum  The number of the bit to set"};
    private static final String[] helpDioclrbit = new String[]{"Clear a bit in a digital I/O port", "dioclrbit <port> <bitnum>", "port    The digital I/O port to write to (0=A, 1=B, 2=C)", "bitnum  The number of the bit to clear"};
    private static final String[] helpDioshow = new String[]{"Show the current digital I/O parameters", "dioshow"};
    private static final String[] helpIntattach = new String[]{"Attach to interrupt processing", "intattach <pmask>", "pmask  A bit mask of the ports to trigger interrupts (1=A, 2=B, 4=C) (inverted on the card)"};
    private static final String[] helpIntdetach = new String[]{"Detach from interrupt processing", "intdetach"};
    private static final CmndProcess.Command cmnd = new CmndProcess.Command(16);
    private final Output out;
    private final AccesDio acc;
    private final CmndProcess proc;
    private final TestIocard tioc;
    private int baseAddr = -1;
    private int irqLevel = -1;
    private int dioPort = 0;
    private int dioConf = 0;
    private int dioValue = 0;
    private int dioBit = 0;
    private int intPort = 0;
    private int intMask = 7;
    private static final String[] regDesc;

    private TestAccesDio(Output out, CmndProcess proc, TestIocard tioc, AccesDio acc) {
        this.out = out;
        this.proc = proc;
        this.tioc = tioc;
        this.acc = acc;
    }

    public static TestAccesDio newInstance(Output out) {
        Output lout = out != null ? out : new ConsOut();
        CmndProcess proc = new CmndProcess();
        AccesDio acc = new AccesDio();
        TestIocard tioc = TestIocard.newInstance(acc, proc, out);
        TestAccesDio obj = new TestAccesDio(lout, proc, tioc, acc);
        return obj;
    }

    public void addAsDispatcher() {
        this.proc.add((CmndProcess.Dispatch)this, cmnd);
        this.tioc.addAsDispatcher();
    }

    public static TestAccesDio newInstance() {
        return TestAccesDio.newInstance(null);
    }

    public static void main(String[] args) {
        TestAccesDio acc = TestAccesDio.newInstance();
        acc.addAsDispatcher();
        acc.tioc.run();
        System.exit(0);
    }

    public boolean dispatch(int code, int found, Object[] args) {
        switch (code) {
            case 0: {
                this.procInit(found, args);
                break;
            }
            case 14: {
                this.procShow(found, args);
                break;
            }
            case 15: {
                this.procRegshow(found, args);
                break;
            }
            case 1: {
                this.procDioconf(found, args);
                break;
            }
            case 2: {
                this.procDioin(found, args);
                break;
            }
            case 3: {
                this.procDioout(found, args);
                break;
            }
            case 4: {
                this.procDioinbit(found, args);
                break;
            }
            case 5: {
                this.procDiooutbit(found, args);
                break;
            }
            case 6: {
                this.procDiosetbit(found, args);
                break;
            }
            case 7: {
                this.procDioclrbit(found, args);
                break;
            }
            case 8: {
                this.procDioshow(found, args);
                break;
            }
            case 9: {
                this.procIntattach(found, args);
                break;
            }
            case 10: {
                this.procIntdetach(found, args);
                break;
            }
            default: {
                this.out.println((Object)"Command not fully implemented");
            }
        }
        return true;
    }

    private void procInit(int found, Object[] args) {
        this.baseAddr = (found & 1) != 0 ? (Integer)args[0] : -1;
        this.irqLevel = (found & 2) != 0 ? (Integer)args[1] : -1;
        this.acc.init(this.baseAddr, this.irqLevel);
    }

    private void procShow(int found, Object[] args) {
        try {
            this.out.println((Object)"Card parameters:");
            this.out.format("  Base address     = %#6x\n", new Object[]{this.acc.getBase()});
            this.out.format("  Card size        = %#6x\n", new Object[]{this.acc.getNregs()});
            this.out.format("  IRQ level        = %6d\n", new Object[]{this.acc.getIrq()});
        }
        catch (NullPointerException exc) {
            this.out.println((Object)"Card not initialized!");
        }
    }

    private void procRegshow(int found, Object[] args) {
        this.out.format("  %2s: %02x  %s\n", new Object[]{0, this.acc.readB(0), regDesc[0]});
        this.out.format("  %2s: %02x  %s\n", new Object[]{1, this.acc.readB(1), regDesc[1]});
        this.out.format("  %2s: %02x  %s\n", new Object[]{2, this.acc.readB(2), regDesc[2]});
        this.out.format("  %2s: %02x  %s\n", new Object[]{3, this.acc.readB(3), regDesc[3]});
    }

    private void procDioconf(int found, Object[] args) {
        int enableDirectionSetting = 128;
        if ((found & 1) != 0) {
            this.dioConf = (Integer)args[0];
        }
        this.acc.dioConfig(this.dioConf | 0x80);
    }

    private void procDioin(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Integer)args[0];
        }
        int value = this.acc.dioInp(this.dioPort);
        this.out.format("Value = 0x%02x\n", new Object[]{value});
    }

    private void procDioout(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dioValue = (Integer)args[1];
        }
        this.acc.dioOut(this.dioPort, this.dioValue);
    }

    private void procDioinbit(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dioBit = (Integer)args[1];
        }
        int value = this.acc.dioInpBit(this.dioPort, this.dioBit);
        this.out.println((Object)("Value = " + value));
    }

    private void procDiooutbit(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dioBit = (Integer)args[1];
        }
        if ((found & 4) != 0) {
            this.dioValue = (Integer)args[2];
        }
        this.acc.dioOutBit(this.dioPort, this.dioBit, this.dioValue);
    }

    private void procDiosetbit(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dioBit = (Integer)args[1];
        }
        this.acc.dioSetBit(this.dioPort, this.dioBit);
    }

    private void procDioclrbit(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dioBit = (Integer)args[1];
        }
        this.acc.dioClrBit(this.dioPort, this.dioBit);
    }

    private void procDioshow(int found, Object[] args) {
        this.out.println((Object)"Digital I/O parameters:");
        this.out.format("  Configuration = %02x\n", new Object[]{this.dioConf});
        this.out.println((Object)("  Port          = " + this.dioPort));
        this.out.format("  Output value  = %02x\n", new Object[]{this.dioValue});
        this.out.println((Object)("  Bit number    = " + this.dioBit));
    }

    private void procIntattach(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.intMask = (Integer)args[0];
        }
        this.acc.attachInt(this.intMask, this, "reportInt", this.acc);
    }

    private void procIntdetach(int found, Object[] args) {
        this.acc.detachInt();
    }

    private void reportInt(int value, Object parm) {
        AccesDio dio = (AccesDio)parm;
        this.out.format("Interrupt! A B C = %03x %03x %03x\n", new Object[]{dio.readB(0), dio.readB(1), dio.readB(2)});
    }

    static {
        cmnd.add("init", 0, helpInit, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("show", 14, helpShow, "", new CmndProcess.Lookup[0]);
        cmnd.add("regshow", 15, helpRegshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("dioconf", 1, helpDioconf, "i", new CmndProcess.Lookup[0]);
        cmnd.add("dioin", 2, helpDioin, "i", new CmndProcess.Lookup[0]);
        cmnd.add("dioout", 3, helpDioout, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("dioinbit", 4, helpDioinbit, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("diooutbit", 5, helpDiooutbit, "iii", new CmndProcess.Lookup[0]);
        cmnd.add("diosetbit", 6, helpDiosetbit, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("dioclrbit", 7, helpDioclrbit, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("dioshow", 8, helpDioshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("intattach", 9, helpIntattach, "i", new CmndProcess.Lookup[0]);
        cmnd.add("intdetach", 10, helpIntdetach, "", new CmndProcess.Lookup[0]);
        regDesc = new String[]{"| A7 | A6 | A5 | A4 | A3 | A2 | A1 | A0 | port bits", "| B7 | B6 | B5 | B4 | B3 | B2 | B1 | B0 | port bits", "| C7 | C6 | C5 | C4 | C3 | C2 | C1 | C0 | port bits", "|    |    |    |  A |C hi|    |  B |C lo| direction, 1 for input"};
    }
}

