/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.iocard;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class PciCard {
    private final List<Resource> resources;
    private final int irq;
    private static final String PCI_DEVICES = "/sys/bus/pci/devices/";

    private PciCard(int irq, Stream<Resource> res) {
        this.irq = irq;
        this.resources = res.collect(Collectors.toList());
    }

    public List<Resource> getResources() {
        return Collections.unmodifiableList(this.resources);
    }

    public int getIrq() {
        return this.irq;
    }

    private static Stream<Resource> readResources(Reader rdr) {
        StreamTokenizer tkr = new StreamTokenizer(rdr);
        tkr.resetSyntax();
        tkr.eolIsSignificant(false);
        tkr.whitespaceChars(32, 32);
        tkr.whitespaceChars(10, 10);
        tkr.whitespaceChars(9, 9);
        tkr.wordChars(48, 57);
        tkr.wordChars(97, 102);
        tkr.wordChars(65, 70);
        tkr.wordChars(120, 120);
        tkr.wordChars(88, 88);
        LongStream.Builder lng = LongStream.builder();
        try {
            int tok = tkr.nextToken();
            while (tok != -1) {
                if (tok != -3) {
                    throw new Error("Badly formatted PCI resource description", null);
                }
                long val = Long.decode(tkr.sval);
                lng.accept(val);
                tok = tkr.nextToken();
            }
        }
        catch (IOException exc) {
            throw new Error("I/O error while reading PCI resource descriptions", exc);
        }
        Stream.Builder<Resource> res = Stream.builder();
        PrimitiveIterator.OfLong itr = lng.build().iterator();
        while (itr.hasNext()) {
            long bottom = (Long)itr.next();
            long top = (Long)itr.next();
            long flags = (Long)itr.next();
            if (flags == 0L) continue;
            res.accept(new Resource(bottom, top, flags));
        }
        return res.build();
    }

    /*
     * Exception decompiling
     */
    public static Optional<PciCard> fromGeographicAddress(String geo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Optional<PciCard> fromVendorId(int vid) {
        Optional<Path> pth = PciCard.pciDevices(dev -> PciCard.isFromVendor(dev, vid)).findFirst();
        if (pth.isPresent()) {
            return PciCard.fromGeographicAddress(PciCard.geographicAddress(pth.get()));
        }
        return Optional.empty();
    }

    private static Stream<Path> pciDevices(Predicate<Path> isWanted) {
        try {
            return Files.list(FileSystems.getDefault().getPath(PCI_DEVICES, new String[0])).filter(isWanted);
        }
        catch (IOException exc) {
            throw new Error("Error while scanning for PCI devices", exc);
        }
    }

    private static String geographicAddress(Path dev) {
        return dev.getName(dev.getNameCount() - 1).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isFromVendor(Path dev, int vid) {
        String geo = PciCard.geographicAddress(dev);
        try (FileReader vidrdr = new FileReader(dev.toString() + "/vendor");){
            boolean bl = vid == Integer.decode(new BufferedReader(vidrdr).readLine());
            return bl;
        }
        catch (IOException exc) {
            throw new Error("Error reading vendor ID for " + geo, exc);
        }
        catch (NumberFormatException exc) {
            throw new Error("Error parsing vendor ID for " + geo, exc);
        }
    }

    public String toString() {
        return Stream.concat(Stream.of(String.format("IRQ %d", this.irq)), this.resources.stream().map(Resource::toString)).collect(Collectors.joining("\n"));
    }

    public static void main(String[] arg) {
        Optional card1 = PciCard.fromGeographicAddress(arg[0]).flatMap(c -> Optional.of(c.toString()));
        Optional card2 = PciCard.fromVendorId(Integer.decode(arg[1])).flatMap(c -> Optional.of(c.toString()));
        System.out.println(card1.orElseGet(() -> "No PCI card at geo address " + arg[0]));
        System.out.println();
        System.out.println(card2.orElseGet(() -> "No PCI card from vendor " + arg[1]));
    }

    public static final class Resource {
        private final long bottom;
        private final long top;
        private final long flags;

        public Resource(long bottom, long top, long flags) {
            this.bottom = bottom;
            this.top = top;
            this.flags = flags;
        }

        public long start() {
            return this.bottom;
        }

        public long size() {
            return this.top - this.bottom + 1L;
        }

        public boolean isIOSpace() {
            return 0L != (this.flags & 1L);
        }

        public String toString() {
            return String.format("%s space at %#10x, size %8d", this.isIOSpace() ? "I/O   " : "Memory", this.start(), this.size());
        }
    }

    public static class Error
    extends RuntimeException {
        Error(String msg, Throwable originalCause) {
            super(msg, originalCause);
        }
    }
}

