/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.iocard;

import java.util.Optional;
import org.lsst.ccs.drivers.iocard.AccesDioException;
import org.lsst.ccs.drivers.iocard.Iocard;
import org.lsst.ccs.drivers.iocard.PciCard;

public final class AccesDio
extends Iocard {
    public static final int ISA_N_REGS = 25;
    public static final int PCI_N_REGS = 16;
    public static final int PORTA_REG = 0;
    public static final int PORTB_REG = 1;
    public static final int PORTC_REG = 2;
    public static final int CONF_REG = 3;
    public static final int SETUP_REG = 11;
    public static final int RESET_REG = 15;
    public static final int ISA_STATUS_AND_RESET_REG = 24;
    public static final int PCI_VENDOR_ID = 18767;
    public static final int PCI_MIN_IO_ADDR = 49152;
    private static final int[] dioConf = new int[]{128, 144, 130, 146, 129, 145, 131, 147, 136, 152, 138, 154, 137, 153, 139, 155};
    private CardInfo card;

    public AccesDio(int base, int irq) {
        this.card = new CardInfo(base, irq);
        super.init(this.card.base, this.card.nregs, this.card.irq);
    }

    public AccesDio() {
        this.card = null;
    }

    public void init(int base, int irq) {
        this.card = new CardInfo(base, irq);
        super.init(this.card.base, this.card.nregs, this.card.irq);
    }

    public int getIrq() {
        return this.card.irq;
    }

    public int getBase() {
        return this.card.base;
    }

    public int getNregs() {
        return this.card.nregs;
    }

    public void dioConfig(int value) {
        this.writeB(3, dioConf[value & 0xF]);
    }

    public int dioInp(int port) {
        if (port < 0 || port > 2) {
            this.throwInvPort();
        }
        return this.readB(port);
    }

    public void dioOut(int port, int value) {
        if (port < 0 || port > 2) {
            this.throwInvPort();
        }
        this.writeB(port, value);
    }

    public int dioInpBit(int port, int bit) {
        if (port < 0 || port > 2) {
            this.throwInvPort();
        }
        return this.readB(port) >> bit & 1;
    }

    public void dioOutBit(int port, int bit, int value) {
        if (port < 0 || port > 2) {
            this.throwInvPort();
        }
        this.updateB(port, 1 << bit, value << bit);
    }

    public void dioSetBit(int port, int bit) {
        if (port < 0 || port > 2) {
            this.throwInvPort();
        }
        int value = 1 << bit;
        this.updateB(port, value, value);
    }

    public void dioClrBit(int port, int bit) {
        if (port < 0 || port > 2) {
            this.throwInvPort();
        }
        this.updateB(port, 1 << bit, 0);
    }

    public void attachInt(int mask, Object cbObj, String cbMeth, Object cbParm) {
        if (this.card.isPCI) {
            super.attachInt(0, 2, 0, 0, 15, 0, 0, cbObj, cbMeth, cbParm);
        } else {
            super.attachInt(0, 1, 24, 15, 24, 0, 0, cbObj, cbMeth, cbParm);
        }
        this.writeB(11, 7 ^ mask);
    }

    public void detachInt() {
        this.writeB(11, 7);
        super.detachInt(0);
    }

    private void throwInvPort() {
        throw new AccesDioException("Invalid port number");
    }

    private static final class CardInfo {
        final int irq;
        final int base;
        final int nregs;
        final boolean isPCI;

        CardInfo(int base, int irq) {
            if (base >= 0) {
                this.irq = irq;
                this.base = base;
                this.isPCI = base >= 49152;
                this.nregs = this.isPCI ? 16 : 25;
            } else {
                Optional<PciCard> card = PciCard.fromVendorId(18767);
                if (card.isPresent()) {
                    this.irq = card.get().getIrq();
                    this.base = (int)card.get().getResources().get(2).start();
                    this.nregs = 16;
                    this.isPCI = true;
                } else {
                    throw new PciCard.Error("Can't find an Acces PCI card. Provide I/O addr and IRQ", null);
                }
            }
        }
    }
}

