/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.iocard;

import org.lsst.ccs.drivers.iocard.Iocard;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestHelios2 {
    private static final int BASE_ADDR = 640;
    private static final int IRQ_LEVEL = 5;
    private static final int N_REGS = 16;
    private static final int CTRL_REG = 0;
    private static final int PAGE_REG = 1;
    private static final int ENAB_REG = 4;
    private static final int TEST_REG = 7;
    private static final int CNTR_REG = 12;
    private static final int CCTRL_REG = 15;
    private static final Output out = new ConsOut();
    private Iocard ioc = new Iocard();

    public static void main(String[] args) {
        TestHelios2 test = new TestHelios2();
        test.run();
        System.exit(0);
    }

    public void run() {
        this.ioc.init(640, 16, 5);
        this.ioc.attachInt(105, 3, 7, 64, 0, 4, 0, this, "procIntr", null);
        int count = 10000;
        this.ioc.writeB(1, 0);
        this.ioc.writeB(15, 136);
        this.ioc.writeB(4, 68);
        this.ioc.writeW(12, count);
        this.ioc.writeB(15, 130);
        this.ioc.writeB(15, 132);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
        this.ioc.writeB(15, 136);
        this.ioc.writeB(4, 64);
        this.ioc.detachInt(105);
        this.ioc.term();
    }

    void procIntr(int value, Object parm) {
        this.ioc.writeB(15, 192);
        out.format("Flag = %02x, Data = %04x\n", new Object[]{value, this.ioc.readW(12)});
    }
}

